---
generated_at: 2026-02-10 14:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-エクスポート無効通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_impexp.ts` 112-125行目（cantExport関数）
- E-02: `src/static/js/pad_impexp.ts` 148-166行目（exportAvailableによるリンク制御）
- E-03: `src/static/js/pad_impexp.ts` 171行目（disabledexportイベント設定）
- E-04: `src/locales/en.json` 208行目（pad.impexp.exportdisabled メッセージ）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | cantExport関数がアラート表示を処理する | E-01 | ○ |
| C-02 | クラス名からエクスポート形式を判定する | E-01 | ○ |
| C-03 | html10n.getで国際化メッセージを取得する | E-01, E-04 | ○ |
| C-04 | alert()でダイアログを表示する | E-01 | ○ |
| C-05 | return falseでリンク遷移を防止する | E-01 | ○ |
| C-06 | clientVars.exportAvailableでリンク制御を行う | E-02 | ○ |
| C-07 | 'no'の場合Word/PDF/ODFリンクが削除される | E-02 | ○ |
| C-08 | 'withoutPDF'の場合PDFリンクのみ削除される | E-02 | ○ |
| C-09 | disabledexportクラスにイベントが設定される | E-03 | ○ |
| C-10 | メッセージに{{type}}変数が含まれる | E-04 | ○ |
| C-11 | PDF/Microsoft Word/OpenDocumentの3形式が対象 | E-01 | ○ |
| C-12 | HTML/プレーンテキスト/Etherpad形式は常に利用可能 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] disabledexportクラスの付与ロジックが正しいか確認
- [ ] 国際化メッセージが全言語で提供されているか確認
- [ ] サーバー設定（abiword/soffice）とclientVars.exportAvailableの対応関係を確認
