---
generated_at: 2026-02-10 14:50:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-JavaScriptエラー通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_utils.ts` 398-471行目（setupGlobalExceptionHandler関数）
- E-02: `src/static/js/pad_utils.ts` 400-466行目（globalExceptionHandler関数）
- E-03: `src/static/js/pad_utils.ts` 404-412行目（ErrorEvent/PromiseRejectionEvent判定）
- E-04: `src/static/js/pad_utils.ts` 418行目（errorId生成）
- E-05: `src/static/js/pad_utils.ts` 421-425行目（重複チェック）
- E-06: `src/static/js/pad_utils.ts` 443-450行目（$.gritter.add呼び出し）
- E-07: `src/static/js/pad_utils.ts` 453-465行目（$.post '/jserror'）
- E-08: `src/static/js/pad.ts` 411行目（setupGlobalExceptionHandler呼び出し）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | setupGlobalExceptionHandler関数でグローバルエラーハンドラを設定する | E-01 | ○ |
| C-02 | pad.init()からsetupGlobalExceptionHandlerが呼び出される | E-08 | ○ |
| C-03 | ErrorEventとPromiseRejectionEventを区別して処理する | E-03 | ○ |
| C-04 | errorIdはrandomString(20)で生成される | E-04 | ○ |
| C-05 | 同一エラーメッセージが表示中の場合は通知をスキップする | E-05 | ○ |
| C-06 | $.gritter.addでスティッキー通知を表示する | E-06 | ○ |
| C-07 | タイトルは'An error occurred'である | E-06 | ○ |
| C-08 | class_nameは'error'である | E-06 | ○ |
| C-09 | positionは'bottom'である | E-06 | ○ |
| C-10 | sticky: trueで自動消去なしの設定 | E-06 | ○ |
| C-11 | $.postで/jserrorにエラーログを送信する | E-07 | ○ |
| C-12 | エラー情報にはerrorId, type, msg, url, source, linenumber, userAgent, stackが含まれる | E-07 | ○ |
| C-13 | document.createTextNodeでXSS対策を行う | E-02 | ○ |
| C-14 | window.onerrorはnullにクリアされる | E-01 | ○ |
| C-15 | window.addEventListenerでerrorとunhandledrejectionを監視する | E-01 | ○ |
| C-16 | Error.captureStackTraceが利用可能な場合はスタックトレースも含まれる | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）

- [ ] /jserrorエンドポイントのサーバー側実装が存在するか確認
- [ ] エラーログに機密情報が含まれないか確認
- [ ] 重複チェックのロジックが適切か確認
