---
generated_at: 2026-02-10 14:55:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-行作者情報通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/ace2_inner.ts` 2618-2651行目（Ctrl+Shift+2ハンドラ）
- E-02: `src/static/js/ace2_inner.ts` 2622行目（行番号取得）
- E-03: `src/static/js/ace2_inner.ts` 2623行目（alineAttrs取得）
- E-04: `src/static/js/ace2_inner.ts` 2630-2635行目（作者ID抽出）
- E-05: `src/static/js/ace2_inner.ts` 2637-2640行目（作者名変換）
- E-06: `src/static/js/ace2_inner.ts` 2642-2650行目（Gritter通知表示）
- E-07: `src/static/js/ace2_inner.ts` 2690-2691行目（Escキーでgritter.removeAll）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Ctrl+Shift+2（キーコード50）で作者情報を表示する | E-01 | ○ |
| C-02 | padShortcutEnabled.cmdShift2でショートカットの有効/無効を判定する | E-01 | ○ |
| C-03 | rep.selEnd[0]から現在の行番号を取得する | E-02 | ○ |
| C-04 | rep.alines[lineNumber]から行の属性情報を取得する | E-03 | ○ |
| C-05 | deserializeOpsで属性を解析する | E-04 | ○ |
| C-06 | AttributeMap.fromString().get('author')で作者IDを抽出する | E-04 | ○ |
| C-07 | pad.userList()から作者ID-名前のマップを作成する | E-05 | ○ |
| C-08 | 自分自身のIDはclientVars.userIdから取得する | E-05 | ○ |
| C-09 | 自分自身の場合は'me'と表示する | E-05 | ○ |
| C-10 | 不明な作者は'unknown'と表示する | E-05 | ○ |
| C-11 | $.gritter.addで通知を表示する | E-06 | ○ |
| C-12 | タイトルは'Line Authors'である | E-06 | ○ |
| C-13 | sticky: falseで表示時間は4000msである | E-06 | ○ |
| C-14 | Escキーで全てのGritter通知が閉じられる | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる
- コード内のTODOコメント（選択範囲サポート、i18n、レースコンディション）は将来の改善点

## 6) レビュアーチェックリスト（最小）

- [ ] padShortcutEnabled.cmdShift2のデフォルト値を確認
- [ ] 選択範囲サポートの必要性を検討
- [ ] 国際化（i18n）対応の必要性を検討
