---
generated_at: 2026-02-10 14:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-disconnected.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 54-86行目
- E-02: `src/static/js/pad_modals.ts` 35-51行目
- E-03: `src/static/js/pad.ts` 333-342行目, 664-688行目
- E-04: `src/static/js/pad_automatic_reconnect.ts` 5-18行目, 56-74行目, 113-123行目, 129-196行目
- E-05: `src/templates/pad.html` 304-311行目
- E-06: `src/locales/en.json` 151-153行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | disconnected通知は接続切断時に表示される | E-01, E-03 | ○ |
| C-02 | knownReasonsに該当しない場合フォールバック | E-01 (65-82行目) | ○ |
| C-03 | 既にdisconnectedの場合は重複処理しない | E-01 (55行目) | ○ |
| C-04 | with_reconnect_timerクラスで自動再接続有効 | E-04 (6行目), E-05 | ○ |
| C-05 | socket.on('message')でdisconnectを検出 | E-03 (333-334行目) | ○ |
| C-06 | handleChannelStateChangeでDISCONNECTED処理 | E-03 (664-688行目) | ○ |
| C-07 | タイトルは「You have been disconnected.」 | E-06 (151行目) | ○ |
| C-08 | 説明は「The connection to the server was lost」 | E-06 (152行目) | ○ |
| C-09 | 原因説明にサーバー不可用の記載 | E-06 (153行目) | ○ |
| C-10 | Force reconnectボタンがある | E-05 (309行目) | ○ |
| C-11 | 国際化キーpad.modals.disconnected使用 | E-05 (306行目), E-06 | ○ |
| C-12 | showCountDownTimerToReconnectOnModalが呼ばれる | E-02 (41行目) | ○ |
| C-13 | CountDownTimerクラスで実装 | E-04 (129-196行目) | ○ |
| C-14 | 再接続間隔が指数増加 | E-04 (117-121行目) | ○ |
| C-15 | clientVars.automaticReconnectionTimeout使用 | E-04 (57-58行目) | ○ |
| C-16 | キャンセルボタンでタイマー停止可能 | E-04 (11-13行目) | ○ |
| C-17 | status.whyに切断理由が保存される | E-01 (59行目) | ○ |
| C-18 | padeditor.disableが呼び出される | E-03 (683行目) | ○ |
| C-19 | padeditbar.disableが呼び出される | E-03 (684行目) | ○ |
| C-20 | padimpexp.disableが呼び出される | E-03 (685行目) | ○ |
| C-21 | 診断情報が収集される | E-03 (665-679行目) | ○ |
| C-22 | asyncSendDiagnosticInfoが呼び出される | E-03 (679行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] pad_connectionstatus.ts の disconnected 関数と knownReasons 配列を確認
- [ ] pad_automatic_reconnect.ts の自動再接続タイマー動作を確認
- [ ] pad.html の disconnected div の with_reconnect_timer クラスを確認
- [ ] 国際化キー pad.modals.disconnected.* が正しく設定されているか確認
