---
generated_at: 2026-02-10 15:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-ログイン失敗通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `admin/src/pages/LoginScreen.tsx` 7-10行目（Inputs型定義）
- E-02: `admin/src/pages/LoginScreen.tsx` 20-38行目（login関数）
- E-03: `admin/src/pages/LoginScreen.tsx` 21-25行目（fetch呼び出し）
- E-04: `admin/src/pages/LoginScreen.tsx` 27-32行目（エラー時setToastState）
- E-05: `admin/src/pages/LoginScreen.tsx` 33-34行目（成功時navigate）
- E-06: `admin/src/pages/LoginScreen.tsx` 44行目（form onSubmit）
- E-07: `admin/src/main.tsx` 25-26行目（/loginルート定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Loginボタンのクリックでログイン処理が実行される | E-06 | ○ |
| C-02 | fetch('/admin-auth/')でPOSTリクエストを送信する | E-03 | ○ |
| C-03 | Basic認証ヘッダーをbtoa()でエンコードして送信する | E-03 | ○ |
| C-04 | r.ok === falseの場合にsetToastStateを呼び出す | E-04 | ○ |
| C-05 | titleは'Login failed'である | E-04 | ○ |
| C-06 | success: falseで失敗フラグを設定する | E-04 | ○ |
| C-07 | open: trueで表示フラグを設定する | E-04 | ○ |
| C-08 | r.ok === trueの場合にnavigate('/')を呼び出す | E-05 | ○ |
| C-09 | Inputs型にusernameとpasswordが含まれる | E-01 | ○ |
| C-10 | login関数はSubmitHandler<Inputs>型である | E-02 | ○ |
| C-11 | ネットワークエラー時はconsole.errorにログ出力する | E-02 | ○ |
| C-12 | /loginルートでLoginScreenコンポーネントが表示される | E-07 | ○ |
| C-13 | handleSubmit(login)でフォーム送信を処理する | E-06 | ○ |
| C-14 | react-hook-formライブラリを使用している | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 全ての主張がソースコードで確認できる
- 1: 中リスク - ブルートフォース攻撃対策（サーバーサイド）の確認が必要

## 6) レビュアーチェックリスト（最小）

- [ ] サーバーサイドの認証処理（/admin-auth/）の実装を確認
- [ ] ブルートフォース攻撃対策（レート制限等）が実装されているか確認
- [ ] HTTPSでの通信が強制されているか確認（Basic認証のセキュリティ）
