---
generated_at: 2026-02-10 14:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-userdup.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 35-37行目, 54-86行目, 76行目
- E-02: `src/static/js/pad_modals.ts` 35-43行目, 45-48行目
- E-03: `src/static/js/pad.ts` 333-342行目
- E-04: `src/templates/pad.html` 253-258行目
- E-05: `src/locales/en.json` 119-121行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | userdup通知は重複ウィンドウ検出時に表示 | E-01, E-03 | ○ |
| C-02 | knownReasonsに'userdup'が含まれる | E-01 (76行目) | ○ |
| C-03 | 専用のモーダル(#connectivity .userdup)が表示される | E-04 (253行目) | ○ |
| C-04 | タイトルは「Opened in another window」 | E-05 (119行目) | ○ |
| C-05 | 説明でブラウザウィンドウでの重複を示す | E-05 (120行目) | ○ |
| C-06 | アドバイスで再接続を促す | E-05 (121行目) | ○ |
| C-07 | Force reconnectボタンがある | E-04 (257行目) | ○ |
| C-08 | Force reconnectでページリロード | E-01 (35-37行目) | ○ |
| C-09 | socket.on('message')で検出 | E-03 (333行目) | ○ |
| C-10 | obj.disconnectが'userdup'の場合に発動 | E-03 (333-334行目) | ○ |
| C-11 | socket.disconnect()が呼ばれる | E-03 (335行目) | ○ |
| C-12 | padeditor.disableが呼ばれる | E-03 (338行目) | ○ |
| C-13 | padeditbar.disableが呼ばれる | E-03 (339行目) | ○ |
| C-14 | padimpexp.disableが呼ばれる | E-03 (340行目) | ○ |
| C-15 | オーバーレイが表示される | E-01 (85行目), E-02 | ○ |
| C-16 | 国際化キーpad.modals.userdup使用 | E-04 (254行目), E-05 | ○ |
| C-17 | 自動再接続タイマーは付与されていない | E-04 (253行目でwith_reconnect_timerクラスなし) | ○ |
| C-18 | 既にdisconnectedの場合は重複処理しない | E-01 (55行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] pad_connectionstatus.ts の knownReasons に 'userdup' が含まれているか確認
- [ ] pad.html の userdup div にwith_reconnect_timerがないことを確認
- [ ] Force reconnect ボタンの動作（ページリロード）を確認
- [ ] 国際化キー pad.modals.userdup.* が正しく設定されているか確認
