---
generated_at: 2026-02-10 14:20:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-unauth.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 35-37行目, 54-86行目, 75行目
- E-02: `src/static/js/pad_modals.ts` 35-43行目, 45-48行目
- E-03: `src/static/js/pad.ts` 333-342行目
- E-04: `src/templates/pad.html` 259-263行目
- E-05: `src/locales/en.json` 123-124行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | unauth通知は権限変更時に表示 | E-01, E-03 | ○ |
| C-02 | knownReasonsに'unauth'が含まれる | E-01 (75行目) | ○ |
| C-03 | 専用のモーダル(#connectivity .unauth)が表示される | E-04 (259行目) | ○ |
| C-04 | タイトルは「Not authorized」 | E-05 (123行目) | ○ |
| C-05 | 説明で権限変更と再接続を促す | E-05 (124行目) | ○ |
| C-06 | Force reconnectボタンがある | E-04 (262行目) | ○ |
| C-07 | Force reconnectでページリロード | E-01 (35-37行目) | ○ |
| C-08 | socket.on('message')で検出 | E-03 (333行目) | ○ |
| C-09 | obj.disconnectが'unauth'の場合に発動 | E-03 (333-334行目) | ○ |
| C-10 | socket.disconnect()が呼ばれる | E-03 (335行目) | ○ |
| C-11 | padeditor.disableが呼ばれる | E-03 (338行目) | ○ |
| C-12 | padeditbar.disableが呼ばれる | E-03 (339行目) | ○ |
| C-13 | padimpexp.disableが呼ばれる | E-03 (340行目) | ○ |
| C-14 | オーバーレイが表示される | E-01 (85行目), E-02 | ○ |
| C-15 | 国際化キーpad.modals.unauth使用 | E-04 (260行目), E-05 | ○ |
| C-16 | 自動再接続タイマーは付与されていない | E-04 (259行目でwith_reconnect_timerクラスなし) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] pad_connectionstatus.ts の knownReasons に 'unauth' が含まれているか確認
- [ ] pad.html の unauth div にwith_reconnect_timerがないことを確認
- [ ] Force reconnect ボタンの動作（ページリロード）を確認
- [ ] 国際化キー pad.modals.unauth.* が正しく設定されているか確認
