---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-initsocketfail.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 54-86行目, 70行目
- E-02: `src/static/js/pad_modals.ts` 35-43行目, 45-48行目
- E-03: `src/static/js/pad.ts` 651-693行目
- E-04: `src/static/js/collab_client.ts` 47行目, 77-91行目, 85-86行目
- E-05: `src/templates/pad.html` 269-273行目
- E-06: `src/locales/en.json` 129-131行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | initsocketfail通知は初期接続失敗時に表示 | E-01, E-04 | ○ |
| C-02 | knownReasonsに'initsocketfail'が含まれる | E-01 (70行目) | ○ |
| C-03 | 専用のモーダル(#connectivity .initsocketfail)が表示される | E-05 (269行目) | ○ |
| C-04 | タイトルは「Server is unreachable.」 | E-06 (129行目) | ○ |
| C-05 | 説明で同期サーバーへの接続失敗を示す | E-06 (130行目) | ○ |
| C-06 | 原因でブラウザ/インターネット接続の問題を示唆 | E-06 (131行目) | ○ |
| C-07 | タイムアウト値は20秒 | E-04 (85行目) | ○ |
| C-08 | CONNECTING状態で20秒経過時にトリガー | E-04 (84-86行目) | ○ |
| C-09 | setChannelState('DISCONNECTED', 'initsocketfail')が呼ばれる | E-04 (86行目) | ○ |
| C-10 | handleChannelStateChangeで処理される | E-03 (651-693行目) | ○ |
| C-11 | Force reconnectボタンがない | E-05 (269-273行目にボタンなし) | ○ |
| C-12 | オーバーレイが表示される | E-01 (85行目), E-02 | ○ |
| C-13 | 国際化キーpad.modals.initsocketfail使用 | E-05 (270行目), E-06 | ○ |
| C-14 | 国際化キーpad.modals.initsocketfail.explanation使用 | E-05 (271行目), E-06 | ○ |
| C-15 | 国際化キーpad.modals.initsocketfail.cause使用 | E-05 (272行目), E-06 | ○ |
| C-16 | 自動再接続タイマーは付与されていない | E-05 (269行目でwith_reconnect_timerクラスなし) | ○ |
| C-17 | initialStartConnectTimeで開始時間を追跡 | E-04 (47行目, 85行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] collab_client.ts の20秒タイムアウトロジックを確認
- [ ] pad_connectionstatus.ts の knownReasons に 'initsocketfail' が含まれているか確認
- [ ] pad.html の initsocketfail div に Force reconnect ボタンがないことを確認
- [ ] 国際化キー pad.modals.initsocketfail.* が正しく設定されているか確認
