---
generated_at: 2026-02-10 14:35:00
metrics:
  claims_total: 19
  claims_with_evidence: 19
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-slowcommit.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：19 / 19、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 54-86行目, 74行目
- E-02: `src/static/js/pad_modals.ts` 35-43行目, 41行目, 45-48行目
- E-03: `src/static/js/collab_client.ts` 43行目, 46行目, 77-140行目, 94-99行目, 117-130行目, 142-150行目
- E-04: `src/static/js/pad_automatic_reconnect.ts` 5-18行目
- E-05: `src/templates/pad.html` 274-279行目
- E-06: `src/locales/en.json` 133-134行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | slowcommit通知はコミット応答遅延時に表示 | E-01, E-03 | ○ |
| C-02 | knownReasonsに'slowcommit'が含まれる | E-01 (74行目) | ○ |
| C-03 | 専用のモーダル(#connectivity .slowcommit)が表示される | E-05 (274行目) | ○ |
| C-04 | タイトルは「You have been disconnected.」 | E-05 (275行目で pad.modals.disconnected を参照) | ○ |
| C-05 | 説明は「The server is not responding.」 | E-06 (133行目) | ○ |
| C-06 | 原因でネットワーク接続の問題を示唆 | E-06 (134行目) | ○ |
| C-07 | タイムアウト値は20秒 | E-03 (95行目) | ○ |
| C-08 | committing状態で20秒経過時にトリガー | E-03 (94-97行目) | ○ |
| C-09 | setChannelState('DISCONNECTED', 'slowcommit')が呼ばれる | E-03 (97行目) | ○ |
| C-10 | 5秒経過時にonConnectionTrouble('SLOW')が呼ばれる | E-03 (98-99行目) | ○ |
| C-11 | lastCommitTimeでコミット時刻を追跡 | E-03 (46行目, 119行目) | ○ |
| C-12 | committing変数で状態を追跡 | E-03 (43行目, 120行目) | ○ |
| C-13 | Force reconnectボタンがある | E-05 (278行目) | ○ |
| C-14 | with_reconnect_timerクラスがある | E-05 (274行目) | ○ |
| C-15 | 自動再接続タイマーが表示される | E-02 (41行目), E-04 | ○ |
| C-16 | オーバーレイが表示される | E-01 (85行目), E-02 | ○ |
| C-17 | 国際化キーpad.modals.slowcommit.explanation使用 | E-05 (276行目), E-06 | ○ |
| C-18 | 国際化キーpad.modals.slowcommit.cause使用 | E-05 (277行目), E-06 | ○ |
| C-19 | ACCEPT_COMMIT受信で正常復帰 | E-03 (142-150行目, 209-222行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] collab_client.ts のコミットタイムアウトロジック（20秒）を確認
- [ ] collab_client.ts の5秒警告ロジックを確認
- [ ] pad.html の slowcommit div に with_reconnect_timer があることを確認
- [ ] 国際化キー pad.modals.slowcommit.* が正しく設定されているか確認
