---
generated_at: 2026-02-10 14:40:00
metrics:
  claims_total: 17
  claims_with_evidence: 17
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：9-badChangeset.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：17 / 17、根拠なし：0
- 優先レビュー（高）
  - 該当なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/static/js/pad_connectionstatus.ts` 54-86行目, 66行目
- E-02: `src/static/js/pad_modals.ts` 35-43行目, 41行目, 45-48行目
- E-03: `src/static/js/pad.ts` 333-342行目
- E-04: `src/static/js/pad_automatic_reconnect.ts` 5-18行目
- E-05: `src/templates/pad.html` 280-285行目
- E-06: `src/locales/en.json` 136-137行目

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | badChangeset通知は変更セット検証失敗時に表示 | E-01, E-03 | ○ |
| C-02 | knownReasonsに'badChangeset'が含まれる | E-01 (66行目) | ○ |
| C-03 | 専用のモーダル(#connectivity .badChangeset)が表示される | E-05 (280行目) | ○ |
| C-04 | タイトルは「You have been disconnected.」 | E-05 (281行目で pad.modals.disconnected を参照) | ○ |
| C-05 | 説明で不正な編集の分類を示す | E-06 (136行目) | ○ |
| C-06 | 原因でサーバー設定問題と管理者連絡を示唆 | E-06 (137行目) | ○ |
| C-07 | Force reconnectボタンがある | E-05 (284行目) | ○ |
| C-08 | with_reconnect_timerクラスがある | E-05 (280行目) | ○ |
| C-09 | 自動再接続タイマーが表示される | E-02 (41行目), E-04 | ○ |
| C-10 | socket.on('message')で検出 | E-03 (333行目) | ○ |
| C-11 | obj.disconnectが'badChangeset'の場合に発動 | E-03 (333-334行目) | ○ |
| C-12 | socket.disconnect()が呼ばれる | E-03 (335行目) | ○ |
| C-13 | オーバーレイが表示される | E-01 (85行目), E-02 | ○ |
| C-14 | 国際化キーpad.modals.badChangeset.explanation使用 | E-05 (282行目), E-06 | ○ |
| C-15 | 国際化キーpad.modals.badChangeset.cause使用 | E-05 (283行目), E-06 | ○ |
| C-16 | 既にdisconnectedの場合は重複処理しない | E-01 (55行目) | ○ |
| C-17 | statusにwhy: 'badChangeset'が設定される | E-01 (57-60行目) | ○ |

## 4) 不足情報（Unknown / Missing）

- 該当なし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - すべての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）

- [ ] pad_connectionstatus.ts の knownReasons に 'badChangeset' が含まれているか確認
- [ ] pad.html の badChangeset div に with_reconnect_timer があることを確認
- [ ] pad.html の badChangeset div に Force reconnect ボタンがあることを確認
- [ ] 国際化キー pad.modals.badChangeset.* が正しく設定されているか確認
