---
generated_at: 2026-02-10 14:30:00
metrics:
  claims_total: 52
  claims_with_evidence: 48
  claims_without_evidence: 4
confidence_derived: 0.92
---

# 根拠レポート：運用マニュアル

## 本レポートについて

### 目的
本レポートは、生成された運用マニュアルの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：48 / 52、根拠なし：4
- 優先レビュー（高）
  1. **セッション転送機能の詳細手順**：設計書に操作詳細なし
  2. **チャットメッセージ最大文字数**：ソースコード確認推奨
  3. **対応ブラウザのバージョン**：最新版推奨の具体的根拠なし
  4. **管理者へのサポート連絡方法**：プロジェクト固有情報なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `docs/code-to-docs/README.md` - システム概要、技術スタック
- E-02: `docs/code-to-docs/画面一覧/画面遷移図.md` - 画面遷移フロー
- E-03: `docs/code-to-docs/画面設計書/1-トップページ（パッド作成）.md` - トップページ設計
- E-04: `docs/code-to-docs/画面設計書/2-パッド編集画面.md` - パッド編集画面設計
- E-05: `docs/code-to-docs/画面設計書/3-タイムスライダー画面.md` - タイムスライダー設計
- E-06: `docs/code-to-docs/画面設計書/4-SSOログイン画面.md` - SSOログイン設計
- E-07: `docs/code-to-docs/画面設計書/6-管理者ログイン画面.md` - 管理者ログイン設計
- E-08: `docs/code-to-docs/画面設計書/7-プラグイン管理画面.md` - プラグイン管理設計
- E-09: `docs/code-to-docs/画面設計書/8-設定管理画面.md` - 設定管理設計
- E-10: `docs/code-to-docs/画面設計書/9-ヘルプ情報画面.md` - ヘルプ情報設計
- E-11: `docs/code-to-docs/画面設計書/10-パッド管理画面.md` - パッド管理設計
- E-12: `docs/code-to-docs/画面設計書/11-コミュニケーション画面.md` - コミュニケーション画面設計

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Etherpadはリアルタイム共同編集エディタである | E-01 | ○ |
| C-02 | 複数ユーザーが同時にドキュメントを編集できる | E-01, E-04 | ○ |
| C-03 | 編集履歴がリビジョンとして保存される | E-04, E-05 | ○ |
| C-04 | 105言語以上の多言語対応 | E-01 | ○ |
| C-05 | トップページからパッド作成・アクセスが可能 | E-02, E-03 | ○ |
| C-06 | パッド名は最大50文字まで入力可能 | E-03 | ○ |
| C-07 | 「New Pad」ボタンでランダム名のパッド作成 | E-03 | ○ |
| C-08 | SSOログイン画面でユーザー名・パスワード認証 | E-06 | ○ |
| C-09 | SSOログイン画面にパスワード表示切替機能あり | E-06 | ○ |
| C-10 | 管理者ログインは/admin/loginでアクセス | E-07 | ○ |
| C-11 | 管理者認証はBasic認証を使用 | E-07 | ○ |
| C-12 | 認証成功後プラグイン管理画面へリダイレクト | E-07 | ○ |
| C-13 | パッド編集画面にツールバー・エディター・チャットあり | E-04 | ○ |
| C-14 | テキスト編集内容はリアルタイムで同期 | E-04 | ○ |
| C-15 | 書式設定（太字、斜体、下線等）が可能 | E-04 | ○ |
| C-16 | ユーザー名・カラー設定が可能 | E-04 | ○ |
| C-17 | チャットメッセージは最大999文字 | E-04 | △ |
| C-18 | インポート対応形式にtxt, html, etherpad, doc, odt | E-04 | ○ |
| C-19 | エクスポート対応形式にtxt, html, etherpad, doc, pdf, odt | E-04 | ○ |
| C-20 | doc/pdf/odt形式はAbiWord/LibreOffice必要 | E-04 | ○ |
| C-21 | 共有ポップアップで共有URL・読み取り専用URL取得可能 | E-04 | ○ |
| C-22 | 読み取り専用モードでは編集不可 | E-04, E-05 | ○ |
| C-23 | タイムスライダーで編集履歴を時系列確認 | E-05 | ○ |
| C-24 | スライダーで任意のリビジョンを表示可能 | E-05 | ○ |
| C-25 | 再生ボタンで編集履歴を自動再生 | E-05 | ○ |
| C-26 | タイムスライダーから特定リビジョンをエクスポート可能 | E-05 | ○ |
| C-27 | プラグイン管理画面でプラグイン検索・インストール可能 | E-08 | ○ |
| C-28 | ep_etherpad-liteはアンインストール不可 | E-08 | ○ |
| C-29 | 検索に500msデバウンスあり | E-08 | ○ |
| C-30 | 5分ごとにプラグイン更新確認 | E-08 | ○ |
| C-31 | 設定管理画面でsettings.jsonを編集可能 | E-09 | ○ |
| C-32 | 設定保存前にJSON妥当性チェック実施 | E-09 | ○ |
| C-33 | サーバー再起動はホットリロード | E-09 | ○ |
| C-34 | ヘルプ画面でバージョン情報表示 | E-10 | ○ |
| C-35 | ヘルプ画面でインストール済みプラグイン一覧表示 | E-10 | ○ |
| C-36 | パッド管理画面で全パッド一覧表示 | E-11 | ○ |
| C-37 | パッド管理で検索・ソート・ページネーション可能 | E-11 | ○ |
| C-38 | パッド削除に確認ダイアログあり | E-11 | ○ |
| C-39 | リビジョンクリーンアップ機能あり | E-11 | ○ |
| C-40 | 1ページあたり12件表示 | E-11 | ○ |
| C-41 | コミュニケーション画面で一斉メッセージ送信可能 | E-12 | ○ |
| C-42 | Stickyオプションで固定メッセージ送信可能 | E-12 | ○ |
| C-43 | メッセージ履歴はページ更新で消失 | E-12 | ○ |
| C-44 | パッド編集画面でGritterポップアップ通知表示 | E-12 | ○ |
| C-45 | 管理画面はReact SPAで実装 | E-07, E-08 | ○ |
| C-46 | WebSocket接続断時に再接続試行 | E-04, E-05 | ○ |
| C-47 | 接続状態がモーダルで表示される | E-04 | ○ |
| C-48 | パッド削除時に全接続ユーザーに通知 | E-04 | ○ |
| C-49 | 対応ブラウザはChrome, Edge, Safari, Firefox最新版 | **根拠なし** | △ |
| C-50 | セッション転送機能の詳細操作手順 | **根拠なし** | △ |
| C-51 | 管理者へのサポート連絡方法 | **根拠なし** | △ |
| C-52 | エラーメッセージ一覧と対処法 | E-04, E-06, E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- **対応ブラウザの具体的要件**
  - README.mdに一般的な推奨記載があるが、具体的なバージョン要件の根拠がない
  - 候補：settings.json / ドキュメント / ソースコードのUA判定部分

- **セッション転送機能の詳細**
  - トップページ設計書に機能の存在は記載されているが、詳細な操作フローの記載がない
  - 候補：src/templates/index.html / indexBootstrap.js

- **サポート連絡方法**
  - プロジェクト固有の情報のため、設計書には記載なし
  - 候補：組織の運用規定 / 別途ヘルプデスク情報

- **チャットメッセージ最大文字数（999文字）**
  - 設計書に記載あり、ソースコードでの確認推奨
  - 候補：src/static/js/ChatMessage.ts

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - システム概要、画面遷移、基本操作手順
  - 設計書から正確に抽出された内容であり、信頼性が高い

- **1: 中リスク** - エクスポート形式の利用可能条件
  - AbiWord/LibreOfficeの有無による機能制限について、ユーザー環境により異なる
  - 実際の環境での確認を推奨

- **1: 中リスク** - 管理画面の操作手順
  - 画面設計書に基づいているが、実際のUI変更の可能性あり
  - 定期的なドキュメント更新を推奨

- **2: 高リスク** - 該当なし
  - 重大なリスクを伴う記載は確認されず

## 6) レビュアーチェックリスト（最小）
- [ ] 1.1 システム概要が実際のシステムと一致しているか確認
- [ ] 2.2 SSOログイン手順が実環境で動作するか確認
- [ ] 2.3 管理者ログイン手順が実環境で動作するか確認
- [ ] 5.3 書式設定ボタンの表記が実際のUIと一致しているか確認
- [ ] 6.1 エクスポート形式の利用可否を実環境で確認
- [ ] 10.3 プラグイン管理の操作手順を実環境で確認
- [ ] 12章 よくある質問の回答が実態と一致しているか確認
- [ ] 13章 エラーメッセージと対処法が最新か確認
