# Etherpad 業務運用マニュアル

## 目次

**【基本操作】**
1. [システム概要](#1-システム概要)
2. [ログイン・ログアウト手順](#2-ログインログアウト手順)
3. [トップページ（TOP画面）](#3-トップページtop画面)

**【業務フローに沿った機能】**
4. [【STEP1】パッド作成・共有機能（ドキュメント共有の開始）](#4-step1パッド作成共有機能ドキュメント共有の開始)
5. [【STEP2-3】リアルタイム共同編集機能（ドキュメントの編集・コラボレーション）](#5-step2-3リアルタイム共同編集機能ドキュメントの編集コラボレーション)
6. [【STEP3-4】エクスポート・インポート機能（ファイルのやり取り）](#6-step3-4エクスポートインポート機能ファイルのやり取り)
7. [【STEP4-5】履歴確認・管理機能（管理者向け）](#7-step4-5履歴確認管理機能管理者向け)

**【サポート機能】**
8. [チャット機能](#8-チャット機能)
9. [設定・カスタマイズ機能](#9-設定カスタマイズ機能)
10. [管理画面機能](#10-管理画面機能)

**【運用ガイド】**
11. [日常業務の流れ](#11-日常業務の流れ)
12. [よくある質問と対処法](#12-よくある質問と対処法)
13. [トラブルシューティング](#13-トラブルシューティング)

---

## 1. システム概要

### 1.1 Etherpadとは

Etherpadは、Webベースのリアルタイム共同編集エディタです。複数のユーザーが同時に同じドキュメント（パッド）を編集でき、すべての変更がリアルタイムで同期されます。会議メモ、ブレインストーミング、共同執筆、議事録作成など、チームコラボレーションの様々なシナリオで活用できます。

**主な特徴：**
- リアルタイムで複数人が同時編集可能
- 各ユーザーの編集箇所が色分け表示される
- 編集履歴がすべて保存され、過去の状態に遡れる
- プラグインによる機能拡張が可能
- 多言語対応（105言語以上）

### 1.2 本システムで行う主要業務

本システムは、主に以下の業務を支援します：

| 業務カテゴリ | 具体的な業務内容 |
|------------|----------------|
| **ドキュメント作成** | 新規パッド（ドキュメント）の作成、既存パッドへのアクセス |
| **共同編集** | リアルタイムでの複数人同時編集、書式設定、テキスト入力 |
| **コミュニケーション** | パッド内チャット、管理者からの一斉通知受信 |
| **ファイル管理** | ドキュメントのインポート・エクスポート（txt, html, doc, pdf, odt形式） |
| **履歴管理** | 編集履歴の確認、過去のバージョン参照 |
| **システム管理** | プラグイン管理、設定変更、パッド管理（管理者向け） |

### 1.3 業務フロー概要

本システムにおける業務は、以下の流れで進行します：

```
+---------------------------------------------------------------------+
|                        業務フロー                                    |
+---------------------------------------------------------------------+
|                                                                     |
|  【STEP 1】ユーザーがパッドを作成または既存パッドにアクセス           |
|      |                                                              |
|      v                                                              |
|  【STEP 2】共有リンクをチームメンバーに配布                          |
|      |                                                              |
|      v                                                              |
|  【STEP 3】複数ユーザーがリアルタイムでドキュメントを共同編集         |
|      |                                                              |
|      v                                                              |
|  【STEP 4】必要に応じてファイルをエクスポート・保存                   |
|      |                                                              |
|      v                                                              |
|  【STEP 5】編集履歴の確認、完成ドキュメントの配布                     |
|                                                                     |
+---------------------------------------------------------------------+
```

**役割別の業務概要：**

| 役割 | 主な業務 |
|------|---------|
| **管理者** | システム設定、プラグイン管理、パッド管理、ユーザーへの一斉通知 |
| **一般ユーザー** | パッドの作成・編集、共同編集への参加、ファイルのインポート・エクスポート |

### 1.4 主な機能

| 機能 | 説明 | 業務フローでの位置 |
|------|------|------------------|
| パッド作成 | 新規ドキュメントの作成、既存パッドへのアクセス | STEP 1 |
| リアルタイム編集 | 複数人による同時編集、書式設定 | STEP 2-3 |
| チャット | パッド内でのリアルタイムコミュニケーション | STEP 2-3 |
| インポート/エクスポート | 各種形式でのファイル入出力 | STEP 4 |
| タイムスライダー | 編集履歴の時系列確認・再生 | STEP 5 |
| 管理機能 | プラグイン・設定・パッドの管理 | 随時利用（管理者） |

### 1.5 ユーザー種別

システムには以下のユーザー種別があります：

| ユーザー種別 | 説明 |
|-------------|------|
| 一般ユーザー | パッドの作成・編集・閲覧を行う通常のユーザー |
| 管理者 | システム設定、プラグイン管理、全パッド管理が可能な権限を持つユーザー |
| 読み取り専用ユーザー | 読み取り専用リンクからアクセスし、閲覧のみ可能なユーザー |

### 1.6 対応ブラウザ

推奨ブラウザ：
- Google Chrome（最新版）
- Microsoft Edge（最新版）
- Safari（最新版）
- Firefox（最新版）

**注意**: JavaScriptを有効にしてご利用ください。

---

## 2. ログイン・ログアウト手順

### 2.1 一般ユーザーのアクセス方法

Etherpadは基本的に認証なしでパッドにアクセスできます。パッドのURLを知っている人は誰でも編集に参加できます。

1. ブラウザでEtherpadのトップページにアクセスします
2. パッド名を入力するか、「New Pad」ボタンをクリックします
3. パッド編集画面が表示されます

### 2.2 SSO認証が有効な場合のログイン方法

システムでSSO（シングルサインオン）認証が有効になっている場合：

1. 認証が必要なパッドにアクセスすると、SSOログイン画面が表示されます
2. 以下の情報を入力します：

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| Username | 組織から付与されたユーザー名 |
| Password | 登録済みのパスワード |

3. 「Login」ボタンをクリックします
4. 認証に成功すると、同意画面が表示される場合があります
5. 「同意」をクリックすると、元のパッドにアクセスできます

**パスワード表示機能**：パスワード入力欄の右側にある目のアイコンをクリックすると、入力中のパスワードを表示/非表示に切り替えられます。

### 2.3 管理者ログイン方法

管理画面へのアクセスには管理者認証が必要です。

1. ブラウザで `/admin` または `/admin/login` にアクセスします
2. 管理者ログイン画面が表示されます
3. 以下の情報を入力します：

**入力項目：**

| 項目 | 入力内容 |
|------|---------|
| Username | 管理者ユーザー名 |
| Password | 管理者パスワード |

4. 「Login」ボタンをクリックします
5. 認証に成功すると、プラグイン管理画面が表示されます

**注意事項**：
- 認証情報を忘れた場合は、システム管理者にお問い合わせください
- 複数回認証に失敗すると、一時的にアクセスが制限される場合があります

### 2.4 ログアウト方法

**一般ユーザー**：
- ブラウザのタブを閉じる、または別のURLに移動することでセッションが終了します

**管理者**：
- ブラウザのタブを閉じる、またはセッションがタイムアウトするまで管理画面にアクセス可能です

---

## 3. トップページ（TOP画面）

### 3.1 トップページの概要

トップページは、Etherpadにアクセスした際に最初に表示される画面です。新規パッドの作成や既存パッドへのアクセスを行うためのエントリーポイントとなります。

### 3.2 トップページの構成

トップページには以下の要素が表示されます：

| 要素 | 説明 |
|------|------|
| ページタイトル | システム名が表示されます |
| 「New Pad」ボタン | クリックするとランダムな名前で新規パッドが作成されます |
| パッド名入力フォーム | 任意のパッド名を入力して作成/アクセスできます |
| 「OK」ボタン | 入力したパッド名でパッドを開きます |
| 最近のパッド一覧 | 最近使用したパッドの一覧（設定で有効な場合） |

### 3.3 新規パッドの作成手順

**方法1：ランダムな名前で作成**

1. トップページの「New Pad」ボタンをクリックします
2. ランダムな名前を持つ新規パッドが自動生成されます
3. パッド編集画面に自動的に遷移します

**方法2：任意の名前で作成**

1. パッド名入力フォームに希望するパッド名を入力します
   - 例：「会議メモ_20260210」「プロジェクト企画書」など
2. 「OK」ボタンをクリックします
3. 入力した名前のパッドが作成され、編集画面に遷移します

**ポイント**：
- パッド名は最大50文字まで入力可能です
- 既存のパッド名を入力した場合は、そのパッドが開かれます
- 特殊文字を含めることも可能ですが、共有時のURLが複雑になる場合があります

### 3.4 既存パッドへのアクセス方法

1. パッド名入力フォームに既存のパッド名を入力します
2. 「OK」ボタンをクリックします
3. 該当するパッドが開かれます

または、パッドのURLを直接ブラウザのアドレスバーに入力してアクセスすることもできます。
- URL形式：`https://[サーバーアドレス]/p/[パッド名]`

---

## 4. 【STEP1】パッド作成・共有機能（ドキュメント共有の開始）

> **業務フローでの位置**: ユーザーがパッドを作成し、チームメンバーと共有を開始するステップです。

### 4.1 パッドの作成

新規パッドの作成方法については、[3.3 新規パッドの作成手順](#33-新規パッドの作成手順)をご参照ください。

### 4.2 共有リンクの取得

作成したパッドを他のユーザーと共有するには：

1. パッド編集画面の右上にある「共有」アイコン（鎖のマーク）をクリックします
2. 共有ポップアップが表示されます
3. 以下のリンクが表示されます：

| リンク種別 | 説明 |
|-----------|------|
| パッドURL | 編集可能なリンク。このリンクを持つ人は編集できます |
| 読み取り専用URL | 閲覧のみ可能なリンク。編集はできません |
| 埋め込みコード | Webページにパッドを埋め込むためのHTMLコード |

4. 必要なリンクをコピーして、チームメンバーに共有します

### 4.3 読み取り専用モードでの共有

機密性の高いドキュメントや、編集者を制限したい場合：

1. 共有ポップアップを開きます
2. 「Read only」チェックボックスをオンにします
3. 読み取り専用URLがコピー可能になります
4. このURLを共有すると、受信者は閲覧のみ可能です

---

## 5. 【STEP2-3】リアルタイム共同編集機能（ドキュメントの編集・コラボレーション）

> **業務フローでの位置**: 複数のユーザーがリアルタイムでドキュメントを共同編集するステップです。

### 5.1 パッド編集画面の概要

パッド編集画面は以下の要素で構成されています：

| 要素 | 位置 | 説明 |
|------|------|------|
| ツールバー | 上部 | 書式設定ボタン群（太字、斜体、下線、リストなど） |
| エディター領域 | 中央 | テキスト編集を行うメインエリア |
| ユーザーパネル | 右側 | 参加ユーザー一覧とカラー設定 |
| チャットボックス | 右下 | チャット機能（アイコンで表示/非表示切替） |

### 5.2 テキストの編集

1. エディター領域内でテキストを入力します
2. 入力した内容はリアルタイムで保存され、他のユーザーにも即座に反映されます
3. 各ユーザーの編集箇所は、そのユーザーのカラーで色分け表示されます

### 5.3 書式設定

ツールバーを使用して以下の書式設定が可能です：

| ボタン | 機能 | ショートカット |
|--------|------|---------------|
| **B** | 太字 | Ctrl+B / Cmd+B |
| *I* | 斜体 | Ctrl+I / Cmd+I |
| U | 下線 | Ctrl+U / Cmd+U |
| S | 取り消し線 | - |
| リストアイコン | 箇条書きリスト | - |
| 番号リストアイコン | 番号付きリスト | - |
| インデントアイコン | インデント調整 | - |

### 5.4 ユーザー名とカラーの設定

他のユーザーに自分を識別してもらうため：

1. 画面右上のユーザーパネルを開きます
2. ユーザー名入力欄に表示名を入力します
3. カラーパレットから好みの色を選択します
4. 設定は自動的に保存され、他のユーザーにも反映されます

### 5.5 参加ユーザーの確認

1. 画面右上のユーザーアイコンをクリックします
2. 現在パッドに接続しているユーザー一覧が表示されます
3. 各ユーザーの名前と割り当てられたカラーを確認できます

---

## 6. 【STEP3-4】エクスポート・インポート機能（ファイルのやり取り）

> **業務フローでの位置**: ドキュメントのファイル出力や、既存ファイルの取り込みを行うステップです。

### 6.1 ファイルのエクスポート

編集したパッドを各種形式でダウンロードできます。

1. ツールバーの「インポート/エクスポート」アイコンをクリックします
2. エクスポートポップアップが表示されます
3. 希望する形式をクリックします：

| 形式 | 説明 | 用途 |
|------|------|------|
| txt | プレーンテキスト形式 | シンプルなテキストとして保存 |
| html | HTML形式 | Webページとして利用 |
| etherpad | Etherpad固有形式 | バックアップ・復元用 |
| doc | Word形式 | Microsoft Wordで編集（要サーバー設定） |
| pdf | PDF形式 | 印刷・配布用（要サーバー設定） |
| odt | OpenDocument形式 | LibreOfficeで編集（要サーバー設定） |

4. ファイルが自動的にダウンロードされます

**注意**: doc、pdf、odt形式は、サーバーにAbiWordまたはLibreOfficeがインストールされている場合のみ利用可能です。

### 6.2 ファイルのインポート

既存のファイルをパッドに取り込むことができます。

1. ツールバーの「インポート/エクスポート」アイコンをクリックします
2. 「Import」タブを選択します
3. 「Choose file」ボタンでファイルを選択します
4. 「Import Now」ボタンをクリックします
5. ファイルの内容がパッドに取り込まれます

**対応形式**：
- txt（テキストファイル）
- html（HTMLファイル）
- etherpad（Etherpad形式）
- doc, docx（Wordファイル、要サーバー設定）
- odt（OpenDocument形式、要サーバー設定）

**注意事項**：
- インポートを実行すると、現在のパッド内容が置き換えられます
- 大きなファイルの場合、処理に時間がかかることがあります

---

## 7. 【STEP4-5】履歴確認・管理機能（管理者向け）

> **業務フローでの位置**: 編集履歴の確認や、管理者によるパッド管理を行うステップです。

### 7.1 タイムスライダー（編集履歴の確認）

パッドの編集履歴を時系列で確認できます。

**アクセス方法**：
1. パッド編集画面のツールバーにある「履歴」アイコン（時計マーク）をクリックします
2. タイムスライダー画面に遷移します

**タイムスライダーの使い方**：

| 操作 | 説明 |
|------|------|
| スライダーのドラッグ | 任意の時点の状態を表示 |
| 再生ボタン | 編集履歴を自動再生 |
| 一時停止ボタン | 再生を停止 |
| 前へボタン | 1リビジョン前に移動 |
| 次へボタン | 1リビジョン次に移動 |

**表示される情報**：
- リビジョン番号：現在表示中の履歴番号
- リビジョン日時：その時点のタイムスタンプ
- 著者一覧：その時点までに編集に貢献したユーザー一覧

**履歴のエクスポート**：
タイムスライダー画面からも各形式でエクスポートできます。この場合、最新版ではなく表示中のリビジョンの内容がエクスポートされます。

### 7.2 管理者向け：パッド管理機能

管理者は管理画面からすべてのパッドを一元管理できます。

**アクセス方法**：
1. 管理者としてログイン後、サイドメニューから「Pads」を選択します
2. パッド管理画面（/admin/pads）が表示されます

**利用可能な機能**：

| 機能 | 説明 |
|------|------|
| パッド一覧表示 | すべてのパッドを一覧で確認 |
| 検索 | パッド名でフィルタリング |
| ソート | パッド名、ユーザー数、最終編集日時、リビジョン数でソート |
| パッドを開く | 新しいタブでパッド編集画面を開く |
| パッド削除 | 選択したパッドを削除（確認ダイアログあり） |
| リビジョンクリーンアップ | 古いリビジョンを削除してディスク容量を節約 |
| 新規パッド作成 | 管理画面からパッドを作成 |

---

## 8. チャット機能

### 8.1 チャット機能の概要

パッド内でリアルタイムにメッセージをやり取りできるチャット機能があります。

### 8.2 チャットの使い方

1. 画面右下のチャットアイコンをクリックしてチャットボックスを開きます
2. テキスト入力欄にメッセージを入力します
3. Enterキーまたは送信ボタンでメッセージを送信します
4. メッセージは同じパッドに接続しているすべてのユーザーに表示されます

**注意事項**：
- チャットメッセージは最大999文字まで入力可能です
- チャット履歴はパッドに保存されます

### 8.3 管理者からの通知の受信

管理者から一斉送信されたメッセージは、パッド編集画面にポップアップ通知として表示されます。

- 通常のメッセージは一定時間後に自動的に消えます
- 「Sticky」設定のメッセージは、ユーザーが手動で閉じるまで表示され続けます

---

## 9. 設定・カスタマイズ機能

### 9.1 パッド設定

パッド編集画面の設定ボタンから、表示設定をカスタマイズできます。

**設定項目**：

| 設定 | 説明 |
|------|------|
| フォント | 表示フォントの選択 |
| 言語 | インターフェースの表示言語 |
| 著者カラー表示 | 各ユーザーの編集箇所の色分け表示ON/OFF |

### 9.2 セッション転送機能

別のデバイスに現在のセッションを引き継ぐことができます。

**セッション転送方法**：
1. トップページの設定ダイアログを開きます
2. 「Transfer session」タブを選択します
3. 「Transfer now」ボタンを押して転送コードを生成します

**セッション受信方法**：
1. 別のデバイスでトップページにアクセスします
2. 設定ダイアログの「Receive session」タブを選択します
3. 転送コードを入力して認証します

---

## 10. 管理画面機能

> この章は管理者向けの内容です。

### 10.1 管理画面へのアクセス

1. ブラウザで `/admin` にアクセスします
2. 管理者認証を行います（[2.3 管理者ログイン方法](#23-管理者ログイン方法)参照）
3. 認証成功後、プラグイン管理画面が表示されます

### 10.2 サイドメニューの構成

管理画面のサイドメニューから以下の画面にアクセスできます：

| メニュー | 説明 |
|---------|------|
| Plugins | プラグインのインストール・アンインストール・管理 |
| Settings | settings.jsonの編集、サーバー再起動 |
| Help | バージョン情報、インストール済みプラグイン・パーツ・フック一覧 |
| Pads | 全パッドの一覧表示・検索・削除・管理 |
| Communication | 接続中のユーザーへの一斉メッセージ送信 |

### 10.3 プラグイン管理

**インストール済みプラグインの確認**：
1. 「Plugins」画面を開きます
2. 「Installed Plugins」セクションでインストール済みプラグインを確認できます

**新規プラグインのインストール**：
1. 「Available Plugins」セクションで検索フィールドにキーワードを入力します
2. 検索結果から目的のプラグインを見つけます
3. インストールボタン（ダウンロードアイコン）をクリックします

**プラグインのアンインストール**：
1. インストール済みプラグイン一覧からアンインストールしたいプラグインを見つけます
2. アンインストールボタン（ゴミ箱アイコン）をクリックします

**注意**: `ep_etherpad-lite`（コアパッケージ）はアンインストールできません。

### 10.4 設定管理

**設定の編集**：
1. 「Settings」画面を開きます
2. テキストエリアに表示されているsettings.jsonを編集します
3. 「Save」ボタンで保存します

**サーバーの再起動**：
1. 設定変更後、「Restart」ボタンをクリックします
2. 設定がリロードされ、サーバーが更新されます

**注意**: 不正なJSONを保存しようとするとエラーが表示されます。

### 10.5 ヘルプ/情報画面

以下の情報を確認できます：

- 現在のEtherpadバージョン
- 最新の公開バージョン
- Gitコミット情報
- インストール済みプラグイン一覧
- インストール済みパーツ一覧
- サーバーフック一覧
- クライアントフック一覧

### 10.6 コミュニケーション機能（一斉通知）

接続中のすべてのユーザーにメッセージを一斉送信できます。

**メッセージの送信**：
1. 「Communication」画面を開きます
2. 接続中のユーザー数を確認します
3. メッセージ入力欄にメッセージを入力します
4. 必要に応じて「Sticky」スイッチをONにします（ユーザーが閉じるまで表示）
5. 送信ボタンをクリックします

**注意**: 送信履歴はページ更新で消失します（データベースには保存されません）。

---

## 11. 日常業務の流れ

本セクションでは、業務フローに沿った日常業務の流れを説明します。

```
業務フロー概要（再掲）
----------------------------------------------------------------------------
【STEP 1】ユーザーがパッドを作成または既存パッドにアクセス --> 4章参照
    |
    v
【STEP 2】共有リンクをチームメンバーに配布 --> 4章参照
    |
    v
【STEP 3】複数ユーザーがリアルタイムでドキュメントを共同編集 --> 5章参照
    |
    v
【STEP 4】必要に応じてファイルをエクスポート・保存 --> 6章参照
    |
    v
【STEP 5】編集履歴の確認、完成ドキュメントの配布 --> 7章参照
----------------------------------------------------------------------------
```

### 11.1 【ユーザー】STEP1-2: パッドの作成と共有

新しいドキュメントを作成し、チームメンバーと共有します。

1. Etherpadのトップページにアクセスします
2. 分かりやすいパッド名を入力して新規パッドを作成します
   - 例：「プロジェクトA_議事録_20260210」
3. 共有アイコンをクリックして共有ポップアップを開きます
4. パッドURLをコピーします
5. チャットツールやメールでチームメンバーにURLを共有します

### 11.2 【ユーザー】STEP3: 共同編集の実施

チームメンバーと同時にドキュメントを編集します。

1. 共有されたURLからパッドにアクセスします
2. ユーザーパネルで自分の名前とカラーを設定します
3. エディター領域でテキストを入力・編集します
4. 他のメンバーの編集内容がリアルタイムで反映されるのを確認します
5. 必要に応じてチャット機能でコミュニケーションを取ります

### 11.3 【ユーザー】STEP4: ファイルのエクスポート

完成したドキュメントをファイルとして保存します。

1. インポート/エクスポートアイコンをクリックします
2. 目的に応じた形式を選択します：
   - 配布用：PDF形式
   - 編集継続用：docまたはodt形式
   - シンプル保存用：txt形式
3. ダウンロードされたファイルを確認します

### 11.4 【ユーザー】STEP5: 履歴の確認

編集履歴を確認したい場合：

1. タイムスライダーアイコンをクリックします
2. スライダーを操作して過去の状態を確認します
3. 必要に応じて特定時点の内容をエクスポートします

### 11.5 【管理者】日常の管理業務

管理者として定期的に行う業務：

**定期確認項目**：
- プラグインの更新確認（5分ごとに自動確認）
- パッド数の確認とディスク使用状況の把握
- 不要パッドの整理・削除

**緊急対応項目**：
- ユーザーへの一斉通知（メンテナンス告知など）
- 問題のあるパッドの削除
- 設定変更とサーバー再起動

---

## 12. よくある質問と対処法

### 12.1 パッドに関するQ&A

**Q: パッドにアクセスできません**

A: 以下を確認してください：
1. URLが正しいか確認します
2. ブラウザを更新（F5キー）してみます
3. 別のブラウザで試してみます
4. インターネット接続を確認します

**Q: 自分の編集内容が他のユーザーに反映されません**

A: 以下を確認してください：
1. 画面右上の接続状態を確認します
2. 「Disconnected」と表示されている場合は、ページを更新します
3. ブラウザのJavaScriptが有効か確認します

**Q: パッド名を変更したい**

A: パッド名は変更できません。新しい名前でパッドを作成し、内容をコピーしてください。

### 12.2 編集に関するQ&A

**Q: 誤って内容を削除してしまいました**

A: タイムスライダー機能を使用して、削除前の状態を確認・コピーしてください。

**Q: 特定のユーザーのみ編集できるようにしたい**

A: 標準機能では対応していません。システム管理者に認証設定について相談してください。

### 12.3 エクスポート/インポートに関するQ&A

**Q: PDFやWord形式でエクスポートできません**

A: サーバーにAbiWordまたはLibreOfficeがインストールされている必要があります。システム管理者にお問い合わせください。

**Q: インポートしたファイルのレイアウトが崩れます**

A: 複雑なレイアウトは完全に再現されない場合があります。シンプルなテキスト形式での利用を推奨します。

---

## 13. トラブルシューティング

### 13.1 エラーメッセージと対処法

| エラーメッセージ | 原因 | 対処法 |
|----------------|------|--------|
| You do not have permission to access this pad | アクセス権限がない | 正しいURLか確認、管理者に権限を確認 |
| Disconnected | WebSocket接続が切断 | ページを更新、ネットワーク接続を確認 |
| Reconnecting... | 再接続を試行中 | しばらく待機、改善しない場合はページを更新 |
| This pad has been deleted | パッドが削除された | 新しいパッドを作成するか、管理者に確認 |
| Rate limited | 編集速度が制限を超過 | しばらく待ってから再試行 |
| Login failed | 認証情報が不正 | ユーザー名・パスワードを確認、管理者に問い合わせ |

### 13.2 よくあるトラブルと解決方法

**トラブル: ページが白いまま表示されない**

解決方法：
1. ブラウザのキャッシュをクリアします
2. 別のブラウザで試します
3. JavaScriptが有効か確認します
4. ブラウザの拡張機能を一時的に無効にします

**トラブル: 編集内容が保存されていない**

解決方法：
1. 画面右上の接続状態を確認します
2. ページを更新して再度確認します
3. タイムスライダーで履歴を確認します

**トラブル: 他のユーザーの編集が見えない**

解決方法：
1. ページを更新します
2. ユーザーパネルで他のユーザーが接続しているか確認します
3. WebSocket接続状態を確認します

### 13.3 サポートへの連絡方法

上記の対処法で解決しない場合は、以下の情報を添えてシステム管理者にお問い合わせください：

**必要な情報**：
- 発生した日時
- 使用していたブラウザとバージョン
- エラーメッセージの内容
- 再現手順
- スクリーンショット（可能な場合）

---

## 改訂履歴

| 版数 | 改訂日 | 改訂内容 |
|-----|--------|---------|
| 1.0 | 2026-02-10 | 初版作成 |

---

*本マニュアルは、Etherpadのエンドユーザー向け業務運用マニュアルです。*
*システムの更新により、画面や操作方法が変更される場合があります。*
