---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 60
  claims_with_evidence: 58
  claims_without_evidence: 2
confidence_derived: 0.97
---

# 根拠レポート：非機能要件テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：58 / 60、根拠なし：2
- 優先レビュー（高）
  1. **NFT-047（MySQL接続テスト）**：設定例のみで実テストファイルなし
  2. **NFT-055（IPロギング無効化テスト）**：設定項目のみでテストファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tests/ratelimit/testlimits.sh`
- E-02: `src/tests/ratelimit/send_changesets.js`
- E-03: `.github/workflows/load-test.yml`
- E-04: `.github/workflows/backend-tests.yml`
- E-05: `.github/workflows/rate-limit.yml`
- E-06: `src/tests/backend/specs/webaccess.ts`
- E-07: `src/tests/backend/specs/socketio.ts`
- E-08: `src/tests/backend/specs/health.ts`
- E-09: `src/node/db/SecurityManager.ts`
- E-10: `src/node/hooks/express/webaccess.ts`
- E-11: `src/node/security/SecretRotator.ts`
- E-12: `src/node/security/OAuth2Provider.ts`
- E-13: `src/node/db/SessionStore.ts`
- E-14: `src/node/utils/sanitizePathname.ts`
- E-15: `src/node/handler/ImportHandler.ts`
- E-16: `src/node/prometheus.ts`
- E-17: `settings.json.template`
- E-18: `Dockerfile`
- E-19: `docker-compose.yml`
- E-20: `.travis.yml`
- E-21: `src/tests/backend/specs/Pad.ts`
- E-22: `src/tests/backend/specs/api/sessionsAndGroups.ts`
- E-23: `src/tests/backend/specs/chat.ts`
- E-24: `src/tests/backend/specs/ImportEtherpad.ts`
- E-25: `src/tests/backend/specs/ExportEtherpad.ts`
- E-26: `src/tests/backend/specs/api/characterEncoding.ts`
- E-27: `.github/workflows/codeql-analysis.yml`
- E-28: `.github/workflows/dependency-review.yml`
- E-29: `package.json`
- E-30: `src/node/handler/PadMessageHandler.ts`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | NFT-001: レートリミットテスト（101ms間隔） | E-01, E-02 | ○ |
| C-02 | NFT-002: レートリミットテスト（99ms間隔） | E-01, E-02 | ○ |
| C-03 | NFT-003: 同時接続ユーザー負荷テスト（25ユーザー） | E-03 | ○ |
| C-04 | NFT-004: 長時間負荷テスト（5000回） | E-03 | ○ |
| C-05 | NFT-005: プロキシ経由レートリミットテスト | E-01, E-05 | ○ |
| C-06 | NFT-006: 認証なしでのアクセス拒否テスト | E-06 | ○ |
| C-07 | NFT-007: 認証成功テスト | E-06 | ○ |
| C-08 | NFT-008: 管理者認証テスト | E-06 | ○ |
| C-09 | NFT-009: 一般ユーザーのadminアクセス拒否テスト | E-06 | ○ |
| C-10 | NFT-010: パスワードnull時の認証失敗テスト | E-06 | ○ |
| C-11 | NFT-011: 認可なしでのアクセス拒否テスト | E-06 | ○ |
| C-12 | NFT-012: 認可バイパス攻撃防止テスト | E-07 | ○ |
| C-13 | NFT-013: 読み取り専用アクセス権テスト | E-07 | ○ |
| C-14 | NFT-014: セッション有効期限テスト | E-17, E-13 | ○ |
| C-15 | NFT-015: セッション更新テスト | E-13 | ○ |
| C-16 | NFT-016: 秘密鍵ローテーションテスト | E-11 | ○ |
| C-17 | NFT-017: パス・トラバーサル攻撃防止テスト | E-14 | ○ |
| C-18 | NFT-018: プロトタイプ汚染防止テスト | E-10 | ○ |
| C-19 | NFT-019: 最大ファイルサイズ制限テスト | E-15, E-17 | ○ |
| C-20 | NFT-020: インポート/エクスポートレートリミットテスト | E-17 | ○ |
| C-21 | NFT-021: コミットレートリミットテスト | E-17, E-30 | ○ |
| C-22 | NFT-022: ヘルスチェックエンドポイントテスト | E-08 | ○ |
| C-23 | NFT-023: 認証不要ヘルスチェックテスト | E-08 | ○ |
| C-24 | NFT-024: セッション状態非生成テスト | E-08 | ○ |
| C-25 | NFT-025: Dockerヘルスチェックテスト | E-18 | ○ |
| C-26 | NFT-026: 自動再接続テスト | E-17 | ○ |
| C-27 | NFT-027: Node.js v20互換性テスト | E-04 | ○ |
| C-28 | NFT-028: Node.js v22互換性テスト | E-04 | ○ |
| C-29 | NFT-029: Node.js v24互換性テスト | E-04 | ○ |
| C-30 | NFT-030: Linux互換性テスト | E-04 | ○ |
| C-31 | NFT-031: Windows互換性テスト | E-04 | ○ |
| C-32 | NFT-032: プラグイン併用テスト | E-04 | ○ |
| C-33 | NFT-033: ESLintチェック | E-29 | ○ |
| C-34 | NFT-034: TypeScriptチェック | E-29 | ○ |
| C-35 | NFT-035: 依存関係セキュリティチェック | E-20 | ○ |
| C-36 | NFT-036: CodeQL解析 | E-27 | ○ |
| C-37 | NFT-037: 依存関係レビュー | E-28 | ○ |
| C-38 | NFT-038: パッドデータ整合性テスト | E-21 | ○ |
| C-39 | NFT-039: セッションとグループの整合性テスト | E-22 | ○ |
| C-40 | NFT-040: 認証フック例外処理テスト | E-06 | ○ |
| C-41 | NFT-041: 認可フック例外処理テスト | E-06 | ○ |
| C-42 | NFT-042: Prometheusメトリクス収集テスト | E-16 | ○ |
| C-43 | NFT-043: OAuth2認証フローテスト | E-12 | ○ |
| C-44 | NFT-044: SameSite Cookie設定テスト | E-17 | ○ |
| C-45 | NFT-045: SSL接続テスト | E-17 | ○ |
| C-46 | NFT-046: PostgreSQL接続テスト | E-19 | ○ |
| C-47 | NFT-047: MySQL接続テスト | **根拠不足** | △ |
| C-48 | NFT-048: Etherpadフォーマットインポートテスト | E-24 | ○ |
| C-49 | NFT-049: Etherpadフォーマットエクスポートテスト | E-25 | ○ |
| C-50 | NFT-050: 文字エンコーディングテスト | E-26 | ○ |
| C-51 | NFT-051: ブルートフォース攻撃対策テスト | E-10 | ○ |
| C-52 | NFT-052: 静的リソースキャッシュテスト | E-17 | ○ |
| C-53 | NFT-053: Minifyテスト | E-17 | ○ |
| C-54 | NFT-054: バージョン情報非公開テスト | E-17 | ○ |
| C-55 | NFT-055: IPロギング無効化テスト | **根拠不足** | △ |
| C-56 | NFT-056: Socket.IOバッファサイズ制限テスト | E-17 | ○ |
| C-57 | NFT-057: WebSocketトランスポートテスト | E-17 | ○ |
| C-58 | NFT-058: ポーリングトランスポートテスト | E-17 | ○ |
| C-59 | NFT-059: trustProxy設定テスト | E-17, E-05 | ○ |
| C-60 | NFT-060: チャットメッセージ送受信テスト | E-23 | ○ |

## 4) 不足情報（Unknown / Missing）
- **NFT-047（MySQL接続テスト）**：settings.json.templateに設定例は存在するが、MySQLを使用した実際のテストファイルが確認できなかった
  - 候補：`src/tests/backend/specs/db/mysql.ts` / `tests/integration/mysql/` / CI/CDでのMySQL環境テスト
- **NFT-055（IPロギング無効化テスト）**：設定項目は存在するが、この設定が正しく動作することを検証するテストファイルが確認できなかった
  - 候補：`src/tests/backend/specs/logging.ts` / `src/tests/backend/specs/privacy.ts`

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 0（低リスク）**：60件中58件（97%）のテストケースが実装済みコードまたは設定ファイルで裏付けられている
- **リスクレベル 1（中リスク）**：
  - NFT-047：MySQL接続テストは設定例のみ。本番環境でMySQLを使用する場合は手動検証が必要
  - NFT-055：IPログ無効化は設定項目のみ。プライバシー要件が厳しい場合は動作確認を推奨
- **リスクレベル 2（高リスク）**：なし

## 6) レビュアーチェックリスト（最小）
- [ ] NFT-047のMySQL接続テストについて、本番環境での使用有無を確認し、使用する場合は手動テストを実施
- [ ] NFT-055のIPロギング無効化について、プライバシー要件を確認し、必要に応じて動作確認を実施
- [ ] 各セキュリティテストケース（NFT-006〜NFT-021、NFT-043〜NFT-056）の合格基準が組織のセキュリティポリシーと整合しているか確認
- [ ] 負荷テストの合格基準（NFT-003、NFT-004）が想定される本番環境の負荷と整合しているか確認
- [ ] Node.jsバージョン互換性テスト（NFT-027〜NFT-029）が本番環境で使用するバージョンを含んでいるか確認
