---
generated_at: 2026-02-10 09:30:00
metrics:
  claims_total: 45
  claims_with_evidence: 42
  claims_without_evidence: 3
confidence_derived: 0.93
---

# 根拠レポート：非機能要件定義書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：42 / 45、根拠なし：3
- 優先レビュー（高）
  1. **稼働率目標**：コードから明示的な定義を発見できず
  2. **計画停止時間**：コードから明示的な定義を発見できず
  3. **障害復旧時間（RTO）**：コードから明示的な定義を発見できず

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/utils/Settings.ts` - メイン設定ファイル、デフォルト値定義
- E-02: `src/node/server.ts` - サーバー起動・シャットダウン処理
- E-03: `src/node/handler/PadMessageHandler.ts` - WebSocket メッセージ処理、レート制限
- E-04: `src/node/db/SecurityManager.ts` - アクセス制御
- E-05: `src/node/hooks/express/webaccess.ts` - 認証・認可フック
- E-06: `src/node/security/SecretRotator.ts` - 秘密鍵ローテーション
- E-07: `src/node/security/OAuth2Provider.ts` - OAuth2/OIDC認証
- E-08: `src/node/db/SessionStore.ts` - セッションストア
- E-09: `src/node/prometheus.ts` - Prometheusメトリクス
- E-10: `src/node/stats.ts` - メトリクス収集
- E-11: `src/node/hooks/express/socketio.ts` - Socket.IO設定
- E-12: `src/node/db/DB.ts` - データベース初期化
- E-13: `package.json` - パッケージ情報、Node.jsバージョン要件

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | シャットダウンタイムアウト3秒 | E-02 (line 230) | ○ |
| C-02 | 強制終了タイムアウト5秒 | E-02 (line 294-307) | ○ |
| C-03 | maxAge 6時間（21,600,000ms） | E-01 (line 471) | ○ |
| C-04 | automaticReconnectionTimeoutデフォルト0 | E-01 (line 503) | ○ |
| C-05 | インポート/エクスポートレート制限 90秒/10リクエスト | E-01 (line 609-614) | ○ |
| C-06 | コミットレート制限 1秒/10ポイント | E-01 (line 623-628) | ○ |
| C-07 | WebSocket最大メッセージサイズ50KB | E-01 (line 367) | ○ |
| C-08 | 稼働率目標 | **根拠なし** | △ |
| C-09 | 計画停止時間 | **根拠なし** | △ |
| C-10 | 障害復旧時間（RTO） | **根拠なし** | △ |
| C-11 | SSO認証デフォルト | E-01 (line 374) | ○ |
| C-12 | 認証失敗遅延1秒 | E-05 (line 50, 189) | ○ |
| C-13 | セッションライフタイム10日間 | E-01 (line 534) | ○ |
| C-14 | セッションリフレッシュ間隔1日間 | E-01 (line 535) | ○ |
| C-15 | キーローテーション間隔1日間 | E-01 (line 532) | ○ |
| C-16 | AccessToken TTL 1時間 | E-01 (line 321) | ○ |
| C-17 | AuthorizationCode TTL 10分 | E-01 (line 322) | ○ |
| C-18 | ClientCredentials TTL 1時間 | E-01 (line 323) | ○ |
| C-19 | IdToken TTL 1時間 | E-01 (line 324) | ○ |
| C-20 | RefreshToken TTL 1日 | E-01 (line 325) | ○ |
| C-21 | 認可レベル3段階（readOnly, modify, create） | E-05 (line 24-37) | ○ |
| C-22 | カラーコード検証正規表現 | E-03 (line 585) | ○ |
| C-23 | プロトタイプ汚染防止 | E-05 (line 170, 193-195) | ○ |
| C-24 | Cookie SameSite lax | E-01 (line 533) | ○ |
| C-25 | exposeVersionデフォルトfalse | E-01 (line 595) | ○ |
| C-26 | ログライブラリlog4js | E-01, E-02, E-03 (import) | ○ |
| C-27 | デフォルトログレベルINFO | E-01 (line 61, 491) | ○ |
| C-28 | uncaughtExceptionハンドリング | E-02 (line 139-148) | ○ |
| C-29 | unhandledRejectionハンドリング | E-02 (line 152-155) | ○ |
| C-30 | グレースフルシャットダウン（SIGINT, SIGTERM） | E-02 (line 157-171) | ○ |
| C-31 | dumpOnUncleanExit設定 | E-01 (line 510), E-02 (line 35-38, 298-303) | ○ |
| C-32 | memoryUsageメトリクス | E-02 (line 135-137) | ○ |
| C-33 | totalUsersメトリクス | E-03 (line 97-101, 113) | ○ |
| C-34 | activePadsメトリクス | E-03 (line 103-116) | ○ |
| C-35 | connectsメトリクス | E-03 (line 172) | ○ |
| C-36 | disconnectsメトリクス | E-03 (line 197) | ○ |
| C-37 | pendingEditsメトリクス | E-03 (line 404, 631) | ○ |
| C-38 | editsタイマー | E-03 (line 643) | ○ |
| C-39 | rateLimitedメトリクス | E-03 (line 282) | ○ |
| C-40 | failedChangesetsメトリクス | E-03 (line 730) | ○ |
| C-41 | Prometheus統合 | E-09 (全体) | ○ |
| C-42 | インポート最大ファイルサイズ50MB | E-01 (line 635) | ○ |
| C-43 | クリーンアップ機能デフォルト無効 | E-01 (line 558-561) | ○ |
| C-44 | Node.js 20.0.0以上必須 | E-13 (engines.node) | ○ |
| C-45 | SecretRotator複数インスタンス同期 | E-06 (全体、特にline 84-108, 168-261) | ○ |

## 4) 不足情報（Unknown / Missing）
- **可用性目標（稼働率、計画停止時間、RTO）**: アプリケーションコードに明示的な定義がない
  - 候補：運用ドキュメント / インフラ設定 / SLA文書
- 具体的なパフォーマンスベンチマーク結果は未確認
  - 候補：負荷テスト結果 / パフォーマンステスト文書

## 5) リスクフラグ（レビュー観点）
- 0: 性能要件（レスポンスタイム、スループット）- コードから明確に確認可能
- 0: セキュリティ要件（認証、認可、レート制限）- 詳細な実装確認済み
- 1: 可用性要件（稼働率等）- 明示的な目標値がコードに存在しない
- 0: 監視要件（メトリクス）- Prometheus統合確認済み
- 0: ログ設定 - log4jsによる詳細なログ設定確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 可用性目標（稼働率、RTO、RPO）が組織のSLAと整合しているか確認
- [ ] レート制限の設定値が本番環境の負荷に適切か確認
- [ ] セッションライフタイム（10日）がセキュリティポリシーと整合しているか確認
- [ ] インポートファイルサイズ上限（50MB）がユースケースに十分か確認
- [ ] WebSocketメッセージサイズ上限（50KB）が大規模な共同編集に十分か確認
- [ ] 認証失敗時の遅延（1秒）がブルートフォース対策として十分か確認
- [ ] クリーンアップ機能の有効化要否を確認（デフォルト無効）
