# 非機能要件定義書

## 概要

本ドキュメントは、Etherpad Lite（リアルタイム共同編集エディタ）の非機能要件を、ソースコードから抽出・分析して定義したものです。バージョン2.6.1を対象としています。

## 性能要件

### レスポンスタイム

| 処理種別 | 目標値 | 備考 |
| --- | --- | --- |
| WebSocket通信 | リアルタイム | Socket.IOによる双方向通信。自動再接続タイムアウトは`automaticReconnectionTimeout`設定で制御（デフォルト: 0秒） |
| API応答 | 設定可能 | `maxAge`設定によりキャッシュ有効期限を設定（デフォルト: 6時間 = 21,600,000ms） |
| シャットダウン処理 | 3秒以内 | シャットダウンフックのタイムアウト: 3000ms |
| 強制終了待機 | 5秒以内 | 正常終了できない場合のタイムアウト: 5000ms |

### スループット

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 同時接続数 | 制限なし（システム依存） | `totalUsers`メトリクスで監視可能 |
| 秒間リクエスト数（インポート/エクスポート） | 10リクエスト/90秒/IP | `importExportRateLimiting`設定で制御 |
| 秒間変更数（コミット） | 10ポイント/秒/IP | `commitRateLimiting`設定で制御（本番環境のみ適用） |
| WebSocket最大メッセージサイズ | 50KB | `socketIo.maxHttpBufferSize`設定: 50,000バイト |

## 可用性要件

| 項目 | 目標値 | 備考 |
| --- | --- | --- |
| 稼働率 | 明示的な定義なし | アプリケーションレベルでの可用性目標は設定ファイルに未定義 |
| 計画停止時間 | 明示的な定義なし | グレースフルシャットダウンをサポート |
| 障害復旧時間（RTO） | 明示的な定義なし | 自動再接続機能あり（`automaticReconnectionTimeout`設定） |
| 目標復旧時点（RPO） | リアルタイム | 変更は即座にデータベースに保存される |

### 冗長構成サポート

- **データベース**: ueberDB2による複数DBバックエンド対応（rustydb、dirty、SQLite等）
- **セッション管理**: 複数インスタンス間でのデータベース共有をサポート（`SessionStore`実装）
- **シークレットローテーション**: `SecretRotator`クラスによる複数インスタンス間での秘密鍵同期

## セキュリティ要件

### 認証

| 項目 | 詳細 |
| --- | --- |
| 認証方式 | SSO（OpenID Connect）をデフォルトとし、APIキー認証もサポート（`authenticationMethod`設定） |
| HTTP Basic認証 | サポート（認証失敗時は1秒の遅延を導入してブルートフォース攻撃を軽減） |
| セッション管理 | express-sessionベースのセッション管理 |
| セッションライフタイム | 10日間（`cookie.sessionLifetime`: 864,000,000ms） |
| セッションリフレッシュ間隔 | 1日間（`cookie.sessionRefreshInterval`: 86,400,000ms） |
| キーローテーション間隔 | 1日間（`cookie.keyRotationInterval`: 86,400,000ms） |

### 認可

| 項目 | 詳細 |
| --- | --- |
| パッドアクセス制御 | `SecurityManager`によるアクセス制御（grant/deny） |
| 認可レベル | `readOnly`、`modify`、`create`の3段階 |
| 管理者認証 | `/admin`パスは常に認証必須、管理者権限（`is_admin`）が必要 |
| グループパッド | 非公開グループパッドにはHTTP APIセッションが必須 |

### トークン管理

| 項目 | TTL（秒） |
| --- | --- |
| AccessToken | 3,600（1時間） |
| AuthorizationCode | 600（10分） |
| ClientCredentials | 3,600（1時間） |
| IdToken | 3,600（1時間） |
| RefreshToken | 86,400（1日） |

### レート制限

| 対象 | 設定 | 詳細 |
| --- | --- | --- |
| インポート/エクスポート | `windowMs`: 90,000ms, `max`: 10 | 90秒間に最大10リクエスト/IP |
| コミット（変更送信） | `duration`: 1秒, `points`: 10 | 1秒間に最大10ポイント/IP（本番環境のみ） |

### 入力バリデーション

- Changeset構文検証（`checkRep`関数）
- 著者ID検証（他ユーザーへのなりすまし防止）
- パッドID/セッションID検証
- カラーコード形式検証（`/^#(?:[0-9A-F]{3}){1,2}$/i`）
- プロトタイプ汚染防止（`__proto__`、`constructor`、`prototype`のブロック）

### セキュリティヘッダー・設定

| 項目 | 設定 |
| --- | --- |
| Cookie SameSite | `lax`（デフォルト） |
| SSL/TLS | 設定可能（`ssl`設定） |
| Trust Proxy | 設定可能（`trustProxy`設定、デフォルト: false） |
| IPログ無効化 | 設定可能（`disableIPlogging`設定） |
| バージョン公開 | デフォルト無効（`exposeVersion`: false） |

## 拡張性要件

### プラグインシステム

- **フック機構**: 同期・非同期フックをサポート（`hooks.aCallAll`、`hooks.callAll`）
- **フックポイント**: `preAuthorize`、`authenticate`、`authorize`、`handleMessage`、`handleMessageSecurity`、`clientVars`、`userJoin`、`userLeave`等
- **プラグイン管理**: pnpmによるパッケージ管理、動的なプラグインロード

### スケーラビリティ

| 項目 | 詳細 |
| --- | --- |
| 水平スケーリング | データベース共有による複数インスタンス運用をサポート |
| WebSocket | Socket.IOによるWebSocket + pollingフォールバック |
| データベース抽象化 | ueberDB2による複数DBバックエンド対応 |

### 設定の柔軟性

- 環境変数による設定上書き（`${ENV_VAR}` または `${ENV_VAR:default}` 形式）
- settings.jsonによる静的設定
- credentials.jsonによる認証情報分離
- ランタイム設定変更（管理画面から一部設定変更可能）

## 保守性要件

### ログ設定

| 項目 | 設定 |
| --- | --- |
| ログライブラリ | log4js |
| デフォルトログレベル | INFO |
| デフォルトレイアウト | colored |
| カテゴリ別ログ | server、socket.io、ueberDB、auth、http、access、message等 |
| カスタム設定 | `logconfig`設定で任意のappender設定可能 |

### エラーハンドリング

- 未捕捉例外のハンドリング（`uncaughtException`）
- 未処理Promiseリジェクションのハンドリング（`unhandledRejection`）
- グレースフルシャットダウン（SIGINT、SIGTERM対応）
- 不正なChangesetの検出とクライアント切断（`disconnect: 'badChangeset'`）

### デバッグ支援

| 項目 | 詳細 |
| --- | --- |
| メモリダンプ | `dumpOnUncleanExit`設定でwtfnodeによるダンプ可能 |
| メトリクス出力 | 致命的エラー時にメトリクスをログ出力 |
| ロードテストモード | `loadTest`設定で認証・認可チェックをバイパス可能 |

### コード品質

- TypeScript使用（型安全性の確保）
- ESLintによる静的解析
- 非推奨機能の警告システム（`hooks.deprecationNotices`）

## 運用・監視要件

### メトリクス

| メトリクス名 | 種類 | 説明 |
| --- | --- | --- |
| memoryUsage | Gauge | プロセスのRSSメモリ使用量 |
| memoryUsageHeap | Gauge | ヒープメモリ使用量 |
| totalUsers | Gauge | 接続中の総ユーザー数 |
| activePads | Gauge | アクティブなパッド数 |
| connects | Meter | 接続数 |
| disconnects | Meter | 切断数 |
| pendingEdits | Counter | 処理待ちの編集数 |
| edits | Timer | 編集処理時間 |
| rateLimited | Meter | レート制限発動回数 |
| failedChangesets | Meter | 失敗したChangeset数 |
| ueberdb_* | Gauge | データベースメトリクス |

### Prometheus統合

- `prom-client`ライブラリによるPrometheus形式メトリクス出力
- `/stats`エンドポイントで有効化可能（`enableMetrics`設定）

### ヘルスチェック

- `/health`エンドポイント（推定）
- `etherpad-healthcheck`コマンドラインツール

### 更新チェック

- `updateServer`設定（デフォルト: `https://static.etherpad.org`）による更新確認機能

## ファイルサイズ制限

| 項目 | 制限値 |
| --- | --- |
| インポート最大ファイルサイズ | 50MB（`importMaxFileSize`: 52,428,800バイト） |
| WebSocket最大メッセージサイズ | 50KB（`socketIo.maxHttpBufferSize`: 50,000バイト） |

## パッド管理

| 項目 | 設定 |
| --- | --- |
| クリーンアップ機能 | `cleanup.enabled`設定（デフォルト: false） |
| 保持リビジョン数 | `cleanup.keepRevisions`設定（デフォルト: 100） |
| パッドID小文字変換 | `lowerCasePadIds`設定（デフォルト: false） |

## 備考

### 動作環境

- **Node.js**: バージョン20.0.0以上必須
- **データベース**: ueberDB2対応のデータベース（rustydb、dirty、SQLite、PostgreSQL、MySQL等）
- **プロトコル**: HTTP/HTTPS、WebSocket

### 設定ファイル

- `settings.json`: メイン設定ファイル
- `credentials.json`: 認証情報ファイル
- `SESSIONKEY.txt`: セッションキー（非推奨、キーローテーション推奨）

### 非推奨機能

- `sessionKey`設定（キーローテーションを使用すべき）
- `clientReady`フック（`userJoin`フックを使用すべき）
- `authFailure`フック（`authnFailure`/`authzFailure`フックを使用すべき）
