# FastAPI

## 概要

FastAPIは、Python 3.9以上で動作する高性能なWebフレームワークです。標準的なPython型ヒントを活用してAPIを構築でき、OpenAPI（Swagger）およびJSON Schemaに完全準拠した自動ドキュメント生成機能を備えています。Starlette（Webパート）とPydantic（データバリデーション）を基盤としており、NodeJSやGoに匹敵するパフォーマンスを実現しています。

## 主な機能

| 機能カテゴリ | 説明 |
| --- | --- |
| ルーティング | パスパラメータ、クエリパラメータ、リクエストボディの自動解析・バリデーション |
| 自動ドキュメント | Swagger UIとReDocによるインタラクティブなAPIドキュメント自動生成 |
| 依存性注入 | 強力で使いやすいDependency Injectionシステム |
| セキュリティ | OAuth2、JWT、HTTP Basic認証、APIキー認証のサポート |
| データバリデーション | Pydanticによる型ベースの自動バリデーションとシリアライズ |
| 非同期処理 | async/awaitによる非同期処理のネイティブサポート |
| WebSocket | リアルタイム通信のためのWebSocketサポート |
| バックグラウンドタスク | リクエスト処理後のバックグラウンドタスク実行 |
| ミドルウェア | CORS、GZip、HTTPS、信頼済みホストなどのミドルウェア |
| テストクライアント | HTTPXベースのテストクライアントによる簡単なテスト |

## 技術スタック

### コア

- フレームワーク: FastAPI 0.128.0
- 言語: Python 3.9以上（3.9, 3.10, 3.11, 3.12, 3.13, 3.14対応）
- Webフレームワーク基盤: Starlette >= 0.40.0
- データバリデーション: Pydantic >= 2.7.0
- ビルドシステム: PDM

### 主要ライブラリ

- `starlette` - 非同期Webフレームワーク基盤
- `pydantic` - データバリデーションとシリアライゼーション
- `typing-extensions` - 型ヒント拡張
- `annotated-doc` - アノテーションベースのドキュメント
- `uvicorn` - ASGIサーバー（standard依存）
- `httpx` - HTTPクライアント・テスト用
- `jinja2` - テンプレートエンジン
- `python-multipart` - フォーム・ファイルアップロード処理

## ディレクトリ構成

```
fastapi-master/
├── fastapi/                    # メインパッケージ
│   ├── __init__.py            # パブリックAPI定義
│   ├── applications.py        # FastAPIアプリケーションクラス
│   ├── routing.py             # APIRouter、ルーティング機能
│   ├── params.py              # パラメータクラス定義
│   ├── param_functions.py     # Query, Path, Body等の関数
│   ├── exceptions.py          # HTTPException等の例外
│   ├── encoders.py            # JSONエンコーダー
│   ├── dependencies/          # 依存性注入関連
│   ├── security/              # セキュリティ機能
│   │   ├── api_key.py        # APIキー認証
│   │   ├── http.py           # HTTP認証
│   │   ├── oauth2.py         # OAuth2認証
│   │   └── open_id_connect_url.py  # OpenID Connect
│   ├── openapi/               # OpenAPI関連
│   │   ├── docs.py           # ドキュメント生成
│   │   ├── models.py         # OpenAPIモデル
│   │   └── utils.py          # ユーティリティ
│   └── middleware/            # ミドルウェア
├── tests/                      # テストスイート
├── docs/                       # 多言語ドキュメント
├── docs_src/                   # ドキュメント用サンプルコード
├── scripts/                    # 開発・ビルドスクリプト
├── pyproject.toml             # プロジェクト設定
└── uv.lock                    # 依存関係ロックファイル
```

## セットアップ

### 必要条件

- Python 3.9以上

### インストール手順

標準インストール（推奨）:
```bash
pip install "fastapi[standard]"
```

最小インストール:
```bash
pip install fastapi
```

FastAPI Cloudなしの標準インストール:
```bash
pip install "fastapi[standard-no-fastapi-cloud-cli]"
```

全機能インストール:
```bash
pip install "fastapi[all]"
```

### 開発環境のセットアップ

```bash
# uvを使用した開発環境構築
uv sync --group dev
```

## 開発

### コードフォーマット・リンター

```bash
# フォーマット実行
./scripts/format.sh

# リント実行
./scripts/lint.sh
```

または、Ruffを直接使用:
```bash
# リントチェック
uv run ruff check --fix

# フォーマット
uv run ruff format
```

### テストの実行

```bash
# 全テスト実行
./scripts/test.sh

# または
uv run pytest

# カバレッジ付きテスト
./scripts/coverage.sh

# HTMLカバレッジレポート生成
./scripts/test-cov-html.sh
```

### Pre-commitフック

```bash
# Pre-commitのセットアップ
pre-commit install

# 手動実行
pre-commit run --all-files
```

### 型チェック

```bash
uv run mypy fastapi
```
