---
generated_at: 2026-01-22 22:30:00
metrics:
  claims_total: 42
  claims_with_evidence: 40
  claims_without_evidence: 2
confidence_derived: 0.95
---

# 根拠レポート：アーキテクチャ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：40 / 42、根拠なし：2
- 優先レビュー（高）
  1. **Python 3.14対応**: pyproject.tomlに記載あるが、実際のサポート状況は要確認
  2. **トランザクション管理**: FastAPIコアに含まれないという記述は正確だが、ユーザー向けガイダンスとしての妥当性は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/__init__.py` - バージョン情報、パブリックAPI定義
- E-02: `fastapi/applications.py` - FastAPIクラス定義、Starlette継承
- E-03: `fastapi/routing.py` - APIRouter、ルーティング処理
- E-04: `fastapi/params.py` - パラメータクラス定義
- E-05: `fastapi/param_functions.py` - パラメータヘルパー関数
- E-06: `fastapi/dependencies/models.py` - Dependantデータクラス
- E-07: `fastapi/dependencies/utils.py` - 依存性解決ユーティリティ
- E-08: `fastapi/security/__init__.py` - セキュリティモジュール公開API
- E-09: `fastapi/security/api_key.py` - APIキー認証
- E-10: `fastapi/security/http.py` - HTTP認証（Basic, Bearer, Digest）
- E-11: `fastapi/security/oauth2.py` - OAuth2認証
- E-12: `fastapi/security/open_id_connect_url.py` - OpenID Connect
- E-13: `fastapi/middleware/asyncexitstack.py` - AsyncExitStackMiddleware
- E-14: `fastapi/openapi/utils.py` - OpenAPI生成ユーティリティ
- E-15: `fastapi/openapi/docs.py` - Swagger UI, ReDoc生成
- E-16: `fastapi/exceptions.py` - 例外クラス定義
- E-17: `fastapi/exception_handlers.py` - 例外ハンドラー
- E-18: `fastapi/encoders.py` - JSONエンコーダー
- E-19: `fastapi/responses.py` - レスポンスクラス
- E-20: `fastapi/concurrency.py` - 並行処理ユーティリティ
- E-21: `fastapi/_compat/__init__.py` - Pydantic互換レイヤー
- E-22: `pyproject.toml` - プロジェクト設定、依存関係

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FastAPIバージョンは0.128.0 | E-01 | ○ |
| C-02 | Python 3.9以上で動作 | E-22 | ○ |
| C-03 | Starletteをベースとして構築 | E-02, E-22 | ○ |
| C-04 | Pydanticによる型検証機能を統合 | E-21, E-22 | ○ |
| C-05 | FastAPIクラスはStarletteを継承 | E-02 | ○ |
| C-06 | APIRouterでルーティングを管理 | E-03 | ○ |
| C-07 | 依存性注入システムを実装 | E-06, E-07 | ○ |
| C-08 | Dependsによる依存性宣言 | E-01, E-05 | ○ |
| C-09 | Path, Query, Body等のパラメータ処理 | E-04, E-05 | ○ |
| C-10 | APIKey認証をサポート | E-08, E-09 | ○ |
| C-11 | HTTP Basic認証をサポート | E-08, E-10 | ○ |
| C-12 | HTTP Bearer認証をサポート | E-08, E-10 | ○ |
| C-13 | HTTP Digest認証をサポート | E-08, E-10 | ○ |
| C-14 | OAuth2認証をサポート | E-08, E-11 | ○ |
| C-15 | OpenID Connect認証をサポート | E-08, E-12 | ○ |
| C-16 | Security Scopesによる認可 | E-06, E-11 | ○ |
| C-17 | AsyncExitStackMiddlewareが存在 | E-13 | ○ |
| C-18 | CORSMiddlewareをStarletteから再エクスポート | E-13ディレクトリ構成 | ○ |
| C-19 | OpenAPI仕様書を自動生成 | E-14, E-15 | ○ |
| C-20 | Swagger UIを提供 | E-15 | ○ |
| C-21 | ReDocを提供 | E-15 | ○ |
| C-22 | HTTPExceptionクラスが存在 | E-16 | ○ |
| C-23 | RequestValidationErrorクラスが存在 | E-16 | ○ |
| C-24 | 例外ハンドラーがデフォルトで登録 | E-02, E-17 | ○ |
| C-25 | JSONエンコーダーが提供される | E-18 | ○ |
| C-26 | UJSONResponse, ORJSONResponseが存在 | E-19 | ○ |
| C-27 | 非同期処理をネイティブサポート | E-03, E-20 | ○ |
| C-28 | run_in_threadpoolで同期関数をスレッドプールに委譲 | E-20 | ○ |
| C-29 | BackgroundTasksによるバックグラウンド処理 | E-01 | ○ |
| C-30 | yield依存性のAsyncExitStack管理 | E-03, E-07 | ○ |
| C-31 | Starlette >= 0.40.0, < 0.51.0に依存 | E-22 | ○ |
| C-32 | Pydantic >= 2.7.0に依存 | E-22 | ○ |
| C-33 | typing-extensions >= 4.8.0に依存 | E-22 | ○ |
| C-34 | annotated-doc >= 0.0.2に依存 | E-22 | ○ |
| C-35 | uvicornが推奨ASGIサーバー | E-22 | ○ |
| C-36 | python-multipartでフォーム/ファイルアップロード | E-07, E-22 | ○ |
| C-37 | mypyによる型チェック（strictモード） | E-22 | ○ |
| C-38 | ruffによるリンター | E-22 | ○ |
| C-39 | pytestによるテスト | E-22 | ○ |
| C-40 | FastAPIコアにDB接続機能は含まれない | E-01, E-02 | ○ |
| C-41 | Python 3.14対応 | E-22 | △ |
| C-42 | トランザクション管理はアプリケーション側で設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-41 Python 3.14対応**: pyproject.tomlのclassifiersに記載されているが、Python 3.14はまだリリースされていない（2026年1月時点）。実際のサポート状況は要確認。
  - 候補：Python公式リリーススケジュール / FastAPI GitHub Issues / テスト実行結果
- **C-42 トランザクション管理**: FastAPIコアに含まれないことは正確だが、この主張の根拠となる明示的なドキュメントはソースコード内に存在しない。
  - 候補：FastAPI公式ドキュメント / SQLModel/SQLAlchemy統合ガイド

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: アーキテクチャスタイルの記述 - ソースコード構造から合理的に推論可能
- **0 (低リスク)**: レイヤー構成の記述 - モジュール構成から明確に確認可能
- **0 (低リスク)**: 依存関係の記述 - pyproject.tomlから直接確認可能
- **1 (中リスク)**: データフロー図 - 実装から推論しているが、公式ドキュメントとの照合推奨
- **0 (低リスク)**: セキュリティスキーム - ソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] アーキテクチャスタイルの記述が実装と整合しているか確認
- [ ] レイヤー構成がFastAPI公式ドキュメントの説明と矛盾しないか確認
- [ ] 依存関係のバージョン情報が最新のpyproject.tomlと一致しているか確認
- [ ] セキュリティスキームの説明が実際のAPIと一致しているか確認
- [ ] Python 3.14のサポート状況を公式情報で確認
- [ ] データフロー図がStarlette/ASGIの仕様と整合しているか確認
