# アーキテクチャ構成図

## システム全体構成図

```mermaid
graph TB
    subgraph "クライアント"
        Client[HTTP/WebSocket Client]
        Browser[Web Browser]
    end

    subgraph "ASGIサーバー"
        Uvicorn[Uvicorn / Hypercorn]
    end

    subgraph "FastAPI Application"
        subgraph "Middleware Stack"
            SEM[ServerErrorMiddleware]
            ExM[ExceptionMiddleware]
            AESM[AsyncExitStackMiddleware]
            CORS[CORSMiddleware]
            GZIP[GZipMiddleware]
            Custom[Custom Middleware]
        end

        subgraph "Routing Layer"
            FastAPI[FastAPI Application]
            Router1[APIRouter]
            Router2[APIRouter]
            RouterN[APIRouter...]
        end

        subgraph "Dependency Injection"
            Depends[Depends]
            Dependant[Dependant Model]
            DIResolver[Dependency Resolver]
            DICache[DI Cache]
        end

        subgraph "Parameter Processing"
            Path[Path Params]
            Query[Query Params]
            Body[Body Params]
            Header[Header Params]
            Cookie[Cookie Params]
            Form[Form Params]
            File[File Upload]
        end

        subgraph "Security Layer"
            APIKey[APIKey Auth]
            HTTPBasic[HTTP Basic]
            HTTPBearer[HTTP Bearer]
            OAuth2[OAuth2]
            OIDC[OpenID Connect]
            Scopes[Security Scopes]
        end

        subgraph "Response Layer"
            JSONRes[JSONResponse]
            HTMLRes[HTMLResponse]
            FileRes[FileResponse]
            StreamRes[StreamingResponse]
            CustomRes[Custom Response]
        end

        subgraph "OpenAPI"
            OpenAPIGen[OpenAPI Generator]
            SwaggerUI[Swagger UI]
            ReDoc[ReDoc]
        end

        subgraph "Exception Handling"
            HTTPExc[HTTPException]
            ValidationExc[RequestValidationError]
            ExcHandler[Exception Handlers]
        end
    end

    subgraph "External Dependencies"
        Starlette[Starlette ASGI Framework]
        Pydantic[Pydantic Validation]
        AnyIO[AnyIO Async]
    end

    Client --> Uvicorn
    Browser --> Uvicorn
    Uvicorn --> SEM
    SEM --> ExM
    ExM --> AESM
    AESM --> CORS
    CORS --> GZIP
    GZIP --> Custom
    Custom --> FastAPI

    FastAPI --> Router1
    FastAPI --> Router2
    FastAPI --> RouterN

    Router1 --> Depends
    Router2 --> Depends
    RouterN --> Depends

    Depends --> DIResolver
    DIResolver --> Dependant
    DIResolver --> DICache

    DIResolver --> Path
    DIResolver --> Query
    DIResolver --> Body
    DIResolver --> Header
    DIResolver --> Cookie
    DIResolver --> Form
    DIResolver --> File

    Depends --> APIKey
    Depends --> HTTPBasic
    Depends --> HTTPBearer
    Depends --> OAuth2
    Depends --> OIDC
    OAuth2 --> Scopes

    Router1 --> JSONRes
    Router2 --> JSONRes
    RouterN --> CustomRes

    FastAPI --> OpenAPIGen
    OpenAPIGen --> SwaggerUI
    OpenAPIGen --> ReDoc

    FastAPI --> ExcHandler
    ExcHandler --> HTTPExc
    ExcHandler --> ValidationExc

    FastAPI -.-> Starlette
    DIResolver -.-> Pydantic
    FastAPI -.-> AnyIO
```

## レイヤー構成図

```mermaid
graph TB
    subgraph "Presentation Layer"
        FastAPI[FastAPI Application]
        APIRouter[APIRouter]
        Responses[Response Classes]
        OpenAPI[OpenAPI/Swagger/ReDoc]
    end

    subgraph "Application Layer"
        Routing[Routing Module]
        DI[Dependency Injection]
        Params[Parameter Processing]
        Encoders[JSON Encoders]
    end

    subgraph "Domain Layer"
        Validation[Pydantic Validation]
        Models[Data Models]
        Types[Type Definitions]
    end

    subgraph "Infrastructure Layer"
        Middleware[Middleware Stack]
        Security[Security Schemes]
        ASGI[ASGI Interface]
        Concurrency[Async/Concurrency]
    end

    FastAPI --> Routing
    APIRouter --> Routing
    Responses --> Encoders
    OpenAPI --> Routing

    Routing --> DI
    DI --> Params
    Params --> Validation

    Validation --> Models
    Models --> Types

    Middleware --> ASGI
    Security --> Concurrency
    DI --> Security
```

## 依存性注入フロー図

```mermaid
sequenceDiagram
    participant Client
    participant FastAPI
    participant Router
    participant DIResolver
    participant Cache
    participant Security
    participant Endpoint

    Client->>FastAPI: HTTP Request
    FastAPI->>Router: Route Match
    Router->>DIResolver: Resolve Dependencies

    DIResolver->>Cache: Check Cache
    alt Cache Hit
        Cache-->>DIResolver: Cached Value
    else Cache Miss
        DIResolver->>Security: Resolve Security Deps
        Security-->>DIResolver: Security Context
        DIResolver->>DIResolver: Resolve Sub-Dependencies
        DIResolver->>Cache: Store in Cache
    end

    DIResolver-->>Router: Resolved Dependencies
    Router->>Endpoint: Execute with Dependencies
    Endpoint-->>Router: Response
    Router-->>FastAPI: Response
    FastAPI-->>Client: HTTP Response
```

## リクエスト処理フロー図

```mermaid
flowchart TD
    A[HTTP Request] --> B[ASGI Server]
    B --> C{Middleware Stack}

    C --> D[ServerErrorMiddleware]
    D --> E[ExceptionMiddleware]
    E --> F[AsyncExitStackMiddleware]
    F --> G[Custom Middlewares]

    G --> H[FastAPI Application]
    H --> I{Route Matching}

    I -->|Match Found| J[Dependency Resolution]
    I -->|No Match| K[404 Not Found]

    J --> L{Validation}
    L -->|Valid| M[Execute Endpoint]
    L -->|Invalid| N[422 Validation Error]

    M --> O{Response Type}
    O -->|JSON| P[JSONResponse]
    O -->|HTML| Q[HTMLResponse]
    O -->|File| R[FileResponse]
    O -->|Stream| S[StreamingResponse]

    P --> T[Middleware Unwinding]
    Q --> T
    R --> T
    S --> T
    K --> T
    N --> T

    T --> U[HTTP Response]
```

## モジュール依存関係図

```mermaid
graph LR
    subgraph "Core"
        applications[applications.py]
        routing[routing.py]
    end

    subgraph "Parameters"
        params[params.py]
        param_functions[param_functions.py]
    end

    subgraph "Dependencies"
        dep_models[dependencies/models.py]
        dep_utils[dependencies/utils.py]
    end

    subgraph "Security"
        sec_base[security/base.py]
        sec_api_key[security/api_key.py]
        sec_http[security/http.py]
        sec_oauth2[security/oauth2.py]
        sec_oidc[security/open_id_connect_url.py]
    end

    subgraph "OpenAPI"
        openapi_docs[openapi/docs.py]
        openapi_models[openapi/models.py]
        openapi_utils[openapi/utils.py]
    end

    subgraph "Response"
        responses[responses.py]
        encoders[encoders.py]
    end

    subgraph "Exception"
        exceptions[exceptions.py]
        exception_handlers[exception_handlers.py]
    end

    subgraph "Compatibility"
        compat[_compat/]
    end

    subgraph "External"
        starlette[Starlette]
        pydantic[Pydantic]
    end

    applications --> routing
    applications --> openapi_utils
    applications --> exception_handlers

    routing --> dep_utils
    routing --> params
    routing --> encoders

    dep_utils --> dep_models
    dep_utils --> params
    dep_utils --> sec_oauth2

    param_functions --> params

    sec_api_key --> sec_base
    sec_http --> sec_base
    sec_oauth2 --> sec_base
    sec_oidc --> sec_base

    openapi_utils --> dep_models
    openapi_utils --> openapi_models
    openapi_docs --> openapi_utils

    exception_handlers --> encoders
    exception_handlers --> exceptions

    encoders --> compat
    routing --> compat
    dep_utils --> compat

    applications -.-> starlette
    routing -.-> starlette
    compat -.-> pydantic
```

## セキュリティスキーム構成図

```mermaid
classDiagram
    class SecurityBase {
        <<abstract>>
        +scheme_name: str
        +model: SecuritySchemeModel
    }

    class APIKeyBase {
        +in_: str
        +name: str
    }

    class APIKeyQuery {
        +in_: "query"
    }

    class APIKeyHeader {
        +in_: "header"
    }

    class APIKeyCookie {
        +in_: "cookie"
    }

    class HTTPBase {
        +scheme: str
    }

    class HTTPBasic {
        +scheme: "basic"
    }

    class HTTPBearer {
        +scheme: "bearer"
    }

    class HTTPDigest {
        +scheme: "digest"
    }

    class OAuth2 {
        +flows: OAuthFlows
    }

    class OAuth2PasswordBearer {
        +tokenUrl: str
        +scopes: dict
    }

    class OAuth2AuthorizationCodeBearer {
        +authorizationUrl: str
        +tokenUrl: str
        +scopes: dict
    }

    class OpenIdConnect {
        +openIdConnectUrl: str
    }

    class SecurityScopes {
        +scopes: list[str]
        +scope_str: str
    }

    SecurityBase <|-- APIKeyBase
    SecurityBase <|-- HTTPBase
    SecurityBase <|-- OAuth2
    SecurityBase <|-- OpenIdConnect

    APIKeyBase <|-- APIKeyQuery
    APIKeyBase <|-- APIKeyHeader
    APIKeyBase <|-- APIKeyCookie

    HTTPBase <|-- HTTPBasic
    HTTPBase <|-- HTTPBearer
    HTTPBase <|-- HTTPDigest

    OAuth2 <|-- OAuth2PasswordBearer
    OAuth2 <|-- OAuth2AuthorizationCodeBearer
```

## 例外処理フロー図

```mermaid
flowchart TD
    A[Endpoint Execution] --> B{Exception Raised?}

    B -->|No| C[Normal Response]
    B -->|Yes| D{Exception Type}

    D -->|HTTPException| E[http_exception_handler]
    D -->|RequestValidationError| F[request_validation_exception_handler]
    D -->|WebSocketRequestValidationError| G[websocket_request_validation_exception_handler]
    D -->|ResponseValidationError| H[Custom Handler / 500]
    D -->|Other Exception| I[ServerErrorMiddleware]

    E --> J[JSON Response with status_code]
    F --> K[422 JSON Response with errors]
    G --> L[WebSocket Close 1008]
    H --> M[500 Internal Server Error]
    I --> N{Debug Mode?}

    N -->|Yes| O[Traceback Response]
    N -->|No| P[500 Error Response]
```
