---
generated_at: 2026-01-22 15:30:00
metrics:
  claims_total: 35
  claims_with_evidence: 32
  claims_without_evidence: 3
confidence_derived: 0.91
---

# 根拠レポート：インフラ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：32 / 35、根拠なし：3
- 優先レビュー（高）
  1. **Cloudflare Pages SLA 99.9%以上**：公式ドキュメント参照が必要
  2. **GitHub Artifacts保持期間90日**：GitHub設定に依存するため確認が必要
  3. **PyPI SLA**：公式情報による確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/test.yml`
- E-02: `.github/workflows/build-docs.yml`
- E-03: `.github/workflows/deploy-docs.yml`
- E-04: `.github/workflows/publish.yml`
- E-05: `.github/workflows/smokeshow.yml`
- E-06: `.github/workflows/pre-commit.yml`
- E-07: `.github/dependabot.yml`
- E-08: `pyproject.toml`
- E-09: `scripts/test.sh`
- E-10: `.github/workflows/issue-manager.yml`
- E-11: `.github/workflows/labeler.yml`
- E-12: `.github/workflows/contributors.yml`
- E-13: `.github/workflows/people.yml`
- E-14: `.github/workflows/sponsors.yml`
- E-15: `.github/workflows/translate.yml`
- E-16: `.github/workflows/notify-translations.yml`
- E-17: `.github/workflows/latest-changes.yml`
- E-18: `.github/workflows/label-approved.yml`
- E-19: `.github/workflows/detect-conflicts.yml`
- E-20: `.github/workflows/topic-repos.yml`
- E-21: `.github/workflows/test-redistribute.yml`
- E-22: `.github/workflows/add-to-project.yml`
- E-23: `fastapi/__init__.py`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHub Actionsを用いたCI/CD環境 | E-01, E-02, E-03, E-04 | ○ |
| C-02 | Cloudflare Pagesによるドキュメントホスティング | E-03 (wrangler-action) | ○ |
| C-03 | テスト実行環境（Ubuntu, macOS, Windows） | E-01 (matrix.os) | ○ |
| C-04 | Pythonバージョン 3.9〜3.14対応 | E-01 (python-version), E-08 (requires-python) | ○ |
| C-05 | uvによるパッケージ管理 | E-01, E-02, E-03, E-04, E-08 | ○ |
| C-06 | pdm-backendによるビルド | E-08 (build-system) | ○ |
| C-07 | pytest >= 7.1.3, < 9.0.0 | E-08 (tests group) | ○ |
| C-08 | coverage >= 6.5.0, < 8.0 | E-08 (tests group) | ○ |
| C-09 | mkdocs-material 9.7.0 | E-08 (docs group) | ○ |
| C-10 | ruff 0.14.3 | E-08 (docs-tests group) | ○ |
| C-11 | mypy 1.14.1 | E-08 (tests group) | ○ |
| C-12 | PyPIへのパッケージ配布 | E-04 (uv publish) | ○ |
| C-13 | OIDC Trusted Publisherによる認証 | E-04 (id-token: write) | ○ |
| C-14 | Smokeshowによるカバレッジレポート公開 | E-05 | ○ |
| C-15 | CodSpeedによるパフォーマンス計測 | E-01 (CodSpeedHQ/action) | ○ |
| C-16 | Dependabotによる依存関係自動更新 | E-07 | ○ |
| C-17 | GitHub Actions日次更新チェック | E-07 (interval: daily) | ○ |
| C-18 | Python依存関係月次更新チェック | E-07 (interval: monthly) | ○ |
| C-19 | fail-fast: false設定 | E-01 (fail-fast: false) | ○ |
| C-20 | Smokeshowリトライ機構（5回） | E-05 (for i in 1 2 3 4 5) | ○ |
| C-21 | カバレッジ100%要求 | E-01 (--fail-under=100) | ○ |
| C-22 | CLOUDFLARE_API_TOKEN使用 | E-03 (secrets.CLOUDFLARE_API_TOKEN) | ○ |
| C-23 | CLOUDFLARE_ACCOUNT_ID使用 | E-03 (secrets.CLOUDFLARE_ACCOUNT_ID) | ○ |
| C-24 | SMOKESHOW_AUTH_KEY使用 | E-05 (secrets.SMOKESHOW_AUTH_KEY) | ○ |
| C-25 | PRE_COMMIT使用 | E-06 (secrets.PRE_COMMIT) | ○ |
| C-26 | Test Workflow週次スケジュール実行 | E-01 (cron: "0 0 * * 1") | ○ |
| C-27 | 言語別並列ドキュメントビルド | E-02 (matrix.lang) | ○ |
| C-28 | uvキャッシュ活用 | E-01, E-02, E-03 (enable-cache: true) | ○ |
| C-29 | mkdocsカードキャッシュ | E-02 (actions/cache) | ○ |
| C-30 | pre-commit自動フォーマット | E-06 | ○ |
| C-31 | all-green check | E-01 (alls-green@release/v1) | ○ |
| C-32 | FastAPIバージョン 0.128.0 | E-23 (__version__) | ○ |
| C-33 | Cloudflare Pages 99.9%以上のSLA | **根拠なし** | △ |
| C-34 | GitHub Artifactsデフォルト保持期間90日 | **根拠なし** | △ |
| C-35 | PyPI高可用性インフラ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **C-33 Cloudflare Pages SLA**: ワークフローファイルからはCloudflare Pagesの使用は確認できるが、SLAの具体的な数値はCloudflare公式ドキュメントを参照する必要がある
  - 候補：Cloudflare公式SLAドキュメント / サービス契約条件
- **C-34 GitHub Artifacts保持期間**: GitHubリポジトリまたはOrganizationの設定に依存する値であり、ソースコードからは確認不可
  - 候補：リポジトリSettings / Organization Settings
- **C-35 PyPI可用性**: PyPIはPython Software Foundationが運営するインフラであり、具体的なSLAはソースコードからは確認不可
  - 候補：PyPI公式ステータスページ / PSFドキュメント

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: CI/CDパイプライン構成、ミドルウェアバージョン、外部サービス連携設定
  - 根拠が明確にワークフローファイルおよびpyproject.tomlに記載されている
- **1（中リスク）**: 外部サービスのSLA・保持期間に関する記述
  - 外部サービスの公式情報を参照する必要がある
- **0（低リスク）**: 本プロジェクトがフレームワークライブラリであり、Docker/Kubernetes構成を含まないという記述
  - Dockerfile、docker-compose.yml、k8sマニフェストが存在しないことを確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Cloudflare Pagesの公式SLAが99.9%以上であることを確認
- [ ] 組織/リポジトリのArtifacts保持期間設定を確認
- [ ] ワークフローで使用されているシークレットがすべてGitHub Secretsに設定されていることを確認
- [ ] 本番環境でのドキュメントデプロイURLが正しいことを確認（fastapitiangolo project）
- [ ] CodSpeedのベンチマーク結果が期待通りに取得できていることを確認
