# インフラ構成図

## 全体構成図

```mermaid
graph TB
    subgraph "開発環境"
        DEV[開発者PC]
    end

    subgraph "GitHub"
        GH_REPO[GitHub Repository<br/>fastapi/fastapi]

        subgraph "GitHub Actions"
            GA_TEST[Test Workflow]
            GA_BUILD[Build Docs Workflow]
            GA_DEPLOY[Deploy Docs Workflow]
            GA_PUBLISH[Publish Workflow]
            GA_SMOKE[Smokeshow Workflow]
            GA_PRE[pre-commit Workflow]
        end

        GH_ARTIFACTS[GitHub Artifacts]
    end

    subgraph "外部サービス"
        PYPI[PyPI<br/>パッケージ配布]
        CF[Cloudflare Pages<br/>ドキュメントホスティング]
        SMOKE[Smokeshow<br/>カバレッジレポート]
        CODSPEED[CodSpeed<br/>パフォーマンス計測]
    end

    subgraph "エンドユーザー"
        USER_DEV[開発者<br/>pip install fastapi]
        USER_DOC[ユーザー<br/>ドキュメント閲覧]
    end

    DEV -->|push/PR| GH_REPO
    GH_REPO -->|trigger| GA_TEST
    GH_REPO -->|trigger| GA_BUILD
    GH_REPO -->|trigger| GA_PRE
    GH_REPO -->|release| GA_PUBLISH

    GA_TEST -->|coverage| GH_ARTIFACTS
    GA_TEST -->|benchmark| CODSPEED
    GA_BUILD -->|docs artifact| GH_ARTIFACTS

    GH_ARTIFACTS -->|download| GA_SMOKE
    GH_ARTIFACTS -->|download| GA_DEPLOY

    GA_SMOKE -->|upload| SMOKE
    GA_DEPLOY -->|deploy| CF
    GA_PUBLISH -->|publish| PYPI

    PYPI -->|pip install| USER_DEV
    CF -->|HTTPS| USER_DOC
```

## CI/CDパイプライン詳細

```mermaid
flowchart LR
    subgraph "トリガー"
        PUSH[Push to master]
        PR[Pull Request]
        RELEASE[Release Created]
        SCHEDULE[Schedule<br/>週次/月次]
    end

    subgraph "Test Pipeline"
        T1[Checkout]
        T2[Setup Python<br/>3.9-3.14]
        T3[Setup uv]
        T4[Install Dependencies]
        T5[Run Tests]
        T6[Upload Coverage]
        T7[Combine Coverage]
        T8[All Green Check]
    end

    subgraph "Docs Pipeline"
        D1[Checkout]
        D2[Setup Python]
        D3[Build Docs<br/>Multi-language]
        D4[Upload Artifacts]
        D5[Deploy to Cloudflare]
    end

    subgraph "Publish Pipeline"
        P1[Checkout]
        P2[Setup Python]
        P3[Build Distribution]
        P4[Publish to PyPI<br/>OIDC]
    end

    PUSH --> T1
    PR --> T1
    SCHEDULE --> T1

    T1 --> T2 --> T3 --> T4 --> T5 --> T6 --> T7 --> T8

    PUSH --> D1
    PR --> D1
    D1 --> D2 --> D3 --> D4 --> D5

    RELEASE --> P1
    P1 --> P2 --> P3 --> P4
```

## テストマトリックス

```mermaid
graph TD
    subgraph "Test Matrix"
        subgraph "Ubuntu"
            U39[Python 3.9<br/>+ Coverage]
            U313[Python 3.13<br/>+ Coverage]
            U313C[Python 3.13<br/>+ CodSpeed]
            U314[Python 3.14<br/>+ Coverage]
        end

        subgraph "macOS"
            M310[Python 3.10<br/>+ Coverage]
            M314[Python 3.14]
        end

        subgraph "Windows"
            W312[Python 3.12<br/>+ Coverage]
            W314[Python 3.14]
        end
    end

    subgraph "Coverage Combine"
        CC[coverage-combine Job]
    end

    U39 --> CC
    U313 --> CC
    U314 --> CC
    M310 --> CC
    W312 --> CC

    CC --> SMOKE[Smokeshow Upload]
```

## 依存関係管理フロー

```mermaid
flowchart TB
    subgraph "Dependabot"
        DB_GA[GitHub Actions<br/>日次チェック]
        DB_UV[Python/uv<br/>月次チェック]
    end

    subgraph "自動PR作成"
        PR_GA[Actions更新PR]
        PR_UV[依存関係更新PR]
    end

    subgraph "CI検証"
        CI[Test Workflow]
        PRE[pre-commit]
    end

    subgraph "マージ"
        MERGE[Merge to master]
    end

    DB_GA --> PR_GA
    DB_UV --> PR_UV

    PR_GA --> CI
    PR_UV --> CI

    PR_GA --> PRE
    PR_UV --> PRE

    CI -->|all green| MERGE
    PRE -->|all green| MERGE
```

## ドキュメントビルド・デプロイフロー

```mermaid
sequenceDiagram
    participant Dev as 開発者
    participant GH as GitHub
    participant Build as Build Docs
    participant Deploy as Deploy Docs
    participant CF as Cloudflare Pages

    Dev->>GH: Push/PR
    GH->>Build: Trigger workflow

    Build->>Build: Detect changes
    Build->>Build: Get language list

    loop 各言語
        Build->>Build: Build docs
        Build->>GH: Upload artifact
    end

    Build->>GH: docs-all-green

    GH->>Deploy: Trigger (on Build completion)
    Deploy->>GH: Download artifacts
    Deploy->>CF: Deploy via Wrangler
    CF->>Deploy: Return deployment URL
    Deploy->>GH: Comment deployment URL
```

## セキュリティ構成

```mermaid
graph TB
    subgraph "認証・認可"
        OIDC[OIDC<br/>Trusted Publisher]
        TOKEN[GitHub Token]
        SECRETS[GitHub Secrets]
    end

    subgraph "シークレット管理"
        S1[CLOUDFLARE_API_TOKEN]
        S2[CLOUDFLARE_ACCOUNT_ID]
        S3[SMOKESHOW_AUTH_KEY]
        S4[PRE_COMMIT]
    end

    subgraph "保護対象"
        PYPI[PyPI]
        CF[Cloudflare]
        SMOKE[Smokeshow]
        GH_API[GitHub API]
    end

    OIDC -->|publish| PYPI
    SECRETS --> S1
    SECRETS --> S2
    SECRETS --> S3
    SECRETS --> S4

    S1 --> CF
    S2 --> CF
    S3 --> SMOKE
    S4 --> GH_API
    TOKEN --> GH_API
```
