# インフラ設計書

## 概要

本ドキュメントは、FastAPIフレームワークプロジェクトのCI/CDインフラ構成について記述する。FastAPIはPythonベースのWebフレームワークであり、GitHub Actionsを用いた継続的インテグレーション・継続的デリバリー環境、およびCloudflare Pagesによるドキュメントホスティングを採用している。

## システム構成

### 全体構成

FastAPIプロジェクトは以下の構成要素で運用されている:

1. **ソースコード管理**: GitHub（リポジトリ: fastapi/fastapi）
2. **CI/CD環境**: GitHub Actions
3. **パッケージ配布**: PyPI（Python Package Index）
4. **ドキュメントホスティング**: Cloudflare Pages
5. **カバレッジレポート**: Smokeshow
6. **パフォーマンス計測**: CodSpeed

### サーバー構成

| サーバー種別 | 役割 | スペック | 台数 |
| --- | --- | --- | --- |
| GitHub Actions Runner (ubuntu-latest) | テスト実行、ドキュメントビルド、デプロイ | GitHub提供 | 動的割り当て |
| GitHub Actions Runner (macos-latest) | macOS環境でのテスト実行 | GitHub提供 | 動的割り当て |
| GitHub Actions Runner (windows-latest) | Windows環境でのテスト実行 | GitHub提供 | 動的割り当て |
| Cloudflare Pages | ドキュメントホスティング | CDNベース | グローバル分散 |
| PyPI | パッケージホスティング | PyPI提供 | - |

### ネットワーク構成

```
[開発者PC] --> [GitHub Repository]
                    |
                    v
            [GitHub Actions]
                    |
        +-----------+-----------+
        |           |           |
        v           v           v
    [テスト]    [ビルド]    [デプロイ]
        |           |           |
        v           v           v
  [Smokeshow]  [Artifacts]  [PyPI]
                    |           |
                    v           v
           [Cloudflare Pages] [pip install]
```

## ミドルウェア

| ミドルウェア | バージョン | 用途 |
| --- | --- | --- |
| Python | 3.9 - 3.14 | アプリケーション実行環境 |
| uv | 最新 | Pythonパッケージ管理・ビルドツール |
| pdm-backend | 最新 | Pythonパッケージビルドバックエンド |
| pytest | >= 7.1.3, < 9.0.0 | テストフレームワーク |
| coverage | >= 6.5.0, < 8.0 | コードカバレッジ計測 |
| mkdocs-material | 9.7.0 | ドキュメント生成 |
| ruff | 0.14.3 | Linter/Formatter |
| mypy | 1.14.1 | 静的型チェック |

## 外部サービス連携

| サービス名 | 用途 | 接続方式 |
| --- | --- | --- |
| GitHub | ソースコード管理、CI/CD | HTTPS/SSH |
| PyPI | パッケージ配布 | OIDC (Trusted Publisher) |
| Cloudflare Pages | ドキュメントホスティング | Wrangler CLI + API Token |
| Smokeshow | カバレッジレポート公開 | API Key認証 |
| CodSpeed | パフォーマンスベンチマーク | GitHub App連携 |
| Dependabot | 依存関係自動更新 | GitHub統合 |

## スケーリング設計

### CI/CDスケーリング

- **GitHub Actionsマトリックスビルド**: 複数のOS（Ubuntu、macOS、Windows）および複数のPythonバージョン（3.9〜3.14）で並列テストを実行
- **並列ジョブ実行**: ドキュメントビルドは言語ごとに並列実行
- **キャッシュ活用**: uvの依存関係キャッシュ、mkdocsのカードキャッシュを使用してビルド時間を短縮

### ドキュメントホスティング

- **CDN配信**: Cloudflare Pagesによるグローバルエッジ配信
- **自動スケーリング**: Cloudflareのインフラによる自動スケーリング

## 可用性設計

### CI/CD可用性

- **GitHub Actions SLA**: GitHubの提供するSLAに準拠
- **マトリックスビルドの分離**: `fail-fast: false`設定により、1つの環境で失敗しても他の環境のテストは継続
- **リトライ機構**: Smokeshow uploadは5回までリトライ

### ドキュメント可用性

- **Cloudflare Pages**: 99.9%以上のアップタイムSLA
- **グローバルCDN**: 複数エッジロケーションによる冗長性

### パッケージ配布

- **PyPI**: 高可用性インフラ
- **OIDC認証**: セキュアなTrusted Publisherによるパッケージ公開

## バックアップ設計

| 対象 | 方式 | 頻度 | 保持期間 |
| --- | --- | --- | --- |
| ソースコード | Gitリポジトリ（分散） | リアルタイム（コミット単位） | 永続 |
| ビルドアーティファクト | GitHub Actions Artifacts | ビルド毎 | GitHub設定に依存（デフォルト90日） |
| カバレッジレポート | Smokeshow | テスト毎 | Smokeshow設定に依存 |
| ドキュメント | Cloudflare Pages | デプロイ毎 | Cloudflare設定に依存 |
| パッケージ | PyPI | リリース毎 | 永続 |

## 監視設計

### CI/CD監視

| 監視項目 | 手法 | アラート |
| --- | --- | --- |
| テスト結果 | GitHub Actions status checks | PR/Pushステータス |
| カバレッジ率 | coverage + Smokeshow | 100%未満で失敗 |
| パフォーマンス | CodSpeed | ベンチマーク結果 |
| 依存関係更新 | Dependabot | PR自動作成 |
| ドキュメントビルド | GitHub Actions status checks | ビルド失敗時通知 |

### ブランチ保護

- **all-green check**: すべての必須ジョブが成功しないとマージ不可
- **pre-commit**: コードフォーマット自動チェック

## GitHub Actions ワークフロー一覧

| ワークフロー名 | トリガー | 目的 |
| --- | --- | --- |
| Test | push/PR/schedule(週次) | マルチプラットフォームテスト実行 |
| Build Docs | push/PR | ドキュメントビルド |
| Deploy Docs | Build Docs完了後 | Cloudflare Pagesへデプロイ |
| Publish | Release作成時 | PyPIへパッケージ公開 |
| Smokeshow | Test完了後 | カバレッジレポート公開 |
| pre-commit | PR | コードフォーマットチェック・自動修正 |
| issue-manager | Issue/PR操作時 | Issue/PR管理自動化 |
| labeler | PR | 自動ラベル付け |
| contributors | 定期実行 | コントリビューター一覧更新 |
| people | 定期実行 | People情報更新 |
| sponsors | 定期実行 | スポンサー情報更新 |
| translate | 定期実行 | 翻訳処理 |
| notify-translations | 翻訳関連 | 翻訳通知 |
| latest-changes | Release | リリースノート更新 |
| label-approved | Review承認時 | 承認ラベル付け |
| detect-conflicts | PR | コンフリクト検出 |
| topic-repos | 定期実行 | トピックリポジトリ管理 |
| test-redistribute | 定期実行 | 再配布テスト |
| add-to-project | Issue/PR | プロジェクトボード追加 |

## 環境変数・シークレット

| 名称 | 用途 | 管理方法 |
| --- | --- | --- |
| GITHUB_TOKEN | GitHub API認証 | GitHub自動提供 |
| CLOUDFLARE_API_TOKEN | Cloudflare Pages デプロイ | GitHub Secrets |
| CLOUDFLARE_ACCOUNT_ID | Cloudflareアカウント識別 | GitHub Secrets |
| SMOKESHOW_AUTH_KEY | Smokeshowアップロード認証 | GitHub Secrets |
| PRE_COMMIT | pre-commit自動コミット用トークン | GitHub Secrets |
| PyPI | パッケージ公開 | OIDC Trusted Publisher |

## 備考

- 本プロジェクトはフレームワークライブラリであるため、独自のコンテナ化（Docker）やKubernetes構成は含まれていない
- アプリケーションサーバーとしてUvicornを推奨しているが、これはFastAPIを使用するアプリケーション側で構成される
- 開発環境ではuv（高速なPythonパッケージマネージャー）を採用し、ビルド・テスト時間を最適化している
- Dependabotによる依存関係の自動更新が有効化されており、GitHub Actionsは日次、Python依存関係は月次で更新チェックが行われる
