---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 28
  claims_with_evidence: 25
  claims_without_evidence: 3
confidence_derived: 0.89
---

# 根拠レポート：セキュリティ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：25 / 28、根拠なし：3
- 優先レビュー（高）
  1. **HSTS設定**：FastAPI本体での直接実装確認が困難
  2. **監査ログの保持期間**：アプリケーション設定依存のため根拠なし
  3. **CSPヘッダー設定**：FastAPIコアでの明示的対策確認なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/security/__init__.py` - セキュリティモジュールのエクスポート定義
- E-02: `fastapi/security/oauth2.py` - OAuth2認証クラス群の実装
- E-03: `fastapi/security/http.py` - HTTP認証クラス群（Basic, Bearer, Digest）
- E-04: `fastapi/security/api_key.py` - APIキー認証クラス群
- E-05: `fastapi/security/open_id_connect_url.py` - OpenID Connect実装
- E-06: `fastapi/middleware/cors.py` - CORSMiddlewareのインポート
- E-07: `fastapi/middleware/httpsredirect.py` - HTTPSリダイレクトミドルウェア
- E-08: `fastapi/middleware/trustedhost.py` - TrustedHostミドルウェア
- E-09: `fastapi/params.py` - パラメータクラス（Query, Path, Header等）
- E-10: `fastapi/exceptions.py` - 例外クラス定義
- E-11: `fastapi/logger.py` - ロガー設定
- E-12: `fastapi/dependencies/utils.py` - 依存性注入ユーティリティ
- E-13: `docs_src/cors/tutorial001_py39.py` - CORS設定のサンプルコード
- E-14: `docs_src/security/tutorial005_an_py310.py` - OAuth2スコープのサンプルコード

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | OAuth2PasswordBearerによるパスワードフロー認証サポート | E-02 (`OAuth2PasswordBearer`クラス) | ○ |
| C-02 | OAuth2AuthorizationCodeBearerによる認可コードフローサポート | E-02 (`OAuth2AuthorizationCodeBearer`クラス) | ○ |
| C-03 | HTTPBasicクラスによるBasic認証サポート | E-03 (`HTTPBasic`クラス、RFC 7617参照) | ○ |
| C-04 | HTTPBearerクラスによるBearer認証サポート | E-03 (`HTTPBearer`クラス) | ○ |
| C-05 | HTTPDigestクラスによるDigest認証サポート（スタブ） | E-03 (`HTTPDigest`クラス、RFC 7616参照、スタブ実装の警告あり) | ○ |
| C-06 | APIKeyQuery/Header/CookieによるAPIキー認証サポート | E-04 (3つのAPIKey認証クラス) | ○ |
| C-07 | OpenIdConnectクラスによるOpenID Connectサポート（スタブ） | E-05 (`OpenIdConnect`クラス、スタブ実装の警告あり) | ○ |
| C-08 | OAuth2PasswordRequestFormによるフォームデータ収集 | E-02 (`OAuth2PasswordRequestForm`クラス) | ○ |
| C-09 | OAuth2PasswordRequestFormStrictによる厳格なフォーム検証 | E-02 (`OAuth2PasswordRequestFormStrict`クラス、grant_type必須) | ○ |
| C-10 | SecurityScopesクラスによるスコープ管理 | E-02, E-12, E-14 | ○ |
| C-11 | Dependsによる依存性注入 | E-09 (`Depends`クラス) | ○ |
| C-12 | Securityによるスコープ付き依存性注入 | E-09 (`Security`クラス、`Depends`継承、`scopes`属性) | ○ |
| C-13 | auto_errorパラメータによる任意認証対応 | E-02, E-03, E-04, E-05 (各クラスのauto_errorパラメータ) | ○ |
| C-14 | HTTPSRedirectMiddlewareによるHTTPSリダイレクト | E-07 (Starletteからのインポート) | ○ |
| C-15 | TrustedHostMiddlewareによるホスト制限 | E-08 (Starletteからのインポート) | ○ |
| C-16 | CORSMiddlewareによるCORS設定 | E-06, E-13 (Starletteからのインポート、サンプルコード) | ○ |
| C-17 | Paramクラスによるバリデーション機能（gt, ge, lt, le, min_length, max_length, pattern） | E-09 (`Param`クラスのパラメータ定義) | ○ |
| C-18 | HTTP 401エラーとWWW-Authenticateヘッダーの設定 | E-02, E-03, E-04, E-05 (各make_not_authenticated_errorメソッド) | ○ |
| C-19 | HTTPExceptionクラスによるHTTPエラーレスポンス | E-10 (`HTTPException`クラス) | ○ |
| C-20 | RequestValidationErrorによる入力検証エラー | E-10 (`RequestValidationError`クラス) | ○ |
| C-21 | ResponseValidationErrorによるレスポンス検証エラー | E-10 (`ResponseValidationError`クラス) | ○ |
| C-22 | fastapi名前空間でのロガー設定 | E-11 (`logging.getLogger("fastapi")`) | ○ |
| C-23 | JWTトークンによるセッション管理 | E-14 (サンプルコードでjwt.encode/decodeを使用) | ○ |
| C-24 | パスワードハッシュ化の推奨 | E-14 (サンプルコードでArgon2idを使用) | ○ |
| C-25 | refreshUrlによるトークンリフレッシュURL設定 | E-02 (`OAuth2PasswordBearer`、`OAuth2AuthorizationCodeBearer`のrefreshUrlパラメータ) | ○ |
| C-26 | HSTS対応 | **根拠なし** | △ |
| C-27 | 監査ログの保持期間設定 | **根拠なし** | △ |
| C-28 | CSRF対策 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **HSTS対応**：FastAPI/Starlette本体での明示的なHSTS設定は確認できず。実際のデプロイ時にnginx等のリバースプロキシで設定することが一般的
  - 候補：Starletteドキュメント / uvicornドキュメント / nginx設定例
- **監査ログの保持期間**：FastAPIフレームワーク自体はログ保持期間を管理せず、アプリケーション側での設定が必要
  - 候補：Pythonログハンドラ設定 / 外部ログ管理システム連携
- **CSRF対策**：FastAPIはAPIフレームワークのためブラウザベースのCSRF対策は明示的に提供していない。JWTベースのステートレス認証を推奨
  - 候補：Starlette CSRFミドルウェア / フロントエンド側対策

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 認証方式、バリデーション機能：コードで明確に確認可能
- **0: 低リスク** - CORS設定：サンプルコードとStarlette統合で確認可能
- **1: 中リスク** - HSTS、CSP：デプロイ環境依存のため実装確認が困難
- **1: 中リスク** - CSRF対策：APIフレームワークの特性上、明示的対策が限定的
- **0: 低リスク** - OAuth2スコープ：サンプルコードで動作確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 認証方式（OAuth2, HTTP Basic/Bearer, API Key）の実装が正確に記述されているか確認
- [ ] バリデーションパラメータ（gt, ge, lt, le, min_length, max_length, pattern）の説明が正確か確認
- [ ] CORSMiddlewareの設定オプションが網羅されているか確認
- [ ] SecurityScopesによるスコープ管理の説明がサンプルコードと整合しているか確認
- [ ] HSTS、CSRF対策について、実際のデプロイ時に必要な追加設定を補足すべきか検討
- [ ] 監査ログの推奨事項が組織のセキュリティポリシーと整合しているか確認
- [ ] パスワードハッシュアルゴリズムの推奨（Argon2id, bcrypt）が最新のベストプラクティスと合致しているか確認
