---
generated_at: 2026-01-22 19:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：テスト方針書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **テスト担当者の役割分担**：プロジェクト固有の情報が不足
  2. **不具合管理の詳細プロセス**：GitHubテンプレート以外の情報が不足

## 2) 参照した情報（Evidence一覧）

- E-01: `pyproject.toml` - テストツール・依存関係の定義
- E-02: `.github/workflows/test.yml` - CI/CDテストワークフロー設定
- E-03: `.github/workflows/smokeshow.yml` - カバレッジレポート公開設定
- E-04: `.pre-commit-config.yaml` - pre-commitフック設定
- E-05: `scripts/test.sh` - テスト実行スクリプト
- E-06: `scripts/test-cov-html.sh` - カバレッジHTMLレポート生成スクリプト
- E-07: `tests/test_application.py` - テストファイル実装例
- E-08: `tests/main.py` - テスト用共通アプリケーション
- E-09: `tests/benchmarks/test_general_performance.py` - パフォーマンスベンチマーク
- E-10: `tests/test_security_*.py` - セキュリティ関連テストファイル群（36ファイル）
- E-11: `tests/test_request_params/` - リクエストパラメータテストディレクトリ

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pytestをテストフレームワークとして使用 | E-01 (`[dependency-groups].tests`) | ○ |
| C-02 | coverageでコードカバレッジを測定 | E-01 (`[tool.coverage.run]`) | ○ |
| C-03 | 100%カバレッジが必須要件 | E-02 (`coverage report --fail-under=100`) | ○ |
| C-04 | Python 3.9-3.14をサポート | E-01 (`requires-python`, classifiers), E-02 (matrix) | ○ |
| C-05 | GitHub Actionsでmasterプッシュ時にテスト実行 | E-02 (`on.push.branches`) | ○ |
| C-06 | GitHub ActionsでPR時にテスト実行 | E-02 (`on.pull_request`) | ○ |
| C-07 | 毎週月曜に定期テスト実行 | E-02 (`schedule.cron`) | ○ |
| C-08 | Ubuntu/macOS/Windowsでクロスプラットフォームテスト | E-02 (`matrix.os`) | ○ |
| C-09 | CodSpeedでパフォーマンスベンチマーク実行 | E-02 (`matrix.codspeed`), E-09 | ○ |
| C-10 | Smokeshowでカバレッジレポート公開 | E-03 | ○ |
| C-11 | ruffでコードスタイルチェック | E-01 (`[tool.ruff]`), E-04 | ○ |
| C-12 | mypyで静的型チェック | E-01 (`[tool.mypy]`, `mypy==1.14.1`) | ○ |
| C-13 | httpxをテストクライアントとして使用 | E-01 (`httpx`), E-07 (`TestClient`) | ○ |
| C-14 | anyio[trio]で非同期テストサポート | E-01 (`anyio[trio]`) | ○ |
| C-15 | inline-snapshotでスナップショットテスト | E-01 (`inline-snapshot`) | ○ |
| C-16 | pytest.mark.parametrizeでパラメータ化テスト | E-07 (実装例) | ○ |
| C-17 | テストファイル数約450ファイル | E-11 (検証済み: 454ファイル) | ○ |
| C-18 | セキュリティテスト36ファイル | E-10 (検証済み: 36ファイル) | ○ |
| C-19 | dirty-equalsでアサーション補助 | E-01 (`dirty-equals==0.9.0`) | ○ |
| C-20 | pre-commitでcheck-toml/check-yaml実行 | E-04 | ○ |
| C-21 | カバレッジソースにdocs_src, tests, fastapi含む | E-01 (`[tool.coverage.run].source`) | ○ |
| C-22 | テスト実行スクリプトでcoverage run -m pytest使用 | E-05 | ○ |
| C-23 | pytest-codspeed 4.2.0使用 | E-01 (`pytest-codspeed==4.2.0`) | ○ |
| C-24 | テスト担当者は開発者 | **根拠なし** | △ |
| C-25 | 不具合管理はGitHub Issue使用 | E-02 (ワークフロー存在), `.github/ISSUE_TEMPLATE/` | △ |

## 4) 不足情報（Unknown / Missing）

- **C-24: テスト担当者の役割分担**
  - プロジェクトの組織体制・役割分担に関する明示的なドキュメントが見つからない
  - 候補：CONTRIBUTING.md / チーム規約文書 / プロジェクト内部ドキュメント

- **C-25: 不具合管理の詳細プロセス**
  - GitHub Issue Templateは存在するが、具体的な不具合管理フローの記載が不明確
  - 候補：CONTRIBUTING.md / プロジェクトWiki / 内部運用マニュアル

## 5) リスクフラグ（レビュー観点）

- **0: 低リスク** - テストツール・CI/CD設定（根拠明確）
- **0: 低リスク** - カバレッジ目標（設定ファイルで明確に定義）
- **0: 低リスク** - テスト環境構成（GitHub Actionsマトリクスで明確）
- **1: 中リスク** - 組織的なテスト役割分担（推測に基づく）
- **1: 中リスク** - 不具合管理プロセスの詳細（部分的な根拠のみ）

## 6) レビュアーチェックリスト（最小）

- [ ] pyproject.tomlの依存関係バージョンが最新の実態と一致しているか確認
- [ ] CI/CDワークフローの記述内容が実際の設定と整合しているか確認
- [ ] テストファイル数（454ファイル）が現在の状態と一致しているか確認
- [ ] カバレッジ100%の要件が実際に適用されているか確認
- [ ] テスト担当者の役割分担について、プロジェクト関係者に確認
- [ ] 不具合管理プロセスの詳細について、プロジェクト関係者に確認
