# テスト方針書

## 概要

本ドキュメントは、FastAPIフレームワークプロジェクトのテスト方針を定義するものである。FastAPIはPythonの高性能WebAPIフレームワークであり、本プロジェクトでは網羅的な自動テストにより100%のコードカバレッジを達成することを目標としている。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 個々のエンドポイント・関数・クラスの動作検証 | 開発者 |
| 結合テスト | 複数コンポーネント間の連携動作検証（依存性注入、ミドルウェア等） | 開発者 |
| システムテスト | APIエンドポイント全体のE2E動作検証 | 開発者 |
| 受入テスト | ドキュメント内サンプルコードの動作検証 | 開発者/レビュアー |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | HTTPリクエスト/レスポンス、パラメータ検証、OpenAPIスキーマ生成等の検証 | プルリクエスト時、マージ時 |
| 性能テスト | レスポンス速度・スループットのベンチマーク測定 | CodSpeedによる継続的ベンチマーク（CI/CD） |
| セキュリティテスト | OAuth2、JWT、HTTPBasic等の認証・認可機能の検証 | プルリクエスト時、マージ時 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| ローカル開発環境 | 開発時のテスト実行 | Python 3.9-3.14、pytest、coverage |
| GitHub Actions (ubuntu-latest) | CI/CDでのテスト実行、カバレッジ測定 | Python 3.9, 3.13, 3.14、coverage、Smokeshow |
| GitHub Actions (macos-latest) | クロスプラットフォームテスト | Python 3.10, 3.14 |
| GitHub Actions (windows-latest) | クロスプラットフォームテスト | Python 3.12, 3.14 |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| pytest | テストフレームワーク | >=7.1.3, <9.0.0 |
| coverage | コードカバレッジ測定 | >=6.5.0, <8.0 |
| httpx | HTTPクライアント（テストクライアント用） | >=0.23.0, <1.0.0 |
| anyio[trio] | 非同期テストサポート | >=3.2.1, <5.0.0 |
| dirty-equals | アサーション補助 | 0.9.0 |
| inline-snapshot | スナップショットテスト | >=0.21.1 |
| mypy | 静的型チェック | 1.14.1 |
| ruff | リンター・フォーマッター | 0.14.3 |
| pytest-codspeed | パフォーマンスベンチマーク | 4.2.0 |
| Smokeshow | カバレッジレポート公開 | >=0.5.0 |

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 100% |
| 分岐カバレッジ | 100% |

※ CI/CDパイプラインで `coverage report --fail-under=100` により100%カバレッジが必須要件として設定されている。

## テストデータ

### テストデータの準備方針

- **インラインデータ**: 各テストファイル内でテストケースごとにデータを定義
- **パラメータ化テスト**: `@pytest.mark.parametrize`を使用して複数のテストケースを効率的に実行
- **ファクトリパターン**: Pydanticモデルを使用したテストデータの生成
- **フィクスチャ**: `pytest.fixture`を使用した共通テストデータ・クライアントの準備
- **TestClient**: `fastapi.testclient.TestClient`を使用したAPIテストの実行

### テストディレクトリ構成

```
tests/
├── __init__.py
├── main.py                          # テスト用共通FastAPIアプリケーション
├── test_*.py                        # 単体・結合テスト（約450ファイル）
├── benchmarks/                      # パフォーマンスベンチマーク
│   └── test_general_performance.py
└── test_request_params/             # リクエストパラメータテスト
    ├── test_body/
    ├── test_cookie/
    ├── test_file/
    ├── test_form/
    ├── test_header/
    ├── test_path/
    └── test_query/
```

## 不具合管理

### 不具合報告プロセス

- GitHubのIssue機能を使用して不具合を管理
- Issue Managerによる自動ラベル付けとステータス管理
- PRとIssueの連携によるトラッキング

### 不具合分類

- バグ: 実装の誤り
- リグレッション: 既存機能の破壊
- 互換性: Python/依存ライブラリのバージョン間の問題

## CI/CD連携

### GitHub Actions ワークフロー

#### test.yml - メインテストワークフロー

| トリガー | 条件 |
| --- | --- |
| push | masterブランチへのプッシュ |
| pull_request | PRのopen/synchronize |
| schedule | 毎週月曜0:00（cron） |

#### テストジョブ

1. **マトリクステスト**:
   - OS: ubuntu-latest, macos-latest, windows-latest
   - Python: 3.9, 3.10, 3.12, 3.13, 3.14
   - カバレッジ計測対象: 特定の組み合わせのみ

2. **CodSpeedベンチマーク**:
   - ubuntu-latest + Python 3.13
   - `pytest --codspeed`でパフォーマンス計測

3. **カバレッジ結合**:
   - 全プラットフォームのカバレッジを結合
   - 100%カバレッジの達成を検証
   - HTMLレポートの生成

#### smokeshow.yml - カバレッジレポート公開

- テストワークフロー完了後に実行
- カバレッジHTMLレポートをSmokeshowにアップロード
- PRステータスにカバレッジ率を表示

### pre-commit連携

| フック | 目的 |
| --- | --- |
| ruff check | コードスタイル・品質チェック |
| ruff format | 自動フォーマット |
| check-toml | TOML構文チェック |
| check-yaml | YAML構文チェック |

### テスト実行コマンド

```bash
# 全テスト実行（カバレッジ付き）
bash scripts/test.sh

# カバレッジHTMLレポート生成
bash scripts/test-cov-html.sh

# ベンチマークテスト
pytest tests/ --codspeed
```

## 備考

### Pythonバージョンサポート

- Python 3.9 - 3.14をサポート
- 各Pythonバージョンでのテスト実行をCI/CDで保証

### 依存ライブラリ

- Pydantic v2 (>=2.7.0) との互換性を重視
- Starlette (>=0.40.0, <0.51.0) との連携テスト
- 非同期処理: anyio、trioによるテストサポート

### テストの特徴

- **型安全性**: mypyによる静的型チェック
- **スナップショットテスト**: inline-snapshotによるOpenAPIスキーマ検証
- **セキュリティテスト**: OAuth2、JWT、HTTP認証の包括的テスト（36テストファイル）
- **ドキュメントテスト**: docs_src内のサンプルコードの動作検証
