# ER図

## 概要

本ドキュメントは、FastAPIサンプルチュートリアルで使用されているデータベースのエンティティ関係図（ER図）をMermaid形式で記載しています。

## ER図（Mermaid形式）

```mermaid
erDiagram
    hero {
        INTEGER id PK "主キー - 自動採番"
        TEXT name "ヒーローの公開名 - インデックス付き"
        INTEGER age "ヒーローの年齢（NULL許可） - インデックス付き"
        TEXT secret_name "ヒーローの秘密の名前"
    }
```

## データモデルの関係図

以下は、SQLModelで定義されたPythonクラス間の継承関係を示します。

```mermaid
classDiagram
    class SQLModel {
        <<abstract>>
    }

    class HeroBase {
        +str name
        +int|None age
    }

    class Hero {
        +int|None id
        +str name
        +int|None age
        +str secret_name
    }

    class HeroPublic {
        +int id
        +str name
        +int|None age
    }

    class HeroCreate {
        +str name
        +int|None age
        +str secret_name
    }

    class HeroUpdate {
        +str|None name
        +int|None age
        +str|None secret_name
    }

    SQLModel <|-- HeroBase : extends
    HeroBase <|-- Hero : extends
    HeroBase <|-- HeroPublic : extends
    HeroBase <|-- HeroCreate : extends
    HeroBase <|-- HeroUpdate : extends

    Hero : table=True

    note for Hero "テーブルモデル（DBにマッピング）"
    note for HeroPublic "APIレスポンス用モデル"
    note for HeroCreate "作成リクエスト用モデル"
    note for HeroUpdate "更新リクエスト用モデル"
```

## APIデータフロー図

```mermaid
flowchart LR
    subgraph Client["クライアント"]
        A[リクエスト]
        H[レスポンス]
    end

    subgraph API["FastAPI"]
        B[HeroCreate]
        C[HeroUpdate]
        G[HeroPublic]
    end

    subgraph Database["SQLite DB"]
        D[(hero テーブル)]
        E[Hero モデル]
    end

    A -->|POST /heroes/| B
    A -->|PATCH /heroes/id| C
    B -->|バリデーション後変換| E
    C -->|バリデーション後変換| E
    E -->|INSERT/UPDATE| D
    D -->|SELECT| E
    E -->|レスポンス変換| G
    G --> H
```

## テーブル詳細

### hero テーブル

| 属性 | 値 |
| --- | --- |
| テーブル名 | hero |
| 主キー | id (INTEGER) |
| インデックス | name, age |
| 外部キー | なし |
| エンジン | SQLite |

## 備考

- 現在のサンプルアプリケーションは単一テーブル構成であり、テーブル間のリレーションシップは存在しません。
- 実際の本番アプリケーションでは、ヒーローとチーム、ヒーローと能力など、複数テーブル間のリレーションシップが追加されることが想定されます。
- SQLModelを使用することで、データモデルの継承を活用し、コードの重複を最小限に抑えた設計が実現されています。
