# データベース設計書

## 概要

本ドキュメントは、FastAPIフレームワークのサンプルチュートリアルで使用されているデータベース設計について記載しています。このプロジェクトでは、SQLModel（SQLAlchemyとPydanticを統合したORM）を使用してSQLiteデータベースとの連携を実現しています。サンプルアプリケーションは「ヒーロー管理システム」を題材としており、ヒーロー情報の登録・参照・更新・削除（CRUD操作）を提供します。

## テーブル一覧

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| hero | Hero | ヒーロー情報を管理するテーブル。ヒーローの名前、年齢、秘密の名前を格納する。 |

## 各テーブル定義

### 1. hero

ヒーロー情報を管理するメインテーブルです。各ヒーローの基本情報（名前、年齢）と秘密情報（secret_name）を保持します。SQLModelの`table=True`パラメータにより、Pythonクラス`Hero`がデータベーステーブルにマッピングされています。

| カラム名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| id | INTEGER | NO | 主キー。自動採番される一意の識別子。 |
| name | TEXT (VARCHAR) | NO | ヒーローの公開名。インデックスが設定されており、検索性能が最適化されている。 |
| age | INTEGER | YES | ヒーローの年齢。任意項目。インデックスが設定されている。 |
| secret_name | TEXT (VARCHAR) | NO | ヒーローの秘密の名前。API経由では公開されない機密情報。 |

#### インデックス

| インデックス名 | カラム | 種類 | 説明 |
| --- | --- | --- | --- |
| ix_hero_name | name | 通常インデックス | 名前による検索を高速化 |
| ix_hero_age | age | 通常インデックス | 年齢による検索を高速化 |

#### 制約

| 制約種類 | 対象カラム | 説明 |
| --- | --- | --- |
| PRIMARY KEY | id | 一意性を保証する主キー制約 |
| NOT NULL | id, name, secret_name | NULL値を許可しない制約 |

## 関連モデル（データモデル）

SQLModelでは、テーブルモデル（`table=True`）に加えて、API用のデータモデルが定義されています。これらはデータベーステーブルには直接マッピングされませんが、データの入出力時のバリデーションとシリアライズに使用されます。

### HeroBase（基底データモデル）

各モデル間で共有されるフィールドを定義した基底クラスです。

| フィールド名 | データ型 | 説明 |
| --- | --- | --- |
| name | str | ヒーローの公開名 |
| age | int または None | ヒーローの年齢（任意） |

### HeroPublic（公開用データモデル）

APIレスポンスとして返却されるデータモデルです。secret_nameは含まれません。

| フィールド名 | データ型 | 説明 |
| --- | --- | --- |
| id | int | ヒーローID（必須） |
| name | str | ヒーローの公開名 |
| age | int または None | ヒーローの年齢（任意） |

### HeroCreate（作成用データモデル）

新規ヒーロー作成時のリクエストボディに使用されます。

| フィールド名 | データ型 | 説明 |
| --- | --- | --- |
| name | str | ヒーローの公開名 |
| age | int または None | ヒーローの年齢（任意） |
| secret_name | str | ヒーローの秘密の名前 |

### HeroUpdate（更新用データモデル）

ヒーロー情報更新時のリクエストボディに使用されます。全フィールドが任意です。

| フィールド名 | データ型 | 説明 |
| --- | --- | --- |
| name | str または None | ヒーローの公開名（任意） |
| age | int または None | ヒーローの年齢（任意） |
| secret_name | str または None | ヒーローの秘密の名前（任意） |

## データベース接続情報

| 項目 | 値 | 説明 |
| --- | --- | --- |
| データベース種類 | SQLite | 軽量な組み込みデータベース |
| 接続文字列 | sqlite:///database.db | ファイルベースのSQLiteデータベース |
| 接続オプション | check_same_thread=False | マルチスレッド環境での使用を許可 |

## テーブル作成方法

テーブルはアプリケーション起動時に自動作成されます。

```python
SQLModel.metadata.create_all(engine)
```

本番環境では、Alembicなどのマイグレーションツールの使用が推奨されています。

## 備考

- このプロジェクトはFastAPIフレームワーク自体のリポジトリであり、SQLデータベースの使用方法を示すチュートリアル用のサンプルコードが含まれています。
- 実際のアプリケーション開発では、SQLiteではなくPostgreSQLなどの本格的なデータベースサーバーの使用が推奨されています。
- SQLModelはSQLAlchemyとPydanticを統合したライブラリであり、型安全なデータベース操作とAPIデータバリデーションを同時に実現しています。
- secret_nameフィールドはデータベースに保存されますが、APIレスポンス（HeroPublic）には含まれないため、機密情報の保護が実現されています。
- 公式プロジェクトテンプレート（full-stack-fastapi-template）ではPostgreSQLとより本格的な構成が提供されています。
