# バッチ設計書 1-contributors

## 概要

本ドキュメントは、FastAPIプロジェクトにおけるコントリビューター情報収集バッチ（contributors.py）の設計仕様を記載する。

### 本バッチの処理概要

GitHub GraphQL APIを使用してFastAPIリポジトリのプルリクエストデータを収集し、コントリビューター・翻訳者・翻訳レビュアーの情報を集計してYAMLファイルを自動更新するバッチ処理である。

**業務上の目的・背景**：FastAPIプロジェクトでは、コントリビューター、翻訳者、翻訳レビュアーの貢献を可視化し、ドキュメントサイトで表示するためにこのバッチが必要である。手動で管理すると膨大な作業量となるため、自動化により正確かつ効率的にデータを最新状態に保つことができる。また、貢献者への感謝を示すことでコミュニティの活性化にも寄与する。

**バッチの実行タイミング**：GitHub Actionsにより定期実行（日次またはイベントトリガー）。プルリクエストがマージされたタイミングや定期スケジュールで実行される。

**主要な処理内容**：
1. GitHub GraphQL APIを使用して全プルリクエスト情報をページネーション付きで取得
2. プルリクエストのラベル（lang-all）を確認し、翻訳関連PRを識別
3. マージ済みPRの作者をコントリビューターまたは翻訳者として集計
4. PRレビュアーを翻訳レビュアーとして集計
5. 貢献回数が2回以上のユーザーをフィルタリング
6. contributors.yml、translators.yml、translation_reviewers.ymlを更新
7. データに変更がある場合、新規ブランチを作成してPRを自動生成

**前後の処理との関連**：本バッチは独立して実行可能だが、生成されたPRはメンテナーによるレビュー・マージが必要。更新されたYAMLファイルはドキュメントビルド時に参照される。

**影響範囲**：docs/en/data/配下のcontributors.yml、translators.yml、translation_reviewers.ymlファイル、およびGitHubリポジトリ（ブランチ作成、PR作成）に影響する。

## バッチ種別

データ連携 / データ集計処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次または随時 |
| 実行時刻 | GitHub Actions設定による |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | cron/GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_TOKEN環境変数 | GitHub APIアクセス用のトークンが設定されていること |
| GITHUB_REPOSITORY環境変数 | 対象リポジトリ（fastapi/fastapi形式）が設定されていること |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

環境変数が正しく設定されていれば実行可能。GitHub APIへの認証が失敗した場合は処理を中断する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| github_token | SecretStr | Yes | - | GitHub APIトークン |
| github_repository | str | Yes | - | 対象リポジトリ名 |
| httpx_timeout | int | No | 30 | HTTPリクエストタイムアウト（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub GraphQL API | JSON | プルリクエスト情報（PR番号、ラベル、作者、レビュー等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs/en/data/contributors.yml | YAML | コントリビューター一覧（ログイン名、貢献回数、アバターURL、プロフィールURL） |
| docs/en/data/translators.yml | YAML | 翻訳者一覧 |
| docs/en/data/translation_reviewers.yml | YAML | 翻訳レビュアー一覧 |
| GitHub Pull Request | - | データ更新時に自動作成されるPR |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | contributors.yml / translators.yml / translation_reviewers.yml |
| 出力先 | docs/en/data/ |
| 文字コード | UTF-8 |
| 区切り文字 | YAML形式 |

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ 環境変数からgithub_token、github_repositoryを取得
2. GitHub GraphQL APIからPR情報取得
   └─ ページネーション付きで全PRを取得（100件ずつ）
3. PR情報解析・集計
   └─ lang-allラベルの有無で翻訳PRを判定
   └─ マージ済みPRの作者をコントリビューター/翻訳者として集計
   └─ レビュアーを翻訳レビュアーとして集計
4. フィルタリング
   └─ 貢献回数2回以上のユーザーを抽出
5. YAMLファイル更新判定
   └─ 既存ファイルと比較して変更があるか確認
6. ファイル更新（変更がある場合）
   └─ 3つのYAMLファイルを更新
7. Git操作・PR作成（変更がある場合）
   └─ 新規ブランチ作成、コミット、プッシュ、PR作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み]
    B --> C[GitHub APIからPR情報取得]
    C --> D[PR情報解析・集計]
    D --> E[ユーザーフィルタリング]
    E --> F[既存YAMLファイル読み込み]
    F --> G{データ変更あり?}
    G -->|あり| H[YAMLファイル更新]
    H --> I[新規ブランチ作成]
    I --> J[コミット・プッシュ]
    J --> K[PR作成]
    K --> L[バッチ終了]
    G -->|なし| L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルベースのデータ管理を行う。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（ファイルベース処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | HTTPエラー | GitHub API応答が200以外 | RuntimeError発生、ログ出力後に処理中断 |
| - | GraphQLエラー | APIレスポンスにerrorsが含まれる | RuntimeError発生、ログ出力後に処理中断 |
| - | Git操作エラー | git操作失敗（subprocess.run check=True） | CalledProcessError発生、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（明示的なリトライ処理は実装されていない） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ログを確認しエラー原因を特定
2. GitHub APIのレートリミット超過の場合は時間をおいて再実行
3. 認証エラーの場合はトークンの有効性を確認
4. ネットワークエラーの場合は接続状況を確認して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体（全ファイル更新後に一括コミット） |
| コミットタイミング | 全YAMLファイル更新完了後 |
| ロールバック条件 | Git操作前のエラーは自動ロールバック不要。PR作成失敗時はブランチ削除が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千〜数万件のPR |
| 目標処理時間 | 数分〜十数分（PR数に依存） |
| メモリ使用量上限 | 特に制限なし（PR情報を全てメモリに保持） |

## 排他制御

同時実行不可。GitHub Actionsの設定でconcurrency制御を行う。同一ブランチ名のPRが既に存在する場合はエラーとなる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 設定情報（トークン除く） |
| 進捗ログ | 処理中 | ブランチ作成、ファイル追加、コミット、プッシュ、PR作成の各ステップ |
| 終了ログ | バッチ終了時 | 作成されたPR番号、または変更なしのメッセージ |
| エラーログ | エラー発生時 | HTTPステータスコード、エラーメッセージ、レスポンス内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- 最小貢献回数（min_count）はデフォルトで2回に設定されている
- PRの状態がMERGEDのもののみがコントリビューターとしてカウントされる
- ブランチ名には secrets.token_hex(4) によるランダム文字列が付与され、重複を防ぐ
