# バッチ設計書 10-translation_fixer

## 概要

本ドキュメントは、FastAPIプロジェクトにおける翻訳整合性修正バッチ（translation_fixer.py）の設計仕様を記載する。

### 本バッチの処理概要

翻訳ドキュメントと英語原文を比較し、翻訳の構造的不整合を自動修正するCLIツールである。コードブロック、ヘッダー、リンク等のMarkdown構造が英語版と一致するよう翻訳を調整する。

**業務上の目的・背景**：FastAPIの多言語ドキュメントは、英語原文の更新に伴い翻訳も更新される。LLMによる自動翻訳や人手による翻訳では、Markdown構造の不整合（コードブロックの内容変更、リンク切れ、ヘッダー構造の違い等）が発生することがある。これらの不整合はドキュメントビルド時にエラーとなったり、読者に誤った情報を提供する原因となる。本バッチはこれらの構造的不整合を自動検出・修正し、翻訳品質を維持する。

**バッチの実行タイミング**：GitHub Actionsで翻訳PR提出時に実行、またはtranslate.pyと連携して翻訳後に自動実行される。

**主要な処理内容**：
1. fix-all: 特定言語の全翻訳ドキュメントを修正
2. fix-pages: 指定されたドキュメントのみを修正
3. 各ドキュメントについて：
   - 英語版と翻訳版を比較
   - doc_parsing_utils.check_translationで整合性チェック
   - 自動修正モードで不整合を修正
   - 修正結果をファイルに書き戻し

**前後の処理との関連**：translate.pyで生成された翻訳ドキュメントの品質チェック・修正に使用。docs.pyのビルド前に実行することで、ビルドエラーを防ぐ。

**影響範囲**：docs/{lang}/docs/配下の翻訳ドキュメントファイルに影響する。

## バッチ種別

データ検証 / データ修正処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イベントトリガー、手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Python依存パッケージ | typer、doc_parsing_utilsがインストールされていること |
| 英語ドキュメント | docs/en/docs/配下に英語版が存在すること |
| 翻訳ドキュメント | 対象言語の翻訳ドキュメントが存在すること |

### 実行可否判定

- 対象言語のドキュメントディレクトリが存在すること
- 対応する英語版ドキュメントが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| language | str | fix-all時必須 | - | 対象言語コード |
| doc_paths | list[Path] | fix-pages時必須 | - | 修正対象のドキュメントパスリスト |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| docs/en/docs/*.md | Markdown | 英語版ドキュメント（比較元） |
| docs/{lang}/docs/*.md | Markdown | 翻訳ドキュメント（修正対象） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs/{lang}/docs/*.md | Markdown | 修正された翻訳ドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力と同一 |
| 出力先 | 入力と同一パス（上書き） |
| 文字コード | UTF-8 |
| 改行コード | LF（最終行に改行追加） |

## 処理フロー

### 処理シーケンス

```
1. コマンド解析
   └─ typerによるCLI引数解析
   └─ fix-all: 言語を指定して全ファイル処理
   └─ fix-pages: ファイルリストを直接指定
2. 対象ファイル列挙
   └─ fix-all: 翻訳対象セクションのファイルを列挙
   └─ fix-pages: 引数で渡されたファイルリストを使用
3. ファイル個別処理
   └─ 言語コードをパスから抽出
   └─ 英語版パスを生成
   └─ 翻訳版と英語版を読み込み
   └─ check_translation関数で整合性チェック・修正
   └─ 修正結果をファイルに書き戻し
4. 結果判定
   └─ 全ファイル成功: 終了コード0
   └─ 1つでも失敗: 終了コード1
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[コマンド解析]
    B --> C{コマンド種別}
    C -->|fix-all| D[対象言語のファイル列挙]
    C -->|fix-pages| E[引数のファイルリスト]
    D --> F[ファイル処理ループ]
    E --> F
    F --> G[言語コード抽出]
    G --> H{英語版?}
    H -->|Yes| I[スキップ]
    H -->|No| J[英語版パス生成]
    J --> K[翻訳版・英語版読み込み]
    K --> L[check_translation実行]
    L --> M[修正結果書き戻し]
    M --> N{エラー発生?}
    N -->|Yes| O[エラー記録]
    N -->|No| P[成功記録]
    I --> Q{次のファイルあり?}
    O --> Q
    P --> Q
    Q -->|あり| F
    Q -->|なし| R{全ファイル成功?}
    R -->|Yes| S[終了コード0で終了]
    R -->|No| T[終了コード1で終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルベースのデータ処理を行う。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（ファイルベース処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ValueError | check_translation処理中のエラー | エラーログ出力、処理継続、最終的にExit(1) |
| - | typer.Exit(1) | 1つ以上のファイルで処理失敗 | 失敗ファイルを確認して手動修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーログから失敗ファイルを特定
2. 英語版と翻訳版を手動で比較
3. 構造的不整合を手動で修正
4. 再度バッチを実行して確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | ファイル単位 |
| コミットタイミング | 各ファイル処理完了後（即時書き込み） |
| ロールバック条件 | 自動ロールバックなし。Gitで差分確認・リバート可能 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ページ |
| 目標処理時間 | 数秒〜数分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一ファイルへの同時実行は推奨しない。通常は言語単位で実行されるため、異なる言語間での競合は発生しない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 進捗ログ | 処理中 | 処理中のファイルパス |
| スキップログ | スキップ時 | 英語ドキュメントのスキップメッセージ |
| エラーログ | エラー発生時 | エラー内容、対象ファイルパス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ（終了コード1） |

## 備考

- 翻訳対象外セクション：reference、release-notes.md、fastapi-people.md、external-links.md、newsletter.md、management-tasks.md、management.md、contributing.md
- 翻訳優先順位（iter_all_lang_paths）：learn → tutorial → advanced → about → how-to → その他
- check_translation関数はscripts/doc_parsing_utils.pyで定義
- auto_fix=Trueで自動修正モードを有効化
- 最終行に改行を追加して出力
- 英語版ドキュメントはスキップされる（lang_code == "en"チェック）
