# バッチ設計書 3-sponsors

## 概要

本ドキュメントは、FastAPIプロジェクトにおけるスポンサー情報収集バッチ（sponsors.py）の設計仕様を記載する。

### 本バッチの処理概要

GitHub GraphQL APIを使用してGitHubスポンサー情報を収集し、金額ティア別に整理してgithub_sponsors.ymlファイルを自動更新するバッチ処理である。

**業務上の目的・背景**：FastAPIプロジェクトはオープンソースソフトウェアであり、スポンサーからの支援がプロジェクトの持続可能性にとって重要である。スポンサー情報をドキュメントサイトに表示することで、支援者への感謝を示すとともに、新規スポンサーの獲得にも寄与する。手動管理では更新漏れが発生しやすいため、自動化により正確かつタイムリーにスポンサー情報を反映する。

**バッチの実行タイミング**：GitHub Actionsにより定期実行（日次または週次）。スポンサー情報の変更を検出して自動的にPRを作成する。

**主要な処理内容**：
1. GitHub GraphQL APIを使用してtiangolo（メンテナー）へのスポンサーシップ情報を取得
2. スポンサーを月額金額のティア別にグループ化
3. 金額の降順でスポンサーリストを整理
4. github_sponsors.ymlファイルを更新
5. データに変更がある場合、新規ブランチを作成してPRを自動生成

**前後の処理との関連**：本バッチは独立して実行可能。更新されたYAMLファイルはドキュメントビルド時に参照され、スポンサーセクションに表示される。

**影響範囲**：docs/en/data/github_sponsors.ymlファイル、およびGitHubリポジトリ（ブランチ作成、PR作成）に影響する。

## バッチ種別

データ連携 / データ集計処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次または週次 |
| 実行時刻 | GitHub Actions設定による |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | cron/GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| SPONSORS_TOKEN環境変数 | スポンサー情報取得用のGitHub APIトークン |
| PR_TOKEN環境変数 | PR作成用のGitHub APIトークン |
| GITHUB_REPOSITORY環境変数 | 対象リポジトリ（fastapi/fastapi形式） |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

環境変数が正しく設定されていれば実行可能。GitHub APIへの認証が失敗した場合は処理を中断する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| sponsors_token | SecretStr | Yes | - | スポンサー情報取得用トークン |
| pr_token | SecretStr | Yes | - | PR作成用トークン |
| github_repository | str | Yes | - | 対象リポジトリ名 |
| httpx_timeout | int | No | 30 | HTTPリクエストタイムアウト（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub GraphQL API | JSON | tiangolo氏へのスポンサーシップ情報（スポンサーエンティティ、ティア情報） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs/en/data/github_sponsors.yml | YAML | スポンサー一覧（ティア別グループ、ログイン名、アバターURL、プロフィールURL） |
| GitHub Pull Request | - | データ更新時に自動作成されるPR |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | github_sponsors.yml |
| 出力先 | docs/en/data/ |
| 文字コード | UTF-8 |
| 区切り文字 | YAML形式 |

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ 環境変数からsponsors_token、pr_token、github_repositoryを取得
2. GitHub GraphQL APIからスポンサー情報取得
   └─ ページネーション付きで全スポンサーを取得（100件ずつ）
   └─ tiangolo氏へのスポンサーシップを対象
3. ティア別集計
   └─ monthlyPriceInDollarsでグループ化
   └─ 金額降順でソート
4. YAMLファイル更新判定
   └─ 既存ファイルと比較して変更があるか確認
5. ファイル更新（変更がある場合）
   └─ github_sponsors.ymlを更新
6. Git操作・PR作成（変更がある場合）
   └─ 新規ブランチ作成、コミット、プッシュ、PR作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み]
    B --> C[GitHub APIからスポンサー情報取得]
    C --> D[ティア別集計・ソート]
    D --> E[既存YAMLファイル読み込み]
    E --> F{データ変更あり?}
    F -->|あり| G[YAMLファイル更新]
    G --> H[新規ブランチ作成]
    H --> I[コミット・プッシュ]
    I --> J[PR作成]
    J --> K[バッチ終了]
    F -->|なし| K
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルベースのデータ管理を行う。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（ファイルベース処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | HTTPエラー | GitHub API応答が200以外 | RuntimeError発生、ログ出力後に処理中断 |
| - | GraphQLエラー | APIレスポンスにerrorsが含まれる | RuntimeError発生、ログ出力後に処理中断 |
| - | Git操作エラー | git操作失敗（subprocess.run check=True） | CalledProcessError発生、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（明示的なリトライ処理は実装されていない） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ログを確認しエラー原因を特定
2. GitHub APIのレートリミット超過の場合は時間をおいて再実行
3. 認証エラーの場合はトークンの有効性を確認（sponsors_tokenとpr_token両方）
4. ネットワークエラーの場合は接続状況を確認して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体（ファイル更新後に一括コミット） |
| コミットタイミング | YAMLファイル更新完了後 |
| ロールバック条件 | Git操作前のエラーは自動ロールバック不要。PR作成失敗時はブランチ削除が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百件のスポンサー |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行不可。GitHub Actionsの設定でconcurrency制御を行う。同一ブランチ名のPRが既に存在する場合はエラーとなる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 設定情報（トークン除く） |
| 進捗ログ | 処理中 | ブランチ作成、ファイル追加、コミット、プッシュ、PR作成の各ステップ |
| 終了ログ | バッチ終了時 | 作成されたPR番号、または変更なしのメッセージ |
| エラーログ | エラー発生時 | HTTPステータスコード、エラーメッセージ、レスポンス内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- tiangolo（@tiangolo）のGitHubスポンサーシップを対象としている
- sponsors_tokenとpr_tokenは別々に設定される設計（権限分離）
- スポンサーはOrganizationとUser両方に対応
- ティアは月額金額（monthlyPriceInDollars）で分類される
- ブランチ名には secrets.token_hex(4) によるランダム文字列が付与される
