# バッチ設計書 4-people

## 概要

本ドキュメントは、FastAPIプロジェクトにおけるエキスパートユーザー情報収集バッチ（people.py）の設計仕様を記載する。

### 本バッチの処理概要

GitHub GraphQL APIを使用してFastAPIリポジトリのディスカッション（Questions カテゴリ）から、質問に回答したエキスパートユーザー情報を収集し、期間別（1ヶ月/3ヶ月/6ヶ月/1年）に集計してpeople.ymlファイルを自動更新するバッチ処理である。

**業務上の目的・背景**：FastAPIのコミュニティでは、GitHub Discussionsで多くの質問がやり取りされている。積極的に回答するエキスパートユーザーを可視化することで、コミュニティへの貢献を称え、新規ユーザーが質問する際の参考となる信頼できる回答者を示すことができる。また、エキスパートのモチベーション向上にも寄与する。

**バッチの実行タイミング**：GitHub Actionsにより定期実行（日次）。ディスカッションの活動状況を定期的に集計し、最新のエキスパート情報を反映する。

**主要な処理内容**：
1. GitHub GraphQL APIを使用してQuestionsカテゴリのディスカッション情報を取得
2. 各ディスカッションのコメント・返信からユーザー活動を抽出
3. 期間別（直近1ヶ月/3ヶ月/6ヶ月/1年）にコメント数を集計
4. メンテナー情報を別途管理（tiangolo）
5. people.ymlファイルを更新
6. データに変更がある場合、新規ブランチを作成してPRを自動生成

**前後の処理との関連**：本バッチは独立して実行可能。更新されたYAMLファイルはドキュメントビルド時に参照され、FastAPI Peopleページに表示される。

**影響範囲**：docs/en/data/people.ymlファイル、およびGitHubリポジトリ（ブランチ作成、PR作成）に影響する。

## バッチ種別

データ連携 / データ集計処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次 |
| 実行時刻 | GitHub Actions設定による |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | cron/GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_TOKEN環境変数 | GitHub APIアクセス用のトークンが設定されていること |
| GITHUB_REPOSITORY環境変数 | 対象リポジトリ（fastapi/fastapi形式）が設定されていること |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

環境変数が正しく設定されていれば実行可能。GitHub APIへの認証が失敗した場合は処理を中断する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| github_token | SecretStr | Yes | - | GitHub APIトークン |
| github_repository | str | Yes | - | 対象リポジトリ名 |
| httpx_timeout | int | No | 30 | HTTPリクエストタイムアウト（秒） |
| sleep_interval | int | No | 5 | APIリクエスト間のスリープ時間（秒） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub GraphQL API | JSON | Questionsカテゴリのディスカッション情報（コメント、返信、作成日時等） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs/en/data/people.yml | YAML | エキスパート情報（メンテナー、全期間エキスパート、期間別エキスパート） |
| GitHub Pull Request | - | データ更新時に自動作成されるPR |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | people.yml |
| 出力先 | docs/en/data/ |
| 文字コード | UTF-8 |
| 区切り文字 | YAML形式 |

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ 環境変数からgithub_token、github_repositoryを取得
2. GitHub GraphQL APIからディスカッション情報取得
   └─ Questionsカテゴリ（category_id: MDE4OkRpc2N1c3Npb25DYXRlZ29yeTMyMDAxNDM0）を対象
   └─ ページネーション付きで全ディスカッションを取得（100件ずつ）
   └─ レートリミット対策として5秒間隔でリクエスト
3. コメント・返信解析
   └─ 各ディスカッションのコメントと返信を抽出
   └─ 質問者以外のユーザーをエキスパート候補として集計
4. 期間別集計
   └─ 現在日時から1ヶ月/3ヶ月/6ヶ月/1年の期間で分類
   └─ 各期間のコメント数を集計
5. フィルタリング
   └─ コメント数2回以上かつ上位60名を抽出
6. メンテナー情報設定
   └─ tiangolo氏をメンテナーとして別管理
7. YAMLファイル更新判定
   └─ 既存ファイルと比較して変更があるか確認
8. ファイル更新（変更がある場合）
   └─ people.ymlを更新
9. Git操作・PR作成（変更がある場合）
   └─ 新規ブランチ作成、コミット、プッシュ、PR作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み]
    B --> C[GitHub APIからディスカッション情報取得]
    C --> D[コメント・返信解析]
    D --> E[期間別集計]
    E --> F[ユーザーフィルタリング]
    F --> G[メンテナー情報設定]
    G --> H[既存YAMLファイル読み込み]
    H --> I{データ変更あり?}
    I -->|あり| J[YAMLファイル更新]
    J --> K[新規ブランチ作成]
    K --> L[コミット・プッシュ]
    L --> M[PR作成]
    M --> N[バッチ終了]
    I -->|なし| N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルベースのデータ管理を行う。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（ファイルベース処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | HTTPエラー | GitHub API応答が200以外 | RuntimeError発生、ログ出力後に処理中断 |
| - | GraphQLエラー | APIレスポンスにerrorsが含まれる | RuntimeError発生、ログ出力後に処理中断 |
| - | Git操作エラー | git操作失敗（subprocess.run check=True） | CalledProcessError発生、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（明示的なリトライ処理は実装されていない） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ログを確認しエラー原因を特定
2. GitHub APIのレートリミット超過の場合は時間をおいて再実行
3. セカンダリレートリミットの場合はsleep_intervalを調整
4. 認証エラーの場合はトークンの有効性を確認
5. ネットワークエラーの場合は接続状況を確認して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体（ファイル更新後に一括コミット） |
| コミットタイミング | YAMLファイル更新完了後 |
| ロールバック条件 | Git操作前のエラーは自動ロールバック不要。PR作成失敗時はブランチ削除が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数千〜数万件のディスカッション |
| 目標処理時間 | 数十分〜1時間（ディスカッション数とスリープ間隔に依存） |
| メモリ使用量上限 | 特に制限なし（ディスカッション情報を全てメモリに保持） |

## 排他制御

同時実行不可。GitHub Actionsの設定でconcurrency制御を行う。同一ブランチ名のPRが既に存在する場合はエラーとなる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 設定情報（トークン除く） |
| 進捗ログ | 処理中 | ブランチ作成、ファイル追加、コミット、プッシュ、PR作成の各ステップ |
| 終了ログ | バッチ終了時 | 作成されたPR番号、または変更なしのメッセージ |
| エラーログ | エラー発生時 | HTTPステータスコード、エラーメッセージ、レスポンス内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 2時間 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- 対象カテゴリはQuestions（ID: MDE4OkRpc2N1c3Npb25DYXRlZ29yeTMyMDAxNDM0）
- 最小コメント回数（min_count）はデフォルトで2回に設定
- エキスパートリストは上位60名まで出力
- ディスカッション作者（質問者）はエキスパート集計から除外される
- GitHubのセカンダリレートリミット対策として5秒間隔でAPIリクエスト
- tiangolo氏はメンテナーとして別セクションに表示
- 出力されるエキスパートカテゴリ：experts、last_month_experts、three_months_experts、six_months_experts、one_year_experts
