# バッチ設計書 5-docs

## 概要

本ドキュメントは、FastAPIプロジェクトにおける多言語ドキュメント管理バッチ（docs.py）の設計仕様を記載する。

### 本バッチの処理概要

多言語ドキュメントのビルド・管理を行うCLIツールである。新言語の追加、言語別ビルド、全言語ビルド、README生成、パーマリンク追加等の機能を提供し、ドキュメントサイトのビルドプロセス全体を管理する。

**業務上の目的・背景**：FastAPIは多言語でドキュメントを提供するプロジェクトである。mkdocsを使用した静的サイト生成を行っているが、多言語対応のためにはビルドプロセスが複雑になる。このバッチは、言語ごとのビルド設定管理、全言語の一括ビルド、ドキュメント品質の統一（パーマリンク追加など）を自動化し、ドキュメントメンテナンスの効率を大幅に向上させる。

**バッチの実行タイミング**：CI/CDパイプライン（GitHub Actions）での自動実行、または開発者によるローカル手動実行。ドキュメント変更時やリリース前のビルド確認時に実行される。

**主要な処理内容**：
1. new-lang: 新しい翻訳言語ディレクトリを初期化
2. build-lang: 特定言語のドキュメントをビルド
3. build-all: 全サポート言語のドキュメントを並列ビルド
4. update-languages: mkdocs.ymlの言語設定を更新
5. generate-readme: index.mdからREADME.mdを生成
6. add-permalinks: ヘッダーにパーマリンクを追加
7. serve/live: 開発用プレビューサーバー起動

**前後の処理との関連**：translate.pyで生成された翻訳ドキュメントをビルド対象とする。ビルド結果はデプロイパイプラインに渡される。

**影響範囲**：docs/配下の全言語ディレクトリ、site/ディレクトリ（ビルド出力）、README.md、docs/en/mkdocs.ymlに影響する。

## バッチ種別

ドキュメントビルド / データ変換処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CD、手動実行） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| mkdocs インストール | mkdocsコマンドが利用可能であること |
| Python依存パッケージ | typer、pyyaml、jinja2、slugify等がインストールされていること |
| docs/language_names.yml | 言語名定義ファイルが存在すること |

### 実行可否判定

- ドキュメントディレクトリ（docs/）が存在すること
- 対象言語のmkdocs.ymlが存在すること（build-lang時）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| lang | str | コマンドによる | en | 対象言語コード |
| dirty | bool | No | False | liveコマンドでダーティビルドを使用するか |
| update_existing | bool | No | False | 既存パーマリンクを更新するか |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| docs/{lang}/docs/*.md | Markdown | 各言語のドキュメントファイル |
| docs/{lang}/mkdocs.yml | YAML | 言語別mkdocs設定 |
| docs/en/mkdocs.yml | YAML | 英語版（ベース）mkdocs設定 |
| docs/language_names.yml | YAML | 言語コードと言語名のマッピング |
| docs/en/data/sponsors.yml | YAML | スポンサー情報（README生成用） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| site/{lang}/ | HTML/CSS/JS | ビルドされた静的サイト |
| README.md | Markdown | 生成されたREADMEファイル |
| docs/en/mkdocs.yml | YAML | 更新された言語設定 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 各種（HTML、Markdown等） |
| 出力先 | site/（ビルド出力）、プロジェクトルート（README.md） |
| 文字コード | UTF-8 |
| 区切り文字 | - |

## 処理フロー

### 処理シーケンス

```
1. コマンド解析
   └─ typerによるCLI引数解析
2. 言語設定読み込み
   └─ language_names.ymlから言語情報取得
3. コマンド別処理実行
   └─ new-lang: 言語ディレクトリ初期化
   └─ build-lang: mkdocs buildで単一言語ビルド
   └─ build-all: 並列プロセスで全言語ビルド
   └─ update-languages: mkdocs.ymlのalternate設定更新
   └─ generate-readme: index.mdからREADME.md生成
   └─ add-permalinks: ヘッダーにパーマリンク追加
   └─ serve/live: mkdocs serveでプレビューサーバー起動
4. 結果出力
   └─ 成功メッセージまたはエラーで終了
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[コマンド解析]
    B --> C{コマンド種別}
    C -->|new-lang| D[言語ディレクトリ作成]
    C -->|build-lang| E[単一言語ビルド]
    C -->|build-all| F[全言語並列ビルド]
    C -->|update-languages| G[mkdocs.yml更新]
    C -->|generate-readme| H[README生成]
    C -->|add-permalinks| I[パーマリンク追加]
    C -->|serve/live| J[プレビューサーバー起動]
    D --> K[update-languages呼び出し]
    F --> L[各言語build-lang呼び出し]
    E --> M[mkdocs build実行]
    H --> N[index.md読み込み・変換]
    I --> O[ヘッダー解析・slug生成]
    K --> P[バッチ終了]
    L --> P
    M --> P
    G --> P
    N --> P
    O --> P
    J --> P
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルベースのデータ管理を行う。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（ファイルベース処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | typer.Abort | 既に存在する言語を作成しようとした | エラーメッセージ表示後に中断 |
| - | typer.Abort | 存在しない言語をビルドしようとした | エラーメッセージ表示後に中断 |
| - | typer.Abort | language_names.ymlに言語名がない | エラーメッセージ表示後に中断 |
| - | typer.Exit(1) | README.mdが最新でない | 更新後に終了コード1で終了 |
| - | typer.Exit(1) | mkdocs.ymlが最新でない | 更新後に終了コード1で終了 |
| - | typer.Exit(1) | 翻訳禁止セクションにファイルが存在 | ファイル削除後に終了コード1で終了 |
| - | RuntimeError | スポンサーセクションが見つからない | エラーメッセージ表示 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. mkdocsのエラーログを確認してドキュメント構文エラーを修正
2. 依存パッケージのバージョン不整合を確認
3. language_names.ymlの設定漏れを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | コマンド単位 |
| コミットタイミング | 各コマンド完了後（ファイル書き込み即時） |
| ロールバック条件 | ビルド失敗時、site_build/ディレクトリは残る可能性がある |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数百ページ × 複数言語 |
| 目標処理時間 | 全言語ビルドで数分〜十数分 |
| メモリ使用量上限 | CPU数 × 4の並列プロセス |

## 排他制御

同一ビルドディレクトリへの同時実行は推奨しない。build-allでは並列処理が行われるが、言語ごとに出力先が分離されている。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | コマンド開始時 | 対象言語、使用プロセス数 |
| 進捗ログ | 処理中 | ビルド中の言語、更新中のファイル |
| 終了ログ | コマンド完了時 | 成功メッセージ |
| エラーログ | エラー発生時 | エラー内容、対象ファイル |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 30分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- サポート言語：en, de, es, ko, pt, ru, uk（SUPPORTED_LANGS定義）
- 翻訳禁止セクション：reference、release-notes.md、fastapi-people.md、external-links.md、newsletter.md、management-tasks.md、management.md、contributing.md
- 並列処理：CPU数 × 4のプロセスプールを使用
- パーマリンク生成：python-slugifyを使用、バッククォートや引用符を適切に処理
- MacOS向けにDYLD_FALLBACK_LIBRARY_PATHを/opt/homebrew/libに設定（Cairo対応）
- liveコマンドではLINENUMS=true環境変数でコード行番号を有効化
