# バッチ設計書 6-label_approved

## 概要

本ドキュメントは、FastAPIプロジェクトにおけるPR承認ラベル自動付与バッチ（label_approved.py）の設計仕様を記載する。

### 本バッチの処理概要

オープン状態のプルリクエストをチェックし、承認レビュー数に応じてラベル（approved-2等）を自動的に付与・削除するバッチ処理である。PyGitHubライブラリを使用してGitHub REST APIと連携する。

**業務上の目的・背景**：FastAPIプロジェクトでは、PRのマージ判断にレビュー承認数が重要な指標となる。特に翻訳PRは複数の承認が必要であり、承認状況を可視化することでメンテナーのレビューワークフローを効率化できる。手動でのラベル管理は漏れが発生しやすいため、自動化により正確かつ迅速にPRの承認状態を反映する。

**バッチの実行タイミング**：GitHub Actionsにより定期実行、またはPRへのレビューイベント時にトリガー実行される。

**主要な処理内容**：
1. リポジトリの全オープンPRを取得
2. 各PRのレビュー履歴を取得し、ユーザーごとの最新レビュー状態を判定
3. 承認（APPROVED）レビューの数をカウント
4. 設定された閾値以上の承認数があれば、approved-Nラベルを付与
5. 待機中ラベル（awaiting-review）があれば削除

**前後の処理との関連**：notify_translations.pyと連携し、翻訳PRの状態管理に使用される。承認ラベルの付与により、マージ判断が容易になる。

**影響範囲**：GitHubリポジトリのPRラベルに影響する。approved-2、awaiting-reviewなどのラベル状態が変更される。

## バッチ種別

データ連携 / ラベル管理自動化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イベントトリガー） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions（レビューイベント、スケジュール） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| TOKEN環境変数 | GitHub APIアクセス用のトークンが設定されていること |
| GITHUB_REPOSITORY環境変数 | 対象リポジトリ（fastapi/fastapi形式）が設定されていること |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

環境変数が正しく設定されていれば実行可能。GitHub APIへの認証が失敗した場合は処理を中断する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| token | SecretStr | Yes | - | GitHub APIトークン |
| github_repository | str | Yes | - | 対象リポジトリ名 |
| debug | bool | No | False | デバッグログ出力の有効化 |
| config | dict | No | default_config | ラベル設定（ラベル名、必要承認数、待機ラベル） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub REST API | JSON | オープンPR一覧、PRラベル、PRレビュー情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub PRラベル | - | approved-2等のラベルを付与/削除 |

### 出力ファイル仕様

本バッチはファイル出力を行わない（GitHub API操作のみ）。

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ 環境変数からtoken、github_repositoryを取得
   └─ ラベル設定（config）を読み込み
2. オープンPR取得
   └─ repo.get_pulls(state="open")で全オープンPRを取得
3. PR個別処理
   └─ 各PRのラベル一覧を取得
   └─ 各PRのレビュー一覧を取得
   └─ ユーザーごとに最新レビュー状態を判定
   └─ APPROVEDレビューの数をカウント
4. ラベル判定・更新
   └─ 設定された待機ラベルがある場合のみ処理
   └─ 承認数が閾値以上ならapproved-Nラベルを付与
   └─ 待機ラベルがあれば削除
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み]
    B --> C[オープンPR取得]
    C --> D[PR個別処理ループ]
    D --> E[PRラベル取得]
    E --> F[PRレビュー取得]
    F --> G[ユーザー別最新レビュー判定]
    G --> H[承認レビューカウント]
    H --> I{待機ラベルあり?}
    I -->|あり| J{承認数 >= 閾値?}
    I -->|なし| N[次のPRへ]
    J -->|Yes| K[approved-Nラベル付与]
    K --> L{待機ラベルあり?}
    L -->|あり| M[待機ラベル削除]
    L -->|なし| N
    M --> N
    J -->|No| N
    N --> O{次のPRあり?}
    O -->|あり| D
    O -->|なし| P[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。GitHub API操作のみ。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（GitHub API操作）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | GitHub APIエラー | API認証失敗、レートリミット超過 | ログ出力後に処理継続または中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（PyGitHub内部のリトライに依存） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ログを確認しエラー原因を特定
2. GitHub APIのレートリミット超過の場合は時間をおいて再実行
3. 認証エラーの場合はトークンの権限を確認（PRラベル編集権限が必要）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | PR単位 |
| コミットタイミング | 即時（API呼び出し時） |
| ロールバック条件 | 自動ロールバックなし。ラベル付与後に削除が失敗した場合、手動対応が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百件のオープンPR |
| 目標処理時間 | 数十秒〜数分 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行可能だが、同一PRに対する同時操作は競合の可能性がある。GitHub Actionsのconcurrency設定で制御することが望ましい。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 設定情報（トークン除く、debug=True時のみ） |
| 進捗ログ | 処理中 | 処理中のPR番号、ラベル追加/削除操作 |
| 終了ログ | バッチ終了時 | "Finished"メッセージ |
| エラーログ | エラー発生時 | エラー内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 10分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- デフォルト設定：approved-2ラベル（2件以上の承認で付与）、awaiting-review（待機ラベル）
- 同一ユーザーの複数レビューは最新のもののみを採用（submitted_atで判定）
- レビュー状態がAPPROVEDのもののみをカウント（CHANGES_REQUESTED、COMMENTED等は除外）
- 待機ラベルが存在しないPRはスキップされる（config.await_label設定による）
- CONFIG環境変数で設定をカスタマイズ可能（空文字の場合はdefault_configを使用）
