# バッチ設計書 7-notify_translations

## 概要

本ドキュメントは、FastAPIプロジェクトにおける翻訳PR通知バッチ（notify_translations.py）の設計仕様を記載する。

### 本バッチの処理概要

翻訳PRの状態をGitHub Discussionsに通知するバッチ処理である。新規翻訳PRの通知コメントを投稿し、PRが承認またはクローズされた際にコメントを完了マークに更新する。GitHub GraphQL APIを使用してDiscussionsとの連携を行う。

**業務上の目的・背景**：FastAPIの多言語翻訳はコミュニティの貢献者によって行われている。各言語の翻訳Discussionに新しい翻訳PRを通知することで、ネイティブスピーカーのレビュアーが翻訳PRを発見しやすくなる。また、完了したPRを自動的にマークすることで、Discussionの視認性を維持し、未完了のPRに集中できるようにする。

**バッチの実行タイミング**：GitHub Actionsにより、翻訳PRのラベル付与時やPR状態変更時にトリガー実行される。

**主要な処理内容**：
1. GitHub Actionsイベントから対象PR番号を取得
2. PRのラベルから言語を判定（lang-*ラベル）
3. 対象言語のTranslations Discussionを特定
4. 既存の通知コメントを検索
5. PRが awaiting-review 状態なら新規通知コメントを投稿
6. PRが approved-1 または closed なら通知コメントを完了マークに更新

**前後の処理との関連**：label_approved.pyと連携し、承認状態の変化を検出する。翻訳PRがマージされた後は、translation_fixer.pyで翻訳品質が確認される。

**影響範囲**：GitHub Discussions（Translationsカテゴリ）のコメントに影響する。

## バッチ種別

通知配信 / データ連携

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イベントトリガー） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions（PRラベル変更、PR状態変更） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_TOKEN環境変数 | GitHub APIアクセス用のトークンが設定されていること |
| GITHUB_REPOSITORY環境変数 | 対象リポジトリ（fastapi/fastapi形式）が設定されていること |
| GITHUB_EVENT_PATH環境変数 | GitHub Actionsイベントファイルのパス |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

- 対象PRにlang-allラベルとlang-*ラベルが付いていること
- 対象言語のTranslations Discussionが存在すること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| github_token | SecretStr | Yes | - | GitHub APIトークン |
| github_repository | str | Yes | - | 対象リポジトリ名 |
| github_event_path | Path | Yes | - | GitHub Actionsイベントファイルパス |
| github_event_name | str | No | - | GitHub Actionsイベント名 |
| httpx_timeout | int | No | 30 | HTTPリクエストタイムアウト（秒） |
| debug | bool | No | False | デバッグログ出力の有効化 |
| number | int | No | - | 手動指定のPR番号 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub Actionsイベントファイル | JSON | PRイベント情報（PR番号等） |
| GitHub REST API | JSON | PR情報、ラベル情報 |
| GitHub GraphQL API | JSON | Translations Discussion一覧、コメント情報 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Discussionsコメント | - | 翻訳PR通知コメント（新規投稿または更新） |

### 出力ファイル仕様

本バッチはファイル出力を行わない（GitHub API操作のみ）。

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ 環境変数からgithub_token、github_repository等を取得
2. イベント解析
   └─ GitHub Actionsイベントファイルから対象PR番号を取得
3. レースコンディション対策
   └─ 0〜10秒のランダムスリープ
4. PR情報取得
   └─ PRラベルを取得し、言語を判定
   └─ lang-allラベルがない場合はスキップ
5. Discussion特定
   └─ GraphQL APIでTranslations Discussionを取得
   └─ 言語ラベルでフィルタリング
6. 既存コメント検索
   └─ 対象Discussionのコメントを取得
   └─ 対象PRに関する既存通知を検索
7. コメント投稿/更新
   └─ awaiting-review: 新規通知コメント投稿
   └─ approved-1/closed: 完了マークに更新
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み]
    B --> C[イベント解析]
    C --> D[ランダムスリープ]
    D --> E[PR情報取得]
    E --> F{翻訳PR?}
    F -->|No| G[スキップして終了]
    F -->|Yes| H[Discussion特定]
    H --> I[既存コメント検索]
    I --> J{PR状態}
    J -->|open + awaiting| K{既存通知あり?}
    K -->|No| L[新規通知コメント投稿]
    K -->|Yes| M[ログ出力のみ]
    J -->|closed/approved| N{既存通知あり?}
    N -->|Yes| O[完了マークに更新]
    N -->|No| P{既存完了あり?}
    P -->|Yes| Q[ログ出力のみ]
    P -->|No| R[処理なし]
    L --> S[バッチ終了]
    M --> S
    O --> S
    Q --> S
    R --> S
    G --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。GitHub API操作のみ。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（GitHub API操作）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | RuntimeError | イベントファイルが存在しない | ログ出力後に処理中断 |
| - | RuntimeError | PR番号が取得できない | ログ出力後に処理中断 |
| - | RuntimeError | 対象言語のDiscussionが見つからない | ログ出力後に処理中断 |
| - | HTTPエラー | GitHub API応答が200以外 | RuntimeError発生、処理中断 |
| - | GraphQLエラー | APIレスポンスにerrorsが含まれる | RuntimeError発生、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ログを確認しエラー原因を特定
2. イベントファイルの内容を確認（PR番号の存在）
3. 対象言語のTranslations Discussionが存在するか確認
4. GitHub APIのレートリミット超過の場合は時間をおいて再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | コメント単位 |
| コミットタイミング | 即時（API呼び出し時） |
| ロールバック条件 | 自動ロールバックなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1PR/実行 |
| 目標処理時間 | 数秒〜数十秒（スリープ含む） |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一PRに対する同時実行は競合の可能性があるため、ランダムスリープ（0〜10秒）を実装して軽減している。GitHub Actionsのconcurrency設定での制御も推奨。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 設定情報（トークン除く、debug=True時のみ） |
| 進捗ログ | 処理中 | 対象PR、言語、Discussion番号、既存コメント状態、実行アクション |
| 終了ログ | バッチ終了時 | "Finished"メッセージ |
| エラーログ | エラー発生時 | エラー内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 1分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- Translations DiscussionカテゴリID: DIC_kwDOCZduT84CT5P9
- 待機ラベル: awaiting-review
- 言語識別ラベル: lang-all（翻訳PR識別用）、lang-*（言語識別用）
- 承認ラベル: approved-1
- 新規通知メッセージ形式: "Good news everyone! There's a new translation PR to be reviewed: #N by @user..."
- 完了メッセージ形式: "~There's a new translation PR to be reviewed: #N by @user~ Good job! This is done."
- ランダムスリープは複数ラベル付与時の競合を軽減するため
