# バッチ設計書 8-deploy_docs_status

## 概要

本ドキュメントは、FastAPIプロジェクトにおけるドキュメントデプロイステータス管理バッチ（deploy_docs_status.py）の設計仕様を記載する。

### 本バッチの処理概要

ドキュメントデプロイの状態をPRにコミットステータスとして設定し、プレビューリンクをコメントとして追加するバッチ処理である。PyGitHubライブラリを使用してGitHub REST APIと連携し、CI/CDパイプラインのデプロイ結果をPR上に可視化する。

**業務上の目的・背景**：FastAPIのドキュメントはPR毎にプレビュー環境にデプロイされる。レビュアーがPRのドキュメント変更を確認する際、プレビューリンクが提供されていると効率的にレビューできる。また、デプロイの成功/失敗状態をコミットステータスに反映することで、CIの状態が一目で分かるようになる。

**バッチの実行タイミング**：GitHub ActionsのCI/CDパイプラインで、ドキュメントデプロイジョブの開始時（pending）、成功時（success）、失敗時（error）に実行される。

**主要な処理内容**：
1. コミットSHAから対象PRを特定
2. state=pendingの場合：デプロイ中ステータスを設定
3. state=errorの場合：エラーステータスを設定
4. state=successの場合：
   - デプロイ成功ステータスを設定
   - 変更されたドキュメントファイルを解析
   - プレビューリンク一覧を生成
   - PRにコメントを投稿または更新

**前後の処理との関連**：docs.pyのbuild-all/build-langでビルドされたドキュメントがデプロイ対象。デプロイはGitHub Actionsの別ジョブで実行され、本バッチはその結果を通知する。

**影響範囲**：GitHubリポジトリのPRコミットステータス、PRコメントに影響する。

## バッチ種別

CI/CD連携 / 通知配信

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（CI/CDイベントトリガー） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | GitHub Actions（デプロイジョブの各フェーズ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_TOKEN環境変数 | GitHub APIアクセス用のトークンが設定されていること |
| GITHUB_REPOSITORY環境変数 | 対象リポジトリ（fastapi/fastapi形式）が設定されていること |
| COMMIT_SHA環境変数 | 対象コミットのSHA |
| RUN_ID環境変数 | GitHub ActionsのワークフローRun ID |
| STATE環境変数 | デプロイ状態（pending/success/error） |

### 実行可否判定

- 対象コミットSHAに紐づくオープンPRが存在すること
- 必須環境変数が設定されていること

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| github_token | SecretStr | Yes | - | GitHub APIトークン |
| github_repository | str | Yes | - | 対象リポジトリ名 |
| commit_sha | str | Yes | - | 対象コミットのSHA |
| run_id | int | Yes | - | GitHub ActionsのRun ID |
| state | Literal | Yes | pending | デプロイ状態 |
| deploy_url | str | No | None | デプロイ先URL（success時のみ） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub REST API | JSON | PR一覧、PRファイル一覧、コミット情報、PRコメント |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Commit Status | - | deploy-docsコンテキストのステータス |
| GitHub PRコメント | Markdown | プレビューリンク一覧 |

### 出力ファイル仕様

本バッチはファイル出力を行わない（GitHub API操作のみ）。

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ 環境変数からgithub_token、github_repository、commit_sha、run_id、state、deploy_urlを取得
2. PR特定
   └─ オープンPRからコミットSHAが一致するPRを検索
   └─ 該当PRがなければエラーログ出力して終了
3. 状態別処理
   └─ pending: "Deploying Docs"ステータスを設定
   └─ error: "Error Deploying Docs"ステータスを設定
   └─ success: 成功処理を実行
4. 成功処理（state=success）
   └─ deploy_urlがない場合："No Docs Changes"ステータスを設定
   └─ deploy_urlがある場合：
      └─ "Docs Deployed"ステータスを設定
      └─ 変更ファイル一覧を取得
      └─ docs/配下の変更ファイルを抽出
      └─ 言語別にプレビューリンクを生成
      └─ コメントメッセージを構築
      └─ 既存コメントを更新、またはコメント新規作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み]
    B --> C[オープンPRから対象PR検索]
    C --> D{PRあり?}
    D -->|No| E[エラーログ出力して終了]
    D -->|Yes| F{state}
    F -->|pending| G[Deploying Docsステータス設定]
    F -->|error| H[Error Deploying Docsステータス設定]
    F -->|success| I{deploy_urlあり?}
    I -->|No| J[No Docs Changesステータス設定]
    I -->|Yes| K[Docs Deployedステータス設定]
    K --> L[変更ファイル一覧取得]
    L --> M[docs/配下をフィルタリング]
    M --> N[言語別プレビューリンク生成]
    N --> O[コメントメッセージ構築]
    O --> P{既存コメントあり?}
    P -->|Yes| Q[コメント更新]
    P -->|No| R[コメント新規作成]
    G --> S[バッチ終了]
    H --> S
    J --> S
    Q --> S
    R --> S
    E --> S
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。GitHub API操作のみ。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（GitHub API操作）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ログエラー | 対象コミットSHAに紐づくPRがない | エラーログ出力、処理終了（例外発生なし） |
| - | GitHub APIエラー | API認証失敗、レートリミット超過 | 例外発生、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（PyGitHub内部のリトライに依存） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ログを確認しエラー原因を特定
2. PRが存在しない場合、コミットSHAが正しいか確認
3. GitHub APIのレートリミット超過の場合は時間をおいて再実行
4. 認証エラーの場合はトークンの権限を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 操作単位 |
| コミットタイミング | 即時（API呼び出し時） |
| ロールバック条件 | 自動ロールバックなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1PR/実行 |
| 目標処理時間 | 数秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同一PRに対する同時実行は競合の可能性があるが、通常は同一ワークフロー内で順次実行されるため問題ない。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 設定情報（トークン除く） |
| 進捗ログ | 処理中 | 各ステップの実行状態 |
| 終了ログ | バッチ終了時 | "Finished"メッセージ |
| エラーログ | エラー発生時 | PRが見つからない場合のメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 1分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- コミットステータスのコンテキスト: "deploy-docs"
- ステータスの種類:
  - pending: "Deploying Docs"
  - success（URL有）: "Docs Deployed"
  - success（URL無）: "No Docs Changes"
  - error: "Error Deploying Docs"
- コメントヘッダー: "## Docs preview"
- コメント作成者: github-actions[bot]
- プレビューリンク構造:
  - 英語: /path/
  - 他言語: /{lang}/path/
- 既存コメントの判定: ヘッダーテキストとユーザー名（github-actions[bot]）で識別
- 変更ファイルは言語別にソートして表示
- 本番サイトへのリンク（before）と英語版へのリンクも提供
