# バッチ設計書 9-topic_repos

## 概要

本ドキュメントは、FastAPIプロジェクトにおけるFastAPIトピックリポジトリ収集バッチ（topic_repos.py）の設計仕様を記載する。

### 本バッチの処理概要

GitHubでfastapiトピックを持つリポジトリを検索し、topic_repos.ymlファイルを自動更新するバッチ処理である。PyGitHubライブラリを使用してGitHub REST APIと連携し、FastAPIエコシステムの可視化に貢献する。

**業務上の目的・背景**：FastAPIは広範なエコシステムを持ち、多くのサードパーティライブラリやツールが開発されている。これらのリポジトリを自動的に収集し、ドキュメントサイトで紹介することで、ユーザーが関連プロジェクトを発見しやすくなる。手動管理では網羅性や鮮度の維持が困難なため、自動化によりエコシステム情報を最新に保つ。

**バッチの実行タイミング**：GitHub Actionsにより定期実行（日次または週次）。GitHubのトピック検索結果を定期的に収集し、変更があればPRを作成する。

**主要な処理内容**：
1. GitHub APIでfastapiトピックを持つリポジトリを検索
2. 検索結果から上位100件を取得（自身のリポジトリは除外）
3. リポジトリ情報（名前、URL、スター数、オーナー情報）を抽出
4. topic_repos.ymlファイルを更新
5. データに変更がある場合、新規ブランチを作成してPRを自動生成

**前後の処理との関連**：本バッチは独立して実行可能。更新されたYAMLファイルはドキュメントビルド時に参照され、関連リポジトリセクションに表示される。

**影響範囲**：docs/en/data/topic_repos.ymlファイル、およびGitHubリポジトリ（ブランチ作成、PR作成）に影響する。

## バッチ種別

データ連携 / データ収集処理

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 日次または週次 |
| 実行時刻 | GitHub Actions設定による |
| 実行曜日 | 全曜日 |
| 実行日 | 毎日 |
| トリガー | cron/GitHub Actions |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| GITHUB_TOKEN環境変数 | GitHub APIアクセス用のトークンが設定されていること |
| GITHUB_REPOSITORY環境変数 | 対象リポジトリ（fastapi/fastapi形式）が設定されていること |
| ネットワーク接続 | GitHub APIへのアクセスが可能であること |

### 実行可否判定

環境変数が正しく設定されていれば実行可能。GitHub APIへの認証が失敗した場合は処理を中断する。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| github_token | SecretStr | Yes | - | GitHub APIトークン |
| github_repository | str | Yes | - | 対象リポジトリ名 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| GitHub REST API | JSON | トピック検索結果（リポジトリ名、URL、スター数、オーナー情報） |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs/en/data/topic_repos.yml | YAML | FastAPIトピックリポジトリ一覧 |
| GitHub Pull Request | - | データ更新時に自動作成されるPR |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | topic_repos.yml |
| 出力先 | docs/en/data/ |
| 文字コード | UTF-8 |
| 区切り文字 | YAML形式 |

## 処理フロー

### 処理シーケンス

```
1. 設定読み込み
   └─ 環境変数からgithub_token、github_repositoryを取得
2. GitHub APIでリポジトリ検索
   └─ クエリ: topic:fastapi
   └─ ページサイズ: 100件
3. 結果フィルタリング
   └─ 自身のリポジトリ（fastapi/fastapi）を除外
   └─ 上位100件を取得
4. リポジトリ情報抽出
   └─ name, html_url, stars, owner_login, owner_html_urlを抽出
5. YAMLファイル更新判定
   └─ 既存ファイルと比較して変更があるか確認
6. ファイル更新（変更がある場合）
   └─ topic_repos.ymlを更新
7. Git操作・PR作成（変更がある場合）
   └─ 新規ブランチ作成、コミット、プッシュ、PR作成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[設定読み込み]
    B --> C[GitHub APIでトピック検索]
    C --> D[自身のリポジトリを除外]
    D --> E[上位100件を抽出]
    E --> F[リポジトリ情報抽出]
    F --> G[既存YAMLファイル読み込み]
    G --> H{データ変更あり?}
    H -->|あり| I[YAMLファイル更新]
    I --> J[新規ブランチ作成]
    J --> K[コミット・プッシュ]
    K --> L[PR作成]
    L --> M[バッチ終了]
    H -->|なし| M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。ファイルベースのデータ管理を行う。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| - | - | - | データベース操作なし |

### テーブル別操作詳細

該当なし（ファイルベース処理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | GitHub APIエラー | API認証失敗、レートリミット超過 | 例外発生、処理中断 |
| - | Git操作エラー | git操作失敗（subprocess.run check=True） | CalledProcessError発生、処理中断 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（PyGitHub内部のリトライに依存） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. ログを確認しエラー原因を特定
2. GitHub APIのレートリミット超過の場合は時間をおいて再実行
3. 認証エラーの場合はトークンの有効性を確認
4. ネットワークエラーの場合は接続状況を確認して再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 全体（ファイル更新後に一括コミット） |
| コミットタイミング | YAMLファイル更新完了後 |
| ロールバック条件 | Git操作前のエラーは自動ロールバック不要。PR作成失敗時はブランチ削除が必要 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 最大100件のリポジトリ |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 特に制限なし |

## 排他制御

同時実行不可。GitHub Actionsの設定でconcurrency制御を行う。同一ブランチ名のPRが既に存在する場合はエラーとなる可能性がある。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | バッチ開始時 | 設定情報（トークン除く） |
| 進捗ログ | 処理中 | ブランチ作成、ファイル追加、コミット、プッシュ、PR作成の各ステップ |
| 終了ログ | バッチ終了時 | 作成されたPR番号、または変更なしのメッセージ |
| エラーログ | エラー発生時 | エラー内容 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 処理時間 | 5分 | GitHub Actions |
| エラー件数 | 1件 | GitHub Actionsログ |

## 備考

- 検索クエリ: topic:fastapi
- ページサイズ: per_page=100
- 自身のリポジトリ（設定のgithub_repository）は除外される
- 出力されるフィールド: name, html_url, stars, owner_login, owner_html_url
- ブランチ名には secrets.token_hex(4) によるランダム文字列が付与される
- コミットメッセージ: "Update FastAPI GitHub topic repositories"
