---
generated_at: 2026-01-22 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-contributors.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュール詳細**：GitHub Actions設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/contributors.py` - メインソースコード
- E-02: `scripts/contributors.py:15-56` - GraphQLクエリ定義
- E-03: `scripts/contributors.py:59-117` - Pydanticモデル定義
- E-04: `scripts/contributors.py:115-118` - Settings定義
- E-05: `scripts/contributors.py:121-145` - GraphQL API呼び出し関数
- E-06: `scripts/contributors.py:175-204` - コントリビューター集計ロジック
- E-07: `scripts/contributors.py:207-223` - ユーザーフィルタリング処理
- E-08: `scripts/contributors.py:226-235` - YAMLファイル更新処理
- E-09: `scripts/contributors.py:238-312` - メイン処理・Git操作
- E-10: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHub GraphQL APIを使用してPRデータを収集 | E-02, E-05 | ○ |
| C-02 | コントリビューター・翻訳者・翻訳レビュアーを集計 | E-06 | ○ |
| C-03 | YAMLファイルを自動更新 | E-08, E-09 | ○ |
| C-04 | 環境変数GITHUB_TOKENが必要 | E-04 | ○ |
| C-05 | 環境変数GITHUB_REPOSITORYが必要 | E-04 | ○ |
| C-06 | httpx_timeoutのデフォルトは30秒 | E-04 | ○ |
| C-07 | PRのラベルlang-allで翻訳PRを判定 | E-06 (184-188行) | ○ |
| C-08 | マージ済みPRのみ集計対象 | E-06 (194行) | ○ |
| C-09 | 貢献回数2回以上でフィルタリング | E-07 (211行) | ○ |
| C-10 | contributors.ymlを出力 | E-09 (265行) | ○ |
| C-11 | translators.ymlを出力 | E-09 (267行) | ○ |
| C-12 | translation_reviewers.ymlを出力 | E-09 (269行) | ○ |
| C-13 | 100件ずつページネーション | E-02 (19行) | ○ |
| C-14 | データ変更時のみPR作成 | E-09 (280-282行) | ○ |
| C-15 | 新規ブランチ作成 | E-09 (290-292行) | ○ |
| C-16 | git config設定 | E-09 (285-289行) | ○ |
| C-17 | secrets.token_hex(4)でブランチ名生成 | E-09 (290行) | ○ |
| C-18 | HTTPエラー時RuntimeError発生 | E-05 (135-138行) | ○ |
| C-19 | GraphQLエラー時RuntimeError発生 | E-05 (140-144行) | ○ |
| C-20 | git操作はcheck=Trueで実行 | E-09 (285-308行) | ○ |
| C-21 | 出力ファイルパスはdocs/en/data/ | E-09 (265-269行) | ○ |
| C-22 | UTF-8エンコーディング使用 | E-08 (227, 233行) | ○ |
| C-23 | PR作成時のコミットメッセージ | E-09 (305行) | ○ |
| C-24 | PRのbaseブランチはmaster | E-09 (310行) | ○ |
| C-25 | 実行スケジュールは日次 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実行スケジュールの詳細はGitHub Actionsのワークフロー定義ファイルで確認が必要
  - 候補：.github/workflows/*.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく主張はほぼ全て根拠あり
- 1: 中リスク - 実行スケジュールはGitHub Actions設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actionsワークフロー定義で実行スケジュールを確認
- [ ] 本番環境での環境変数設定を確認
- [ ] 出力YAMLファイルの形式がドキュメントサイトの期待と一致するか確認
