---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：10-translation_fixer.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **check_translation関数の詳細**：doc_parsing_utils.pyの実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/translation_fixer.py` - メインソースコード
- E-02: `scripts/translation_fixer.py:8` - doc_parsing_utilsインポート
- E-03: `scripts/translation_fixer.py:10-19` - 翻訳対象外セクション定義
- E-04: `scripts/translation_fixer.py:30-52` - iter_all_lang_paths関数
- E-05: `scripts/translation_fixer.py:55-62` - get_all_paths関数
- E-06: `scripts/translation_fixer.py:65-98` - process_one_page関数
- E-07: `scripts/translation_fixer.py:101-112` - fix_allコマンド
- E-08: `scripts/translation_fixer.py:115-128` - fix_pagesコマンド
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | typerベースのCLIツール | E-01 (6行), E-07, E-08 | ○ |
| C-02 | fix-allコマンド提供 | E-07 | ○ |
| C-03 | fix-pagesコマンド提供 | E-08 | ○ |
| C-04 | language引数でfix-all実行 | E-07 (102行) | ○ |
| C-05 | doc_paths引数でfix-pages実行 | E-08 (116-119行) | ○ |
| C-06 | 翻訳対象外セクション定義 | E-03 | ○ |
| C-07 | referenceセクションは対象外 | E-03 (11行) | ○ |
| C-08 | 翻訳優先順位：learn/tutorial/advanced/about/how-to | E-04 (35-40行) | ○ |
| C-09 | 言語コードをパスから抽出 | E-06 (73行) | ○ |
| C-10 | 英語版はスキップ | E-06 (74-76行) | ○ |
| C-11 | 英語版パスを生成 | E-06 (78行) | ○ |
| C-12 | 翻訳版と英語版を読み込み | E-06 (80-81行) | ○ |
| C-13 | check_translation関数を使用 | E-06 (83-88行) | ○ |
| C-14 | auto_fix=Trueで自動修正 | E-06 (87行) | ○ |
| C-15 | 最終行に改行追加 | E-06 (92行) | ○ |
| C-16 | 修正結果をファイルに書き戻し | E-06 (93行) | ○ |
| C-17 | UTF-8エンコーディング使用 | E-06 (80, 81, 93行) | ○ |
| C-18 | ValueError時エラーログ出力 | E-06 (95-97行) | ○ |
| C-19 | 全ファイル失敗時Exit(1) | E-07 (111-112行), E-08 (127-128行) | ○ |
| C-20 | doc_parsing_utilsからcheck_translationインポート | E-02 | ○ |
| C-21 | 英語版パスはdocs/en/配下 | E-06 (78行) | ○ |
| C-22 | check_translation関数の詳細動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- check_translation関数の詳細はscripts/doc_parsing_utils.pyで確認が必要
  - 候補：scripts/doc_parsing_utils.py

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - translation_fixer.py自体のコード解析は完了
- 1: 中リスク - 依存モジュール（doc_parsing_utils）の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] doc_parsing_utils.pyのcheck_translation関数の動作を確認
- [ ] 自動修正の範囲と限界を確認
- [ ] 翻訳対象外セクションが運用要件と一致しているか確認
