---
generated_at: 2026-01-22 10:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：2-translate.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **OpenAI APIキー設定方法**：環境変数名の明示なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/translate.py` - メインソースコード
- E-02: `scripts/translate.py:17-26` - 翻訳対象外セクション定義
- E-03: `scripts/translate.py:28-30` - プロンプトファイルパス定義
- E-04: `scripts/translate.py:34-37` - 言語名取得関数
- E-05: `scripts/translate.py:59-127` - translate_page関数
- E-06: `scripts/translate.py:129-151` - ファイル列挙関数
- E-07: `scripts/translate.py:274-281` - remove_removable関数
- E-08: `scripts/translate.py:305-324` - list_outdated関数
- E-09: `scripts/translate.py:327-334` - update_outdated関数
- E-10: `scripts/translate.py:356-419` - make_pr関数
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LLM（OpenAI GPT-5.2）を使用して翻訳 | E-05 (88行) | ○ |
| C-02 | typerベースのCLIツール | E-01 (31行) | ○ |
| C-03 | LANGUAGE環境変数で言語指定 | E-05 (62行) | ○ |
| C-04 | llm-prompt.mdが必要 | E-05 (73行) | ○ |
| C-05 | language_names.ymlから言語名取得 | E-04 | ○ |
| C-06 | 英語は翻訳対象外 | E-05 (65-67行) | ○ |
| C-07 | referenceセクションは翻訳対象外 | E-02 | ○ |
| C-08 | release-notes.mdは翻訳対象外 | E-02 | ○ |
| C-09 | 出力文字コードはUTF-8 | E-05 (126行) | ○ |
| C-10 | 改行コードはLF | E-05 (126行) | ○ |
| C-11 | pydantic_aiのAgentを使用 | E-05 (88行) | ○ |
| C-12 | 既存翻訳がある場合は差分更新 | E-05 (94-112行) | ○ |
| C-13 | translate-pageコマンド提供 | E-01 (59行デコレータ) | ○ |
| C-14 | translate-langコマンド提供 | E-01 (161行デコレータ) | ○ |
| C-15 | update-outdatedコマンド提供 | E-01 (327行デコレータ) | ○ |
| C-16 | add-missingコマンド提供 | E-01 (337行デコレータ) | ○ |
| C-17 | remove-removableコマンド提供 | E-01 (274行デコレータ) | ○ |
| C-18 | make-prコマンド提供 | E-01 (356行デコレータ) | ○ |
| C-19 | Git履歴で翻訳の古さを判定 | E-08 | ○ |
| C-20 | 新規ブランチ作成 | E-10 (388-390行) | ○ |
| C-21 | secrets.token_hex(4)でブランチ名生成 | E-10 (388行) | ○ |
| C-22 | commit_in_placeオプション | E-10 (363-365行) | ○ |
| C-23 | learn/tutorial/advanced/about/how-toの優先順位 | E-06 (133-139行) | ○ |
| C-24 | general-llm-prompt.mdを使用 | E-03 | ○ |
| C-25 | 英語ドキュメントパスはdocs/en/docs/配下 | E-05 (76-79行) | ○ |
| C-26 | PRのbaseブランチはmaster | E-10 (416行) | ○ |
| C-27 | 翻訳非対応言語はtyper.Exit(1) | E-01 (218-219行) | ○ |
| C-28 | OpenAI APIキーの設定方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- OpenAI APIキーの環境変数名や設定方法はソースコードに明示されていない（pydantic_aiの内部処理に依存）
  - 候補：pydantic_aiドキュメント / 環境変数OPENAI_API_KEY

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく主張はほぼ全て根拠あり
- 1: 中リスク - LLM APIの設定はpydantic_aiに依存

## 6) レビュアーチェックリスト（最小）
- [ ] pydantic_aiのOpenAI API設定方法を確認
- [ ] 各言語のllm-prompt.mdが適切に設定されているか確認
- [ ] 翻訳対象外セクションが要件と一致しているか確認
