---
generated_at: 2026-01-22 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：3-sponsors.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュール詳細**：GitHub Actions設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/sponsors.py` - メインソースコード
- E-02: `scripts/sponsors.py:17-45` - GraphQLクエリ定義
- E-03: `scripts/sponsors.py:48-82` - Pydanticモデル定義
- E-04: `scripts/sponsors.py:85-89` - Settings定義
- E-05: `scripts/sponsors.py:92-116` - GraphQL API呼び出し関数
- E-06: `scripts/sponsors.py:119-144` - スポンサー集計ロジック
- E-07: `scripts/sponsors.py:147-156` - YAMLファイル更新処理
- E-08: `scripts/sponsors.py:159-218` - メイン処理・Git操作
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHub GraphQL APIを使用してスポンサー情報取得 | E-02, E-05 | ○ |
| C-02 | tiangolo氏へのスポンサーシップを対象 | E-02 (20行) | ○ |
| C-03 | SPONSORS_TOKEN環境変数が必要 | E-04 (86行) | ○ |
| C-04 | PR_TOKEN環境変数が必要 | E-04 (87行) | ○ |
| C-05 | GITHUB_REPOSITORY環境変数が必要 | E-04 (88行) | ○ |
| C-06 | httpx_timeoutのデフォルトは30秒 | E-04 (89行) | ○ |
| C-07 | 100件ずつページネーション | E-02 (21行) | ○ |
| C-08 | monthlyPriceInDollarsでグループ化 | E-06 (141行) | ○ |
| C-09 | 金額降順でソート | E-08 (167-168行) | ○ |
| C-10 | github_sponsors.ymlを出力 | E-08 (183行) | ○ |
| C-11 | 出力パスはdocs/en/data/ | E-08 (183行) | ○ |
| C-12 | UTF-8エンコーディング使用 | E-07 (148, 154行) | ○ |
| C-13 | データ変更時のみPR作成 | E-08 (188-190行) | ○ |
| C-14 | 新規ブランチ作成 | E-08 (198-200行) | ○ |
| C-15 | git config設定 | E-08 (193-197行) | ○ |
| C-16 | secrets.token_hex(4)でブランチ名生成 | E-08 (198行) | ○ |
| C-17 | HTTPエラー時RuntimeError発生 | E-05 (106-109行) | ○ |
| C-18 | GraphQLエラー時RuntimeError発生 | E-05 (111-115行) | ○ |
| C-19 | git操作はcheck=Trueで実行 | E-08 (193-214行) | ○ |
| C-20 | PRのbaseブランチはmaster | E-08 (216行) | ○ |
| C-21 | OrganizationとUser両方対応 | E-02 (24-34行) | ○ |
| C-22 | 実行スケジュールは日次または週次 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実行スケジュールの詳細はGitHub Actionsのワークフロー定義ファイルで確認が必要
  - 候補：.github/workflows/*.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく主張はほぼ全て根拠あり
- 1: 中リスク - 実行スケジュールはGitHub Actions設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actionsワークフロー定義で実行スケジュールを確認
- [ ] sponsors_tokenとpr_tokenの権限設定を確認
- [ ] スポンサー表示がドキュメントサイトで正しく動作するか確認
