---
generated_at: 2026-01-22 10:15:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：4-people.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュール詳細**：GitHub Actions設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/people.py` - メインソースコード
- E-02: `scripts/people.py:17-18` - カテゴリID定義
- E-03: `scripts/people.py:20-62` - GraphQLクエリ定義
- E-04: `scripts/people.py:65-117` - Pydanticモデル定義
- E-05: `scripts/people.py:119-124` - Settings定義
- E-06: `scripts/people.py:126-153` - GraphQL API呼び出し関数
- E-07: `scripts/people.py:180-193` - ディスカッションノード取得処理
- E-08: `scripts/people.py:196-256` - エキスパート集計ロジック
- E-09: `scripts/people.py:283-302` - ユーザー出力処理
- E-10: `scripts/people.py:317-400` - メイン処理・Git操作
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GitHub GraphQL APIを使用してディスカッション情報取得 | E-03, E-06 | ○ |
| C-02 | Questionsカテゴリを対象 | E-02 (18行) | ○ |
| C-03 | カテゴリID: MDE4OkRpc2N1c3Npb25DYXRlZ29yeTMyMDAxNDM0 | E-02 (18行) | ○ |
| C-04 | GITHUB_TOKEN環境変数が必要 | E-05 (120行) | ○ |
| C-05 | GITHUB_REPOSITORY環境変数が必要 | E-05 (121行) | ○ |
| C-06 | httpx_timeoutのデフォルトは30秒 | E-05 (122行) | ○ |
| C-07 | sleep_intervalのデフォルトは5秒 | E-05 (123行) | ○ |
| C-08 | 100件ずつページネーション | E-03 (23行) | ○ |
| C-09 | 1ヶ月/3ヶ月/6ヶ月/1年の期間別集計 | E-08 (206-210行) | ○ |
| C-10 | 質問者はエキスパート集計から除外 | E-08 (221, 231行) | ○ |
| C-11 | min_countのデフォルトは2 | E-09 (287行) | ○ |
| C-12 | 上位60名を抽出 | E-09 (291行) | ○ |
| C-13 | tiangolo氏をメンテナーとして管理 | E-10 (328行) | ○ |
| C-14 | people.ymlを出力 | E-10 (373行) | ○ |
| C-15 | 出力パスはdocs/en/data/ | E-10 (373行) | ○ |
| C-16 | UTF-8エンコーディング使用 | E-10 (306, 308行) | ○ |
| C-17 | データ変更時のみPR作成 | E-10 (377-379行) | ○ |
| C-18 | 新規ブランチ作成 | E-10 (387-389行) | ○ |
| C-19 | git config設定 | E-10 (382-386行) | ○ |
| C-20 | secrets.token_hex(4)でブランチ名生成 | E-10 (387行) | ○ |
| C-21 | HTTPエラー時RuntimeError発生 | E-06 (141-146行) | ○ |
| C-22 | GraphQLエラー時RuntimeError発生 | E-06 (148-152行) | ○ |
| C-23 | git操作はcheck=Trueで実行 | E-10 (382-397行) | ○ |
| C-24 | PRのbaseブランチはmaster | E-10 (398行) | ○ |
| C-25 | experts出力カテゴリ | E-10 (362-369行) | ○ |
| C-26 | レートリミット対策でスリープ | E-07 (189行) | ○ |
| C-27 | コメントと返信の両方を集計 | E-08 (218-237行) | ○ |
| C-28 | 実行スケジュールは日次 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実行スケジュールの詳細はGitHub Actionsのワークフロー定義ファイルで確認が必要
  - 候補：.github/workflows/*.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく主張はほぼ全て根拠あり
- 1: 中リスク - 処理時間が長いため、タイムアウト設定の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actionsワークフロー定義で実行スケジュールを確認
- [ ] GitHub Actionsのタイムアウト設定が十分か確認
- [ ] sleep_intervalの値がレートリミットを回避できるか確認
