---
generated_at: 2026-01-22 10:20:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-docs.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/docs.py` - メインソースコード
- E-02: `scripts/docs.py:22-30` - SUPPORTED_LANGS定義
- E-03: `scripts/docs.py:41-50` - non_translated_sections定義
- E-04: `scripts/docs.py:52-57` - パス定義
- E-05: `scripts/docs.py:121-137` - new_lang関数
- E-06: `scripts/docs.py:139-170` - build_lang関数
- E-07: `scripts/docs.py:202-230` - generate_readme_content関数
- E-08: `scripts/docs.py:233-246` - generate_readme関数
- E-09: `scripts/docs.py:249-266` - build_all関数
- E-10: `scripts/docs.py:269-284` - update_languages関数
- E-11: `scripts/docs.py:309-336` - live関数
- E-12: `scripts/docs.py:338-368` - get_updated_config_content関数
- E-13: `scripts/docs.py:443-500` - add_permalinks_page関数
- E-14: `scripts/docs.py:115-118` - callback関数（MacOS設定）
- E-15: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | typerベースのCLIツール | E-01 (33行) | ○ |
| C-02 | new-langコマンド提供 | E-05 | ○ |
| C-03 | build-langコマンド提供 | E-06 | ○ |
| C-04 | build-allコマンド提供 | E-09 | ○ |
| C-05 | update-languagesコマンド提供 | E-10 | ○ |
| C-06 | generate-readmeコマンド提供 | E-08 | ○ |
| C-07 | add-permalinksコマンド提供 | E-13 | ○ |
| C-08 | serve/liveコマンド提供 | E-11 | ○ |
| C-09 | サポート言語: en, de, es, ko, pt, ru, uk | E-02 | ○ |
| C-10 | 翻訳禁止セクション: reference等 | E-03 | ○ |
| C-11 | language_names.ymlを参照 | E-12 (344行) | ○ |
| C-12 | 並列処理でCPU数×4のプロセス使用 | E-09 (262-264行) | ○ |
| C-13 | site/ディレクトリにビルド出力 | E-04 (55-56行) | ○ |
| C-14 | mkdocs buildで静的サイト生成 | E-06 (167行) | ○ |
| C-15 | python-slugifyでパーマリンク生成 | E-01 (18行), E-13 | ○ |
| C-16 | 既存言語作成時typer.Abort | E-05 (128-129行) | ○ |
| C-17 | 存在しない言語ビルド時typer.Abort | E-06 (150-151行) | ○ |
| C-18 | README.md最新でない場合Exit(1) | E-08 (244-245行) | ○ |
| C-19 | mkdocs.yml最新でない場合Exit(1) | E-10 (282-283行) | ○ |
| C-20 | sponsors.ymlをREADME生成に使用 | E-07 (209-210行) | ○ |
| C-21 | new-langでmkdocs.yml作成 | E-05 (132行) | ○ |
| C-22 | new-langでllm-prompt.md作成 | E-05 (133-134行) | ○ |
| C-23 | new-langでupdate-languages呼び出し | E-05 (136行) | ○ |
| C-24 | MacOS向けDYLD設定 | E-14 (118行) | ○ |
| C-25 | liveでLINENUMS=true設定 | E-11 (334行) | ○ |
| C-26 | ダーティビルドオプション | E-11 (314行) | ○ |
| C-27 | 翻訳禁止セクションにファイル存在時Exit(1) | E-01 (394行) | ○ |
| C-28 | スポンサーセクション不在時RuntimeError | E-07 (211-214行) | ○ |
| C-29 | alternate設定更新 | E-12 (367行) | ○ |
| C-30 | UTF-8エンコーディング使用 | E-07 (204行), E-08 (239行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいて検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] mkdocsおよび依存パッケージのバージョンが本番環境と一致するか確認
- [ ] SUPPORTED_LANGSが最新の言語リストと一致するか確認
- [ ] 並列処理数がCI/CD環境のリソースに適切か確認
