---
generated_at: 2026-01-22 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：6-label_approved.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **実行トリガー詳細**：GitHub Actions設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/label_approved.py` - メインソースコード
- E-02: `scripts/label_approved.py:10-15` - LabelSettings定義とdefault_config
- E-03: `scripts/label_approved.py:18-23` - Settings定義
- E-04: `scripts/label_approved.py:25-32` - 初期化処理
- E-05: `scripts/label_approved.py:33-60` - メイン処理ループ
- E-06: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PyGitHubライブラリを使用 | E-01 (4-5行) | ○ |
| C-02 | TOKEN環境変数が必要 | E-03 (20行) | ○ |
| C-03 | GITHUB_REPOSITORY環境変数が必要 | E-03 (19行) | ○ |
| C-04 | debug環境変数でデバッグ有効化 | E-03 (21行) | ○ |
| C-05 | config環境変数でラベル設定カスタマイズ | E-03 (22行) | ○ |
| C-06 | デフォルトでapproved-2ラベル | E-02 (15行) | ○ |
| C-07 | デフォルトで2件以上の承認が必要 | E-02 (15行) | ○ |
| C-08 | デフォルトでawaiting-reviewが待機ラベル | E-02 (15行) | ○ |
| C-09 | オープンPRを取得 | E-05 (33行) | ○ |
| C-10 | PRラベル一覧を取得 | E-05 (35-36行) | ○ |
| C-11 | PRレビュー一覧を取得 | E-05 (37行) | ○ |
| C-12 | ユーザー別最新レビュー判定 | E-05 (38-45行) | ○ |
| C-13 | APPROVEDレビューのみカウント | E-05 (46-48行) | ○ |
| C-14 | 承認数が閾値以上でラベル付与 | E-05 (54-56行) | ○ |
| C-15 | 待機ラベルがあれば削除 | E-05 (57-59行) | ○ |
| C-16 | 待機ラベルがないPRはスキップ | E-05 (52行) | ○ |
| C-17 | submitted_atで最新レビュー判定 | E-05 (42行) | ○ |
| C-18 | debug=Trueでデバッグログ出力 | E-04 (26-30行) | ○ |
| C-19 | "Finished"メッセージで終了 | E-05 (60行) | ○ |
| C-20 | レビューイベントでトリガー実行 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実行トリガーの詳細はGitHub Actionsのワークフロー定義ファイルで確認が必要
  - 候補：.github/workflows/*.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく主張はほぼ全て根拠あり
- 1: 中リスク - GitHub Actions設定に依存する部分がある

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actionsワークフロー定義で実行トリガーを確認
- [ ] トークンにPRラベル編集権限があるか確認
- [ ] default_configが運用要件と一致しているか確認
