---
generated_at: 2026-01-22 10:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-deploy_docs_status.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、特に優先レビュー項目なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/deploy_docs_status.py` - メインソースコード
- E-02: `scripts/deploy_docs_status.py:10-16` - Settings定義
- E-03: `scripts/deploy_docs_status.py:19-23` - LinkDataモデル定義
- E-04: `scripts/deploy_docs_status.py:25-49` - pending/error処理
- E-05: `scripts/deploy_docs_status.py:50-75` - success処理（ステータス設定）
- E-06: `scripts/deploy_docs_status.py:77-117` - プレビューリンク生成
- E-07: `scripts/deploy_docs_status.py:119-143` - コメント生成・投稿
- E-08: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PyGitHubライブラリを使用 | E-01 (5行) | ○ |
| C-02 | GITHUB_TOKEN環境変数が必要 | E-02 (12行) | ○ |
| C-03 | GITHUB_REPOSITORY環境変数が必要 | E-02 (11行) | ○ |
| C-04 | COMMIT_SHA環境変数が必要 | E-02 (14行) | ○ |
| C-05 | RUN_ID環境変数が必要 | E-02 (15行) | ○ |
| C-06 | STATE環境変数が必要 | E-02 (16行) | ○ |
| C-07 | DEPLOY_URL環境変数（オプション） | E-02 (13行) | ○ |
| C-08 | stateはpending/success/errorの3値 | E-02 (16行) | ○ |
| C-09 | コミットSHAからPR検索 | E-04 (32-34行) | ○ |
| C-10 | PRがない場合エラーログ出力 | E-04 (35-37行) | ○ |
| C-11 | pending時"Deploying Docs"ステータス | E-04 (41-47行) | ○ |
| C-12 | error時"Error Deploying Docs"ステータス | E-04 (50-58行) | ○ |
| C-13 | success+URL無し時"No Docs Changes" | E-05 (60-68行) | ○ |
| C-14 | success+URL有り時"Docs Deployed" | E-05 (70-75行) | ○ |
| C-15 | docs/配下の変更ファイルを抽出 | E-06 (77-78行) | ○ |
| C-16 | 言語別にプレビューリンク生成 | E-06 (81-103行) | ○ |
| C-17 | 英語版リンクは/path/ | E-06 (93-94行) | ○ |
| C-18 | 他言語リンクは/{lang}/path/ | E-06 (95-96行) | ○ |
| C-19 | コメントヘッダー"## Docs preview" | E-07 (119行) | ○ |
| C-20 | 既存コメント更新処理 | E-07 (134-141行) | ○ |
| C-21 | github-actions[bot]でコメント判定 | E-07 (137-138行) | ○ |
| C-22 | 新規コメント作成処理 | E-07 (143行) | ○ |
| C-23 | コンテキスト名"deploy-docs" | E-04 (45行) | ○ |
| C-24 | 本番サイトへのリンク（before）を提供 | E-07 (127行) | ○ |

## 4) 不足情報（Unknown / Missing）
- 全ての主張に根拠があるため、不足情報なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに基づいて検証済み

## 6) レビュアーチェックリスト（最小）
- [ ] デプロイジョブでのバッチ呼び出しパラメータが正しいか確認
- [ ] DEPLOY_URLの形式がプレビューリンク生成と整合しているか確認
- [ ] トークンにステータス設定・コメント作成権限があるか確認
