---
generated_at: 2026-01-22 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：9-topic_repos.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **実行スケジュール詳細**：GitHub Actions設定ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `scripts/topic_repos.py` - メインソースコード
- E-02: `scripts/topic_repos.py:12-15` - Settings定義
- E-03: `scripts/topic_repos.py:18-23` - Repoモデル定義
- E-04: `scripts/topic_repos.py:25-77` - メイン処理関数
- E-05: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PyGitHubライブラリを使用 | E-01 (7行) | ○ |
| C-02 | GITHUB_TOKEN環境変数が必要 | E-02 (14行) | ○ |
| C-03 | GITHUB_REPOSITORY環境変数が必要 | E-02 (13行) | ○ |
| C-04 | 検索クエリ: topic:fastapi | E-04 (32行) | ○ |
| C-05 | ページサイズ: per_page=100 | E-04 (30行) | ○ |
| C-06 | 自身のリポジトリを除外 | E-04 (35-36行) | ○ |
| C-07 | 上位100件を取得 | E-04 (35行) | ○ |
| C-08 | name, html_url, starsを抽出 | E-04 (38-41行) | ○ |
| C-09 | owner_login, owner_html_urlを抽出 | E-04 (42-43行) | ○ |
| C-10 | topic_repos.ymlを出力 | E-04 (51行) | ○ |
| C-11 | 出力パスはdocs/en/data/ | E-04 (51行) | ○ |
| C-12 | UTF-8エンコーディング使用 | E-04 (52, 57行) | ○ |
| C-13 | データ変更時のみPR作成 | E-04 (54-56行) | ○ |
| C-14 | 新規ブランチ作成 | E-04 (64-66行) | ○ |
| C-15 | git config設定 | E-04 (58-62行) | ○ |
| C-16 | secrets.token_hex(4)でブランチ名生成 | E-04 (64行) | ○ |
| C-17 | git操作はcheck=Trueで実行 | E-04 (59-73行) | ○ |
| C-18 | PRのbaseブランチはmaster | E-04 (75行) | ○ |
| C-19 | コミットメッセージ | E-04 (70行) | ○ |
| C-20 | 実行スケジュールは日次または週次 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 実行スケジュールの詳細はGitHub Actionsのワークフロー定義ファイルで確認が必要
  - 候補：.github/workflows/*.yml

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく主張はほぼ全て根拠あり
- 1: 中リスク - 実行スケジュールはGitHub Actions設定に依存

## 6) レビュアーチェックリスト（最小）
- [ ] GitHub Actionsワークフロー定義で実行スケジュールを確認
- [ ] 検索結果の並び順がGitHubのデフォルト（スター数順など）と一致するか確認
- [ ] 100件制限が運用要件と一致しているか確認
