---
generated_at: 2026-01-22 22:25:00
metrics:
  claims_total: 151
  claims_with_evidence: 151
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：dependencies モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の対応するメソッド・関数が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要な関数・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：151 / 151、根拠なし：0
- 優先レビュー（高）
  1. **solve_dependencies関連（UT-DEP-099〜111）**：依存性解決のコア機能、複雑なロジック
  2. **analyze_param関連（UT-DEP-078〜090）**：パラメータ解析の多岐にわたるパターン
  3. **Dependantクラスのcached_property（UT-DEP-007〜040）**：キャッシュ動作と状態判定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/dependencies/__init__.py` - モジュール初期化ファイル（空）
- E-02: `fastapi/dependencies/models.py` - Dependantデータクラスとヘルパー関数
- E-03: `fastapi/dependencies/utils.py` - 依存性注入ユーティリティ関数群
- E-04: `docs/code-to-docs/単体テストケース一覧/plan.md` - テスト計画書

## 3) Claims と根拠の対応（レビューの主戦場）

### models.py - ヘルパー関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-DEP-001) | _unwrapped_call: Noneが渡された場合Noneを返す | E-02: L18-22 `if call is None: return call` | ○ |
| C-02 (UT-DEP-002) | _unwrapped_call: 通常の関数がアンラップされる | E-02: L21 `inspect.unwrap(_impartial(call))` | ○ |
| C-03 (UT-DEP-003) | _unwrapped_call: partial関数がアンラップされる | E-02: L21 `_impartial(call)` でpartial展開 | ○ |
| C-04 (UT-DEP-004) | _impartial: partial関数から元の関数を取得 | E-02: L25-28 `while isinstance(func, partial): func = func.func` | ○ |
| C-05 (UT-DEP-005) | _impartial: ネストしたpartialを再帰的にアンラップ | E-02: L26-27 whileループで再帰的に展開 | ○ |
| C-06 (UT-DEP-006) | _impartial: 通常の関数はそのまま返却 | E-02: L28 `return func` | ○ |

### models.py - Dependantクラス

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 (UT-DEP-007) | oauth_scopes: 親と自身のスコープがマージされる | E-02: L54-60 `scopes = self.parent_oauth_scopes.copy()...for scope in self.own_oauth_scopes` | ○ |
| C-08 (UT-DEP-008) | oauth_scopes: 重複するスコープが除去される | E-02: L58 `if scope not in scopes: scopes.append(scope)` | ○ |
| C-09 (UT-DEP-009) | oauth_scopes: 両方Noneの場合空リストを返す | E-02: L55 `scopes = self.parent_oauth_scopes.copy() if self.parent_oauth_scopes else []` | ○ |
| C-10 (UT-DEP-010) | cache_key: キャッシュキーが正しく生成される | E-02: L63-71 `(self.call, scopes_for_cache, self.computed_scope)` | ○ |
| C-11 (UT-DEP-011) | cache_key: スコープ未使用時は空タプル | E-02: L64-66 `() if not self._uses_scopes else tuple(...)` | ○ |
| C-12 (UT-DEP-012) | _uses_scopes: own_oauth_scopes設定時True | E-02: L75-76 `if self.own_oauth_scopes: return True` | ○ |
| C-13 (UT-DEP-013) | _uses_scopes: security_scopes_param_name設定時True | E-02: L77-78 `if self.security_scopes_param_name is not None: return True` | ○ |
| C-14 (UT-DEP-014) | _uses_scopes: セキュリティスキームの場合True | E-02: L79-80 `if self._is_security_scheme: return True` | ○ |
| C-15 (UT-DEP-015) | _uses_scopes: サブ依存性がスコープ使用時True | E-02: L81-83 `for sub_dep in self.dependencies: if sub_dep._uses_scopes: return True` | ○ |
| C-16 (UT-DEP-016) | _uses_scopes: スコープ未使用の場合False | E-02: L84 `return False` | ○ |
| C-17 (UT-DEP-017) | _is_security_scheme: SecurityBase時True | E-02: L90-91 `isinstance(unwrapped, SecurityBase)` | ○ |
| C-18 (UT-DEP-018) | _is_security_scheme: 通常関数時False | E-02: L90-91 `isinstance`チェックで非該当 | ○ |
| C-19 (UT-DEP-019) | _is_security_scheme: callがNone時False | E-02: L88-89 `if self.call is None: return False` | ○ |
| C-20 (UT-DEP-020) | _security_scheme: SecurityBaseインスタンス返却 | E-02: L96-98 `return unwrapped` (SecurityBaseにキャスト) | ○ |
| C-21 (UT-DEP-021) | _security_dependencies: セキュリティ依存性のみフィルタ | E-02: L101-103 `[dep for dep in self.dependencies if dep._is_security_scheme]` | ○ |
| C-22 (UT-DEP-022) | _security_dependencies: セキュリティ依存性なしで空リスト | E-02: L102 リスト内包表記で空になる | ○ |
| C-23 (UT-DEP-023) | is_gen_callable: ジェネレータ関数時True | E-02: L109-112 `inspect.isgeneratorfunction` | ○ |
| C-24 (UT-DEP-024) | is_gen_callable: __call__がジェネレータ時True | E-02: L118-121 `dunder_call`のジェネレータチェック | ○ |
| C-25 (UT-DEP-025) | is_gen_callable: 通常関数時False | E-02: L129 `return False` | ○ |
| C-26 (UT-DEP-026) | is_gen_callable: callがNone時False | E-02: L107-108 `if self.call is None: return False` | ○ |
| C-27 (UT-DEP-027) | is_gen_callable: クラス時False | E-02: L113-114 `if inspect.isclass: return False` | ○ |
| C-28 (UT-DEP-028) | is_async_gen_callable: 非同期ジェネレータ時True | E-02: L135-137 `inspect.isasyncgenfunction` | ○ |
| C-29 (UT-DEP-029) | is_async_gen_callable: __call__が非同期ジェネレータ時True | E-02: L144-147 `dunder_call`の非同期ジェネレータチェック | ○ |
| C-30 (UT-DEP-030) | is_async_gen_callable: 通常関数時False | E-02: L155 `return False` | ○ |
| C-31 (UT-DEP-031) | is_async_gen_callable: callがNone時False | E-02: L133-134 `if self.call is None: return False` | ○ |
| C-32 (UT-DEP-032) | is_coroutine_callable: コルーチン関数時True | E-02: L161-164 `iscoroutinefunction` | ○ |
| C-33 (UT-DEP-033) | is_coroutine_callable: __call__がコルーチン時True | E-02: L174-177 `dunder_call`のコルーチンチェック | ○ |
| C-34 (UT-DEP-034) | is_coroutine_callable: 同期関数時False | E-02: L185 `return False` | ○ |
| C-35 (UT-DEP-035) | is_coroutine_callable: callがNone時False | E-02: L159-160 `if self.call is None: return False` | ○ |
| C-36 (UT-DEP-036) | is_coroutine_callable: クラス時False | E-02: L169-170 `if inspect.isclass: return False` | ○ |
| C-37 (UT-DEP-037) | computed_scope: scope設定時そのまま返す | E-02: L189-190 `if self.scope: return self.scope` | ○ |
| C-38 (UT-DEP-038) | computed_scope: ジェネレータで'request'返す | E-02: L191-192 `if self.is_gen_callable: return "request"` | ○ |
| C-39 (UT-DEP-039) | computed_scope: 非同期ジェネレータで'request'返す | E-02: L191-192 `or self.is_async_gen_callable: return "request"` | ○ |
| C-40 (UT-DEP-040) | computed_scope: 通常関数でNone返す | E-02: L193 `return None` | ○ |

### utils.py - multipartチェック

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-41 (UT-DEP-041) | ensure_multipart_is_installed: 正常時エラーなし | E-03: L85-109 try/except構造で正常時は何も起きない | ○ |
| C-42 (UT-DEP-042) | ensure_multipart_is_installed: 未インストール時RuntimeError | E-03: L107-109 `raise RuntimeError(multipart_not_installed_error)` | ○ |
| C-43 (UT-DEP-043) | ensure_multipart_is_installed: 誤インストール時RuntimeError | E-03: L104-106 `raise RuntimeError(multipart_incorrect_install_error)` | ○ |

### utils.py - Dependant生成関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 (UT-DEP-044) | get_parameterless_sub_dependant: Dependant生成 | E-03: L112-124 `return get_dependant(...)` | ○ |
| C-45 (UT-DEP-045) | get_parameterless_sub_dependant: Securityスコープ設定 | E-03: L117-118 `if isinstance(depends, params.Security): own_oauth_scopes.extend` | ○ |
| C-46 (UT-DEP-046) | get_parameterless_sub_dependant: 非callable時AssertionError | E-03: L113-115 `assert callable(depends.dependency)` | ○ |
| C-47 (UT-DEP-047) | get_flat_dependant: 依存性ツリーのフラット化 | E-03: L127-178 再帰的にサブ依存性を処理 | ○ |
| C-48 (UT-DEP-048) | get_flat_dependant: skip_repeats=Trueで重複スキップ | E-03: L162-163 `if skip_repeats and sub_dependant.cache_key in visited: continue` | ○ |
| C-49 (UT-DEP-049) | get_flat_dependant: OAuthスコープ継承 | E-03: L137-139, L168 `parent_oauth_scopes`の伝播 | ○ |
| C-50 (UT-DEP-050) | get_flat_dependant: 依存性なしでそのまま返す | E-03: L161 forループで依存性がなければスキップ | ○ |
| C-51 (UT-DEP-051) | _get_flat_fields_from_params: BaseModel展開 | E-03: L185-187 `get_cached_model_fields(first_field.type_)` | ○ |
| C-52 (UT-DEP-052) | _get_flat_fields_from_params: 複数フィールドそのまま | E-03: L188 `return fields` | ○ |
| C-53 (UT-DEP-053) | _get_flat_fields_from_params: 空リストで空返却 | E-03: L182-183 `if not fields: return fields` | ○ |
| C-54 (UT-DEP-054) | get_flat_params: 全パラメータフラット化 | E-03: L191-197 path/query/header/cookieを結合 | ○ |

### utils.py - シグネチャ解析

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 (UT-DEP-055) | _get_signature: シグネチャ取得 | E-03: L200-210 `inspect.signature(call)` | ○ |
| C-56 (UT-DEP-056) | _get_signature: Python 3.10+でeval_str=True | E-03: L201-203 `if sys.version_info >= (3, 10): signature = inspect.signature(call, eval_str=True)` | ○ |
| C-57 (UT-DEP-057) | get_typed_signature: 型付きシグネチャ取得 | E-03: L213-227 パラメータの型解決 | ○ |
| C-58 (UT-DEP-058) | get_typed_signature: ForwardRef解決 | E-03: L222 `get_typed_annotation` 呼び出し | ○ |
| C-59 (UT-DEP-059) | get_typed_annotation: 文字列をForwardRefに変換 | E-03: L231-233 `ForwardRef(annotation)` | ○ |
| C-60 (UT-DEP-060) | get_typed_annotation: type(None)でNone返却 | E-03: L234-235 `if annotation is type(None): return None` | ○ |
| C-61 (UT-DEP-061) | get_typed_annotation: 通常型はそのまま | E-03: L236 `return annotation` | ○ |
| C-62 (UT-DEP-062) | get_typed_return_annotation: 戻り値型取得 | E-03: L239-248 | ○ |
| C-63 (UT-DEP-063) | get_typed_return_annotation: 未定義でNone | E-03: L244-245 `if annotation is inspect.Signature.empty: return None` | ○ |

### utils.py - get_dependant

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 (UT-DEP-064) | get_dependant: Dependant生成 | E-03: L251-323 | ○ |
| C-65 (UT-DEP-065) | get_dependant: パスパラメータ検出 | E-03: L271, L275 `path_param_names`, `is_path_param` | ○ |
| C-66 (UT-DEP-066) | get_dependant: クエリパラメータ検出 | E-03: L322 `add_param_to_fields` でquery追加 | ○ |
| C-67 (UT-DEP-067) | get_dependant: Depends検出 | E-03: L282-308 `if param_details.depends is not None` | ○ |
| C-68 (UT-DEP-068) | get_dependant: スコープ違反検出 | E-03: L284-293 `raise DependencyScopeError` | ○ |
| C-69 (UT-DEP-069) | get_dependant: Securityスコープ伝播 | E-03: L294-306 `sub_own_oauth_scopes` | ○ |

### utils.py - add_non_field_param_to_dependency

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-70 (UT-DEP-070) | add_non_field_param_to_dependency: Request検出 | E-03: L329-331 `lenient_issubclass(type_annotation, Request)` | ○ |
| C-71 (UT-DEP-071) | add_non_field_param_to_dependency: WebSocket検出 | E-03: L332-334 `lenient_issubclass(type_annotation, WebSocket)` | ○ |
| C-72 (UT-DEP-072) | add_non_field_param_to_dependency: Response検出 | E-03: L338-340 | ○ |
| C-73 (UT-DEP-073) | add_non_field_param_to_dependency: BackgroundTasks検出 | E-03: L341-343 | ○ |
| C-74 (UT-DEP-074) | add_non_field_param_to_dependency: SecurityScopes検出 | E-03: L344-346 | ○ |
| C-75 (UT-DEP-075) | add_non_field_param_to_dependency: HTTPConnection検出 | E-03: L335-337 | ○ |
| C-76 (UT-DEP-076) | add_non_field_param_to_dependency: 非特殊型でNone | E-03: L347 `return None` | ○ |

### utils.py - analyze_param

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-77 (UT-DEP-077) | ParamDetails: データクラス初期化 | E-03: L350-354 `@dataclass class ParamDetails` | ○ |
| C-78 (UT-DEP-078) | analyze_param: AnnotatedからFieldInfo抽出 | E-03: L372-415 Annotated解析ロジック | ○ |
| C-79 (UT-DEP-079) | analyze_param: AnnotatedからDepends抽出 | E-03: L417-418 `elif isinstance(fastapi_annotation, params.Depends)` | ○ |
| C-80 (UT-DEP-080) | analyze_param: デフォルト値からDepends抽出 | E-03: L420-429 `if isinstance(value, params.Depends)` | ○ |
| C-81 (UT-DEP-081) | analyze_param: デフォルト値からFieldInfo抽出 | E-03: L431-438 `elif isinstance(value, FieldInfo)` | ○ |
| C-82 (UT-DEP-082) | analyze_param: Depends重複エラー | E-03: L421-424 `assert depends is None` | ○ |
| C-83 (UT-DEP-083) | analyze_param: FieldInfo重複エラー | E-03: L432-435 `assert field_info is None` | ○ |
| C-84 (UT-DEP-084) | analyze_param: パスパラメータ自動設定 | E-03: L465-469 `field_info = params.Path` | ○ |
| C-85 (UT-DEP-085) | analyze_param: UploadFile自動設定 | E-03: L470-473 `field_info = params.File` | ○ |
| C-86 (UT-DEP-086) | analyze_param: Body自動設定 | E-03: L474-475 `field_info = params.Body` | ○ |
| C-87 (UT-DEP-087) | analyze_param: Query自動設定 | E-03: L476-477 `field_info = params.Query` | ○ |
| C-88 (UT-DEP-088) | analyze_param: multipart確認 | E-03: L494-495 `ensure_multipart_is_installed()` | ○ |
| C-89 (UT-DEP-089) | analyze_param: アンダースコア変換 | E-03: L496-498 `alias = param_name.replace("_", "-")` | ○ |
| C-90 (UT-DEP-090) | analyze_param: パスパラメータ型エラー | E-03: L483-487 `assert isinstance(field_info, params.Path)` | ○ |

### utils.py - add_param_to_fields

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 (UT-DEP-091) | add_param_to_fields: path追加 | E-03: L530-531 | ○ |
| C-92 (UT-DEP-092) | add_param_to_fields: query追加 | E-03: L532-533 | ○ |
| C-93 (UT-DEP-093) | add_param_to_fields: header追加 | E-03: L534-535 | ○ |
| C-94 (UT-DEP-094) | add_param_to_fields: cookie追加 | E-03: L536-540 | ○ |
| C-95 (UT-DEP-095) | add_param_to_fields: 不正in_エラー | E-03: L537-538 `assert field_info_in == params.ParamTypes.cookie` | ○ |

### utils.py - solve関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 (UT-DEP-096) | _solve_generator: 非同期ジェネレータ解決 | E-03: L547-548 `asynccontextmanager(dependant.call)` | ○ |
| C-97 (UT-DEP-097) | _solve_generator: 同期ジェネレータ解決 | E-03: L549-550 `contextmanager_in_threadpool` | ○ |
| C-98 (UT-DEP-098) | SolvedDependency: データクラス初期化 | E-03: L554-560 `@dataclass class SolvedDependency` | ○ |
| C-99 (UT-DEP-099) | solve_dependencies: 依存性解決 | E-03: L563-700 | ○ |
| C-100 (UT-DEP-100) | solve_dependencies: キャッシュ使用 | E-03: L629-630 `if sub_dependant.use_cache and sub_dependant.cache_key in dependency_cache` | ○ |
| C-101 (UT-DEP-101) | solve_dependencies: オーバーライド適用 | E-03: L597-612 `dependency_overrides` | ○ |
| C-102 (UT-DEP-102) | solve_dependencies: パスパラメータ解決 | E-03: L650-652 `request_params_to_args(dependant.path_params, ...)` | ○ |
| C-103 (UT-DEP-103) | solve_dependencies: クエリパラメータ解決 | E-03: L653-655 | ○ |
| C-104 (UT-DEP-104) | solve_dependencies: ヘッダーパラメータ解決 | E-03: L656-658 | ○ |
| C-105 (UT-DEP-105) | solve_dependencies: クッキーパラメータ解決 | E-03: L659-661 | ○ |
| C-106 (UT-DEP-106) | solve_dependencies: ボディパラメータ解決 | E-03: L667-677 `request_body_to_args` | ○ |
| C-107 (UT-DEP-107) | solve_dependencies: BackgroundTasks注入 | E-03: L684-687 | ○ |
| C-108 (UT-DEP-108) | solve_dependencies: Response注入 | E-03: L688-689 | ○ |
| C-109 (UT-DEP-109) | solve_dependencies: SecurityScopes注入 | E-03: L690-693 | ○ |
| C-110 (UT-DEP-110) | solve_dependencies: functionスコープ処理 | E-03: L634-636 `if sub_dependant.scope == "function": use_astack = function_astack` | ○ |
| C-111 (UT-DEP-111) | solve_dependencies: astack検証 | E-03: L577-584 `assert isinstance(request_astack, AsyncExitStack)` | ○ |

### utils.py - バリデーション関数

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-112 (UT-DEP-112) | _validate_value_with_model_field: 値検証成功 | E-03: L711 `v_, errors_ = field.validate(...)` | ○ |
| C-113 (UT-DEP-113) | _validate_value_with_model_field: 必須フィールド欠落 | E-03: L707-708 `if field.required: return None, [get_missing_field_error(loc=loc)]` | ○ |
| C-114 (UT-DEP-114) | _validate_value_with_model_field: オプショナルデフォルト | E-03: L709-710 `return deepcopy(field.default), []` | ○ |
| C-115 (UT-DEP-115) | _validate_value_with_model_field: 検証エラー | E-03: L712-714 `if isinstance(errors_, list)` | ○ |
| C-116 (UT-DEP-116) | _get_multidict_value: 通常値取得 | E-03: L726 `value = values.get(alias, None)` | ○ |
| C-117 (UT-DEP-117) | _get_multidict_value: マルチ値取得 | E-03: L723-724 `value = values.getlist(alias)` | ○ |
| C-118 (UT-DEP-118) | _get_multidict_value: 必須フィールド欠落 | E-03: L736-737 `if field.required: return` | ○ |
| C-119 (UT-DEP-119) | _get_multidict_value: オプショナルデフォルト | E-03: L738-739 `return deepcopy(field.default)` | ○ |
| C-120 (UT-DEP-120) | _get_multidict_value: Form空文字列処理 | E-03: L730-733 `isinstance(field.field_info, params.Form) and value == ""` | ○ |

### utils.py - request_params_to_args

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 (UT-DEP-121) | request_params_to_args: パラメータ変換 | E-03: L743-823 | ○ |
| C-122 (UT-DEP-122) | request_params_to_args: BaseModelパラメータ検証 | E-03: L757-758 `get_cached_model_fields(first_field.type_)` | ○ |
| C-123 (UT-DEP-123) | request_params_to_args: Headerアンダースコア変換 | E-03: L772-781 `convert_underscores`, `alias.replace("_", "-")` | ○ |
| C-124 (UT-DEP-124) | request_params_to_args: 空フィールド処理 | E-03: L750-751 `if not fields: return values, errors` | ○ |
| C-125 (UT-DEP-125) | request_params_to_args: パラメータ検証エラー | E-03: L819-820 `errors.extend(errors_)` | ○ |

### utils.py - ボディ関連

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 (UT-DEP-126) | is_union_of_base_models: Union BaseModel判定 | E-03: L826-842 | ○ |
| C-127 (UT-DEP-127) | is_union_of_base_models: 混合Union判定 | E-03: L838-840 `if not lenient_issubclass(arg, BaseModel): return False` | ○ |
| C-128 (UT-DEP-128) | is_union_of_base_models: 非Union判定 | E-03: L833-834 `if origin is not Union and origin is not UnionType: return False` | ○ |
| C-129 (UT-DEP-129) | _should_embed_body_fields: 複数ボディフィールド | E-03: L852-853 `if len(body_param_names_set) > 1: return True` | ○ |
| C-130 (UT-DEP-130) | _should_embed_body_fields: 明示的embed | E-03: L856-857 `if getattr(first_field.field_info, "embed", None): return True` | ○ |
| C-131 (UT-DEP-131) | _should_embed_body_fields: Form非BaseModel | E-03: L860-865 | ○ |
| C-132 (UT-DEP-132) | _should_embed_body_fields: 単一BaseModel | E-03: L866 `return False` | ○ |
| C-133 (UT-DEP-133) | _should_embed_body_fields: 空フィールド | E-03: L846-847 `if not fields: return False` | ○ |
| C-134 (UT-DEP-134) | _extract_form_body: FormData抽出 | E-03: L869-913 | ○ |
| C-135 (UT-DEP-135) | _extract_form_body: UploadFile bytes変換 | E-03: L878-883 `value = await value.read()` | ○ |
| C-136 (UT-DEP-136) | _extract_form_body: 複数UploadFile並列読込 | E-03: L899-902 `anyio.create_task_group` | ○ |
| C-137 (UT-DEP-137) | _extract_form_body: 未定義キー抽出 | E-03: L906-912 | ○ |
| C-138 (UT-DEP-138) | request_body_to_args: ボディ変換 | E-03: L916-963 | ○ |
| C-139 (UT-DEP-139) | request_body_to_args: 非埋め込みボディ検証 | E-03: L940-945 `single_not_embedded_field` | ○ |
| C-140 (UT-DEP-140) | request_body_to_args: FormDataボディ処理 | E-03: L937-938 `_extract_form_body` | ○ |
| C-141 (UT-DEP-141) | request_body_to_args: リストボディエラー | E-03: L953-954 `except AttributeError: errors.append(get_missing_field_error(loc))` | ○ |
| C-142 (UT-DEP-142) | request_body_to_args: 空ボディフィールドエラー | E-03: L923 `assert body_fields` | ○ |

### utils.py - get_body_field

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 (UT-DEP-143) | get_body_field: ボディフィールド生成 | E-03: L966-1016 | ○ |
| C-144 (UT-DEP-144) | get_body_field: 非埋め込みボディフィールド | E-03: L982-983 `if not embed_body_fields: return first_param` | ○ |
| C-145 (UT-DEP-145) | get_body_field: 埋め込みボディフィールド | E-03: L984-986 `create_body_model` | ○ |
| C-146 (UT-DEP-146) | get_body_field: Fileボディフィールド | E-03: L995-996 `BodyFieldInfo = params.File` | ○ |
| C-147 (UT-DEP-147) | get_body_field: Formボディフィールド | E-03: L997-998 `BodyFieldInfo = params.Form` | ○ |
| C-148 (UT-DEP-148) | get_body_field: media_type継承 | E-03: L1002-1008 | ○ |
| C-149 (UT-DEP-149) | get_body_field: 空ボディパラメータ | E-03: L979-980 `if not flat_dependant.body_params: return None` | ○ |
| C-150 (UT-DEP-150) | get_validation_alias: validation_alias取得 | E-03: L1019-1021 | ○ |
| C-151 (UT-DEP-151) | get_validation_alias: aliasフォールバック | E-03: L1021 `return va or field.alias` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

全てのテストケースはソースコード内の対応する実装に基づいて生成されています。

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 0（低リスク）**: 全てのテストケースが実装コードに基づいており、根拠が明確

特記事項:
- `solve_dependencies`関数（UT-DEP-099〜111）は複雑なロジックを含むため、実装時に追加のエッジケースが必要になる可能性あり
- Python バージョン依存のコード（`sys.version_info`チェック）があり、複数Pythonバージョンでのテストが推奨される

## 6) レビュアーチェックリスト（最小）
- [ ] solve_dependencies関連のテストケースがスコープ（request/function）を正しくカバーしているか確認
- [ ] analyze_param関連のテストケースがAnnotated型の全パターンを網羅しているか確認
- [ ] Dependantクラスのcached_propertyがキャッシュ動作を正しくテストしているか確認
- [ ] 非同期/同期ジェネレータの判定ロジックが全パターンをカバーしているか確認
- [ ] multipartインストールチェックのモック方法が適切か確認
