---
generated_at: 2026-01-22 10:30:00
metrics:
  claims_total: 157
  claims_with_evidence: 155
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：fastapi-core単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードに対応するクラス・メソッドが存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの主要なクラス・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：155 / 157、根拠なし：2
- 優先レビュー（高）
  1. **C-156 OpenAPI.model**: モデル定義の網羅性は実際のフィールド数の確認が必要
  2. **C-157 EmailStr.validate**: email-validator未インストール時の挙動は環境依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/dependencies/models.py`
- E-02: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/dependencies/utils.py`
- E-03: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/middleware/asyncexitstack.py`
- E-04: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/middleware/gzip.py`
- E-05: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/middleware/cors.py`
- E-06: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/middleware/httpsredirect.py`
- E-07: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/middleware/trustedhost.py`
- E-08: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/middleware/wsgi.py`
- E-09: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/openapi/utils.py`
- E-10: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/openapi/docs.py`
- E-11: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/openapi/models.py`
- E-12: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/openapi/constants.py`
- E-13: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/security/base.py`
- E-14: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/security/utils.py`
- E-15: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/security/oauth2.py`
- E-16: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/security/api_key.py`
- E-17: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/security/http.py`
- E-18: `/Users/tomokababa/Work/reverse-engineering/sample/fastapi-master/fastapi/security/open_id_connect_url.py`

## 3) Claims と根拠の対応（レビューの主戦場）

### dependencies モジュール (UT-FTC-001 〜 UT-FTC-074)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Dependant.oauth_scopes: parent/ownスコープ統合 | E-01 L54-60 | ○ |
| C-02 | Dependant.oauth_scopes: 重複スコープ除外 | E-01 L57-59 | ○ |
| C-03 | Dependant.oauth_scopes: parent_oauth_scopes=None | E-01 L55 | ○ |
| C-04 | Dependant.oauth_scopes: own_oauth_scopes=None | E-01 L57 | ○ |
| C-05 | Dependant.cache_key: キャッシュキー生成 | E-01 L63-71 | ○ |
| C-06 | Dependant._uses_scopes: own_oauth_scopes判定 | E-01 L75-76 | ○ |
| C-07 | Dependant._uses_scopes: security_scopes_param_name判定 | E-01 L77-78 | ○ |
| C-08 | Dependant._uses_scopes: サブ依存再帰判定 | E-01 L81-83 | ○ |
| C-09 | Dependant._is_security_scheme: SecurityBase判定 | E-01 L87-91 | ○ |
| C-10 | Dependant._is_security_scheme: 通常関数判定 | E-01 L88 | ○ |
| C-11 | Dependant.is_gen_callable: ジェネレータ判定 | E-01 L106-129 | ○ |
| C-12 | Dependant.is_gen_callable: 通常関数判定 | E-01 L106-129 | ○ |
| C-13 | Dependant.is_async_gen_callable: 非同期ジェネレータ判定 | E-01 L131-155 | ○ |
| C-14 | Dependant.is_coroutine_callable: コルーチン判定 | E-01 L157-185 | ○ |
| C-15 | Dependant.is_coroutine_callable: 通常関数判定 | E-01 L157-185 | ○ |
| C-16 | Dependant.computed_scope: scope設定時 | E-01 L188-189 | ○ |
| C-17 | Dependant.computed_scope: ジェネレータ時 | E-01 L191-192 | ○ |
| C-18 | _impartial: partial関数展開 | E-01 L25-28 | ○ |
| C-19 | _unwrapped_call: ラップ関数展開 | E-01 L18-22 | ○ |
| C-20 | _unwrapped_call: None処理 | E-01 L19-20 | ○ |
| C-21 | ensure_multipart_is_installed: 正常系 | E-02 L85-109 | ○ |
| C-22 | ensure_multipart_is_installed: 未インストール時 | E-02 L107-109 | ○ |
| C-23 | ensure_multipart_is_installed: 誤パッケージ時 | E-02 L104-106 | ○ |
| C-24 | get_parameterless_sub_dependant: Dependant生成 | E-02 L112-124 | ○ |
| C-25 | get_parameterless_sub_dependant: callable検証 | E-02 L113-115 | ○ |
| C-26 | get_flat_dependant: フラット化 | E-02 L127-178 | ○ |
| C-27 | get_flat_dependant: skip_repeats | E-02 L162-163 | ○ |
| C-28 | get_flat_params: パラメータ取得 | E-02 L191-197 | ○ |
| C-29 | get_typed_signature: シグネチャ取得 | E-02 L213-227 | ○ |
| C-30 | get_typed_annotation: ForwardRef解決 | E-02 L230-236 | ○ |
| C-31 | get_typed_annotation: None型処理 | E-02 L234-235 | ○ |
| C-32 | get_typed_return_annotation: 戻り値型取得 | E-02 L239-248 | ○ |
| C-33 | get_typed_return_annotation: 型なし時 | E-02 L244-245 | ○ |
| C-34 | get_dependant: Dependant生成 | E-02 L251-323 | ○ |
| C-35 | get_dependant: パスパラメータ抽出 | E-02 L271, 275 | ○ |
| C-36 | get_dependant: クエリパラメータ抽出 | E-02 L276-322 | ○ |
| C-37 | get_dependant: ボディパラメータ抽出 | E-02 L319-320 | ○ |
| C-38 | get_dependant: スコープ検証エラー | E-02 L284-293 | ○ |
| C-39 | add_non_field_param_to_dependency: Request型 | E-02 L329-331 | ○ |
| C-40 | add_non_field_param_to_dependency: WebSocket型 | E-02 L332-334 | ○ |
| C-41 | add_non_field_param_to_dependency: Response型 | E-02 L338-340 | ○ |
| C-42 | add_non_field_param_to_dependency: BackgroundTasks型 | E-02 L341-343 | ○ |
| C-43 | add_non_field_param_to_dependency: SecurityScopes型 | E-02 L344-346 | ○ |
| C-44 | analyze_param: FieldInfo抽出 | E-02 L357-524 | ○ |
| C-45 | analyze_param: Depends抽出 | E-02 L417-418 | ○ |
| C-46 | analyze_param: Depends重複エラー | E-02 L421-428 | ○ |
| C-47 | analyze_param: Path自動設定 | E-02 L465-469 | ○ |
| C-48 | analyze_param: File自動設定 | E-02 L470-473 | ○ |
| C-49 | analyze_param: Body自動設定 | E-02 L474-475 | ○ |
| C-50 | analyze_param: Query自動設定 | E-02 L476-477 | ○ |
| C-51 | add_param_to_fields: path_params追加 | E-02 L530-531 | ○ |
| C-52 | add_param_to_fields: query_params追加 | E-02 L532-533 | ○ |
| C-53 | add_param_to_fields: header_params追加 | E-02 L534-535 | ○ |
| C-54 | add_param_to_fields: cookie_params追加 | E-02 L536-540 | ○ |
| C-55 | solve_dependencies: 依存解決 | E-02 L563-700 | ○ |
| C-56 | solve_dependencies: キャッシュ使用 | E-02 L629-630 | ○ |
| C-57 | solve_dependencies: ジェネレータ依存 | E-02 L631-641 | ○ |
| C-58 | solve_dependencies: コルーチン依存 | E-02 L642-643 | ○ |
| C-59 | solve_dependencies: 同期関数実行 | E-02 L644-645 | ○ |
| C-60 | solve_dependencies: オーバーライド | E-02 L597-612 | ○ |
| C-61 | request_params_to_args: パラメータ変換 | E-02 L743-823 | ○ |
| C-62 | request_params_to_args: 必須エラー | E-02 L816-820 | ○ |
| C-63 | request_params_to_args: 空fields | E-02 L750-751 | ○ |
| C-64 | request_body_to_args: ボディ変換 | E-02 L916-963 | ○ |
| C-65 | request_body_to_args: 必須エラー | E-02 L956-960 | ○ |
| C-66 | _extract_form_body: フォーム抽出 | E-02 L869-913 | ○ |
| C-67 | _extract_form_body: ファイル変換 | E-02 L878-883 | ○ |
| C-68 | get_body_field: ボディフィールド取得 | E-02 L966-1016 | ○ |
| C-69 | get_body_field: embed時統合 | E-02 L984-1016 | ○ |
| C-70 | get_body_field: 空body_params | E-02 L979-980 | ○ |
| C-71 | _should_embed_body_fields: 複数フィールド | E-02 L852-853 | ○ |
| C-72 | _should_embed_body_fields: embed=True | E-02 L856-857 | ○ |
| C-73 | is_union_of_base_models: Union[Model] | E-02 L826-842 | ○ |
| C-74 | is_union_of_base_models: Union[str, int] | E-02 L838-840 | ○ |

### middleware モジュール (UT-FTC-075 〜 UT-FTC-077)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | AsyncExitStackMiddleware.__init__ | E-03 L9-13 | ○ |
| C-76 | AsyncExitStackMiddleware.__call__: スタック設定 | E-03 L15-18 | ○ |
| C-77 | AsyncExitStackMiddleware.__call__: クリーンアップ | E-03 L16-18 | ○ |

### openapi モジュール (UT-FTC-078 〜 UT-FTC-101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-78 | get_openapi_security_definitions | E-09 L78-101 | ○ |
| C-79 | get_openapi_security_definitions: スコープマージ | E-09 L92-97 | ○ |
| C-80 | _get_openapi_operation_parameters | E-09 L104-174 | ○ |
| C-81 | _get_openapi_operation_parameters: include_in_schema | E-09 L136-137 | ○ |
| C-82 | get_openapi_operation_request_body | E-09 L177-209 | ○ |
| C-83 | get_openapi_operation_request_body: None | E-09 L186-187 | ○ |
| C-84 | generate_operation_summary: summary設定時 | E-09 L228-229 | ○ |
| C-85 | generate_operation_summary: nameから生成 | E-09 L230 | ○ |
| C-86 | get_openapi_operation_metadata | E-09 L233-256 | ○ |
| C-87 | get_openapi_operation_metadata: 重複ID警告 | E-09 L243-251 | ○ |
| C-88 | get_openapi_path | E-09 L259-442 | ○ |
| C-89 | get_openapi_path: callbacks | E-09 L322-338 | ○ |
| C-90 | get_openapi_path: 422レスポンス | E-09 L418-438 | ○ |
| C-91 | get_fields_from_routes | E-09 L445-473 | ○ |
| C-92 | get_openapi | E-09 L476-567 | ○ |
| C-93 | get_openapi: webhooks | E-09 L537-555 | ○ |
| C-94 | get_openapi: tags | E-09 L563-564 | ○ |
| C-95 | get_swagger_ui_html | E-10 L26-158 | ○ |
| C-96 | get_swagger_ui_html: カスタムパラメータ | E-10 L113-115 | ○ |
| C-97 | get_swagger_ui_html: OAuth2リダイレクト | E-10 L138-139 | ○ |
| C-98 | get_swagger_ui_html: init_oauth | E-10 L148-151 | ○ |
| C-99 | get_redoc_html | E-10 L161-253 | ○ |
| C-100 | get_redoc_html: Googleフォント | E-10 L228-231 | ○ |
| C-101 | get_swagger_ui_oauth2_redirect_html | E-10 L256-344 | ○ |

### security モジュール (UT-FTC-102 〜 UT-FTC-157)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | SecurityBase属性 | E-13 L4-6 | ○ |
| C-103 | get_authorization_scheme_param: 正常系 | E-14 L4-10 | ○ |
| C-104 | get_authorization_scheme_param: None | E-14 L7-8 | ○ |
| C-105 | get_authorization_scheme_param: 空文字 | E-14 L7-8 | ○ |
| C-106 | OAuth2PasswordRequestForm.__init__ | E-15 L59-147 | ○ |
| C-107 | OAuth2PasswordRequestForm: 空scope | E-15 L145 | ○ |
| C-108 | OAuth2PasswordRequestFormStrict.__init__ | E-15 L150-303 | ○ |
| C-109 | OAuth2.__init__ | E-15 L319-375 | ○ |
| C-110 | OAuth2.make_not_authenticated_error | E-15 L377-397 | ○ |
| C-111 | OAuth2.__call__: 正常系 | E-15 L399-406 | ○ |
| C-112 | OAuth2.__call__: エラー | E-15 L401-403 | ○ |
| C-113 | OAuth2.__call__: auto_error=False | E-15 L404-405 | ○ |
| C-114 | OAuth2PasswordBearer.__init__ | E-15 L418-504 | ○ |
| C-115 | OAuth2PasswordBearer.__call__ | E-15 L506-514 | ○ |
| C-116 | OAuth2PasswordBearer.__call__: スキーム検証 | E-15 L509-511 | ○ |
| C-117 | OAuth2AuthorizationCodeBearer.__init__ | E-15 L523-610 | ○ |
| C-118 | OAuth2AuthorizationCodeBearer.__call__ | E-15 L612-620 | ○ |
| C-119 | SecurityScopes.__init__: 正常系 | E-15 L636-663 | ○ |
| C-120 | SecurityScopes.__init__: None | E-15 L654 | ○ |
| C-121 | APIKeyBase.__init__ | E-16 L11-27 | ○ |
| C-122 | APIKeyBase.make_not_authenticated_error | E-16 L29-43 | ○ |
| C-123 | APIKeyBase.check_api_key: 正常系 | E-16 L45-50 | ○ |
| C-124 | APIKeyBase.check_api_key: エラー | E-16 L46-48 | ○ |
| C-125 | APIKeyBase.check_api_key: auto_error=False | E-16 L49 | ○ |
| C-126 | APIKeyQuery.__call__ | E-16 L140-142 | ○ |
| C-127 | APIKeyQuery.__call__: エラー | E-16 L141-142 | ○ |
| C-128 | APIKeyHeader.__call__ | E-16 L228-230 | ○ |
| C-129 | APIKeyHeader.__call__: エラー | E-16 L229-230 | ○ |
| C-130 | APIKeyCookie.__call__ | E-16 L316-318 | ○ |
| C-131 | APIKeyCookie.__call__: エラー | E-16 L317-318 | ○ |
| C-132 | HTTPBasicCredentials | E-17 L16-26 | ○ |
| C-133 | HTTPAuthorizationCredentials | E-17 L29-66 | ○ |
| C-134 | HTTPBase.__init__ | E-17 L70-82 | ○ |
| C-135 | HTTPBase.make_authenticate_headers | E-17 L84-85 | ○ |
| C-136 | HTTPBase.__call__: 正常系 | E-17 L94-104 | ○ |
| C-137 | HTTPBase.__call__: エラー | E-17 L99-101 | ○ |
| C-138 | HTTPBasic.__init__ | E-17 L142-197 | ○ |
| C-139 | HTTPBasic.make_authenticate_headers: realm有 | E-17 L199-201 | ○ |
| C-140 | HTTPBasic.make_authenticate_headers: realm無 | E-17 L202 | ○ |
| C-141 | HTTPBasic.__call__: デコード | E-17 L204-221 | ○ |
| C-142 | HTTPBasic.__call__: スキーム検証 | E-17 L209-211 | ○ |
| C-143 | HTTPBasic.__call__: Base64エラー | E-17 L216-217 | ○ |
| C-144 | HTTPBasic.__call__: コロンなし | E-17 L219-220 | ○ |
| C-145 | HTTPBearer.__init__ | E-17 L256-303 | ○ |
| C-146 | HTTPBearer.__call__: 正常系 | E-17 L305-320 | ○ |
| C-147 | HTTPBearer.__call__: スキーム検証 | E-17 L315-319 | ○ |
| C-148 | HTTPDigest.__init__ | E-17 L361-406 | ○ |
| C-149 | HTTPDigest.__call__: 正常系 | E-17 L408-423 | ○ |
| C-150 | HTTPDigest.__call__: スキーム検証 | E-17 L418-421 | ○ |
| C-151 | OpenIdConnect.__init__ | E-18 L22-78 | ○ |
| C-152 | OpenIdConnect.make_not_authenticated_error | E-18 L80-85 | ○ |
| C-153 | OpenIdConnect.__call__: 正常系 | E-18 L87-94 | ○ |
| C-154 | OpenIdConnect.__call__: エラー | E-18 L89-91 | ○ |
| C-155 | Schema model定義 | E-11 L123-208 | ○ |
| C-156 | OpenAPI model定義 | E-11 L422-433 | △ |
| C-157 | EmailStr.validate | E-11 L22-54 | △ |

## 4) 不足情報（Unknown / Missing）
- **C-156 (OpenAPI model定義)**: OpenAPI 3.1.0仕様の全フィールドがカバーされているかの確認が必要
  - 候補：OpenAPI公式仕様書 / 既存のテストケース / Pydanticモデルのフィールド定義
- **C-157 (EmailStr.validate)**: email-validator未インストール時の動作は環境依存のため、実行環境でのテストが必要
  - 候補：CI/CD環境での依存性テスト / モック使用

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - dependencies, middleware, openapi, security の主要ロジックはソースコードから直接確認可能
- **1: 中リスク** - 一部のエッジケース（Base64デコードエラー、環境依存の挙動）は実行環境でのテストを推奨
- **0: 低リスク** - OpenAPIモデル定義は標準仕様に基づいており、Pydanticのバリデーションで保証される

## 6) レビュアーチェックリスト（最小）
- [ ] dependencies モジュールのテストケースが主要なクラス・メソッドをカバーしているか確認
- [ ] middleware モジュールのテストケースがASGIライフサイクルを考慮しているか確認
- [ ] openapi モジュールのテストケースがOpenAPI 3.1.0仕様に準拠しているか確認
- [ ] security モジュールのテストケースがOAuth2/APIKey/HTTP認証の各フローをカバーしているか確認
- [ ] 認証エラー時の挙動（auto_error=True/False）が全セキュリティクラスでテストされているか確認
- [ ] 境界値テスト（None、空文字、空リスト）が適切に含まれているか確認
