---
generated_at: 2026-01-22 22:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：middleware モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **UT-MID-003〜006**：AsyncExitStackMiddlewareの__call__メソッドのテスト（高優先度）
  2. **UT-MID-005**：ASGIチェーンの連携確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/middleware/__init__.py` - Middlewareのre-export定義
- E-02: `fastapi/middleware/asyncexitstack.py` - AsyncExitStackMiddlewareクラス実装
- E-03: `fastapi/middleware/cors.py` - CORSMiddlewareのre-export定義
- E-04: `fastapi/middleware/gzip.py` - GZipMiddlewareのre-export定義
- E-05: `fastapi/middleware/httpsredirect.py` - HTTPSRedirectMiddlewareのre-export定義
- E-06: `fastapi/middleware/trustedhost.py` - TrustedHostMiddlewareのre-export定義
- E-07: `fastapi/middleware/wsgi.py` - WSGIMiddlewareのre-export定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AsyncExitStackMiddleware.__init__はデフォルトでcontext_name="fastapi_middleware_astack"を使用 | E-02 (L9-11: `context_name: str = "fastapi_middleware_astack"`) | ○ |
| C-02 | AsyncExitStackMiddleware.__init__はカスタムcontext_nameを受け入れる | E-02 (L10: `context_name: str` パラメータ) | ○ |
| C-03 | AsyncExitStackMiddleware.__call__はscopeにAsyncExitStackを設定する | E-02 (L17: `scope[self.context_name] = stack`) | ○ |
| C-04 | AsyncExitStackMiddleware.__call__はリクエスト完了後にクリーンアップする | E-02 (L16: `async with AsyncExitStack() as stack:`) | ○ |
| C-05 | AsyncExitStackMiddleware.__call__は内部アプリを呼び出す | E-02 (L18: `await self.app(scope, receive, send)`) | ○ |
| C-06 | AsyncExitStackMiddlewareは例外時もスタックをクリーンアップする | E-02 (L16: `async with`コンテキストマネージャのセマンティクス) | ○ |
| C-07 | 空のscopeでも正常に動作する | E-02 (L17: scopeへの直接代入、型チェックなし) | ○ |
| C-08 | 既存のscope内容は保持される | E-02 (L17: 既存scopeへのキー追加のみ) | ○ |
| C-09 | Middlewareはstarlette.middlewareからre-exportされる | E-01 (L1: `from starlette.middleware import Middleware as Middleware`) | ○ |
| C-10 | CORSMiddlewareはstarlette.middleware.corsからre-exportされる | E-03 (L1: `from starlette.middleware.cors import CORSMiddleware as CORSMiddleware`) | ○ |
| C-11 | GZipMiddlewareはstarlette.middleware.gzipからre-exportされる | E-04 (L1: `from starlette.middleware.gzip import GZipMiddleware as GZipMiddleware`) | ○ |
| C-12 | HTTPSRedirectMiddlewareはstarlette.middleware.httpsredirectからre-exportされる | E-05 (L1-2: `from starlette.middleware.httpsredirect import HTTPSRedirectMiddleware`) | ○ |
| C-13 | TrustedHostMiddlewareはstarlette.middleware.trustedhostからre-exportされる | E-06 (L1-2: `from starlette.middleware.trustedhost import TrustedHostMiddleware`) | ○ |
| C-14 | WSGIMiddlewareはstarlette.middleware.wsgiからre-exportされる | E-07 (L1: `from starlette.middleware.wsgi import WSGIMiddleware as WSGIMiddleware`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし
  - middlewareモジュールは比較的シンプルな構造であり、すべてのテストケースに対してソースコードから直接根拠を確認できた

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - middlewareモジュールは薄いラッパー層であり、主要なロジックはStarletteに委譲されている
- **1: 中リスク** - AsyncExitStackMiddlewareは独自実装だが、シンプルなコンテキストマネージャの活用であり、Python標準ライブラリの挙動に依存

## 6) レビュアーチェックリスト（最小）
- [ ] AsyncExitStackMiddlewareの例外ハンドリングテスト（UT-MID-006）が実際の例外シナリオを網羅しているか
- [ ] Starletteからのre-exportテストが必要十分か（re-exportの検証はimport確認のみで十分か）
- [ ] ASGIアプリのモックが適切に設計されているか（receive/sendのモック仕様）
- [ ] context_nameの重複時の挙動についてテストケースを追加すべきか検討
