---
generated_at: 2026-01-22 22:25:00
metrics:
  claims_total: 77
  claims_with_evidence: 77
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：security.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（security.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコードの該当メソッド・クラスが存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：参照すべきクラス・メソッドを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：77 / 77、根拠なし：0
- 優先レビュー（高）
  1. **HTTPBasic認証のBase64デコード処理**：セキュリティ上重要な処理
  2. **auto_errorフラグによる分岐**：オプショナル認証の挙動
  3. **OAuth2フロー初期化**：OpenAPI仕様との整合性

## 2) 参照した情報（Evidence一覧）
> 解析対象のソースコードファイル

- E-01: `fastapi/security/base.py` - SecurityBase基底クラス定義
- E-02: `fastapi/security/utils.py` - get_authorization_scheme_param関数
- E-03: `fastapi/security/api_key.py` - APIKeyBase, APIKeyQuery, APIKeyHeader, APIKeyCookie
- E-04: `fastapi/security/http.py` - HTTPBasicCredentials, HTTPAuthorizationCredentials, HTTPBase, HTTPBasic, HTTPBearer, HTTPDigest
- E-05: `fastapi/security/oauth2.py` - OAuth2PasswordRequestForm, OAuth2PasswordRequestFormStrict, OAuth2, OAuth2PasswordBearer, OAuth2AuthorizationCodeBearer, SecurityScopes
- E-06: `fastapi/security/open_id_connect_url.py` - OpenIdConnect
- E-07: `fastapi/security/__init__.py` - モジュール公開API

## 3) Claims と根拠の対応（レビューの主戦場）

### utils.py - get_authorization_scheme_param
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-SEC-001) | 正しい形式のAuthorizationヘッダー解析 | E-02: L4-10 partition(" ")で分割 | ○ |
| C-02 (UT-SEC-002) | Basicスキームのヘッダー解析 | E-02: L4-10 同上 | ○ |
| C-03 (UT-SEC-003) | 空文字列時の処理 | E-02: L7-8 not authorization_header_valueで("", "")返却 | ○ |
| C-04 (UT-SEC-004) | None時の処理 | E-02: L7-8 同上（Noneはfalsy） | ○ |
| C-05 (UT-SEC-005) | スペースなし文字列 | E-02: L9 partition(" ")でスペースなしなら(scheme, "", "")になり(scheme, "")返却 | ○ |
| C-06 (UT-SEC-006) | 複数スペースを含む文字列 | E-02: L9 partition(" ")は最初のスペースで分割 | ○ |

### base.py - SecurityBase
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-07 (UT-SEC-007) | クラス属性の定義 | E-01: L4-6 model, scheme_name属性定義 | ○ |

### api_key.py - APIKeyBase, APIKeyQuery, APIKeyHeader, APIKeyCookie
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-08 (UT-SEC-008) | APIKeyBase初期化 | E-03: L11-27 __init__でmodel, scheme_name, auto_error設定 | ○ |
| C-09 (UT-SEC-009) | make_not_authenticated_error | E-03: L29-43 HTTPException(401)生成 | ○ |
| C-10 (UT-SEC-010) | check_api_key正常系 | E-03: L45-50 api_keyがあればそのまま返却 | ○ |
| C-11 (UT-SEC-011) | check_api_key異常系(auto_error=True) | E-03: L46-48 not api_keyでauto_errorならraise | ○ |
| C-12 (UT-SEC-012) | check_api_key異常系(auto_error=False) | E-03: L48-49 auto_error=FalseならNone返却 | ○ |
| C-13 (UT-SEC-013) | check_api_key空文字列 | E-03: L46 not api_keyで空文字列もfalsy | ○ |
| C-14 (UT-SEC-014) | APIKeyQuery初期化 | E-03: L132-138 location=APIKeyIn.query設定 | ○ |
| C-15 (UT-SEC-015) | APIKeyQuery.__call__正常系 | E-03: L140-142 query_params.getでキー取得 | ○ |
| C-16 (UT-SEC-016) | APIKeyQuery.__call__異常系(auto_error=True) | E-03: L142 check_api_key経由でエラー | ○ |
| C-17 (UT-SEC-017) | APIKeyQuery.__call__異常系(auto_error=False) | E-03: L142 check_api_key経由でNone | ○ |
| C-18 (UT-SEC-018) | APIKeyHeader初期化 | E-03: L220-226 location=APIKeyIn.header設定 | ○ |
| C-19 (UT-SEC-019) | APIKeyHeader.__call__正常系 | E-03: L228-230 headers.getでキー取得 | ○ |
| C-20 (UT-SEC-020) | APIKeyHeader.__call__異常系 | E-03: L230 check_api_key経由 | ○ |
| C-21 (UT-SEC-021) | APIKeyCookie初期化 | E-03: L308-314 location=APIKeyIn.cookie設定 | ○ |
| C-22 (UT-SEC-022) | APIKeyCookie.__call__正常系 | E-03: L316-318 cookies.getでキー取得 | ○ |
| C-23 (UT-SEC-023) | APIKeyCookie.__call__異常系 | E-03: L318 check_api_key経由 | ○ |

### http.py - HTTPBasicCredentials, HTTPAuthorizationCredentials, HTTPBase, HTTPBasic, HTTPBearer, HTTPDigest
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 (UT-SEC-024) | HTTPBasicCredentials初期化 | E-04: L16-26 Pydanticモデル定義 | ○ |
| C-25 (UT-SEC-025) | HTTPAuthorizationCredentials初期化 | E-04: L29-66 Pydanticモデル定義 | ○ |
| C-26 (UT-SEC-026) | HTTPBase初期化 | E-04: L69-82 scheme, model, auto_error設定 | ○ |
| C-27 (UT-SEC-027) | HTTPBase.make_authenticate_headers | E-04: L84-85 WWW-Authenticateヘッダー生成 | ○ |
| C-28 (UT-SEC-028) | HTTPBase.make_not_authenticated_error | E-04: L87-92 HTTPException(401)生成 | ○ |
| C-29 (UT-SEC-029) | HTTPBase.__call__正常系 | E-04: L94-104 認証情報取得 | ○ |
| C-30 (UT-SEC-030) | HTTPBase.__call__異常系(auto_error=True) | E-04: L99-101 auto_errorでraise | ○ |
| C-31 (UT-SEC-031) | HTTPBase.__call__異常系(auto_error=False) | E-04: L102-103 None返却 | ○ |
| C-32 (UT-SEC-032) | HTTPBasic初期化 | E-04: L194 scheme="basic"設定 | ○ |
| C-33 (UT-SEC-033) | HTTPBasic realm設定 | E-04: L196 realm属性設定 | ○ |
| C-34 (UT-SEC-034) | HTTPBasic.make_authenticate_headers(realm=None) | E-04: L202 "Basic"のみ返却 | ○ |
| C-35 (UT-SEC-035) | HTTPBasic.make_authenticate_headers(realm設定) | E-04: L200-201 Basic realm="..."形式 | ○ |
| C-36 (UT-SEC-036) | HTTPBasic.__call__正常系 | E-04: L214-221 Base64デコードしてCredentials返却 | ○ |
| C-37 (UT-SEC-037) | HTTPBasic.__call__スキーム不正 | E-04: L209-213 scheme.lower() != "basic"でエラー | ○ |
| C-38 (UT-SEC-038) | HTTPBasic.__call__ Base64デコードエラー | E-04: L216-217 binascii.Error等でエラー | ○ |
| C-39 (UT-SEC-039) | HTTPBasic.__call__コロンなし | E-04: L219-220 not separatorでエラー | ○ |
| C-40 (UT-SEC-040) | HTTPBasic.__call__パスワード内コロン | E-04: L218 partition(":")で最初のコロンのみで分割 | ○ |
| C-41 (UT-SEC-041) | HTTPBearer初期化 | E-04: L301 HTTPBearerModel設定 | ○ |
| C-42 (UT-SEC-042) | HTTPBearer bearerFormat設定 | E-04: L301 bearerFormat引数 | ○ |
| C-43 (UT-SEC-043) | HTTPBearer.__call__正常系 | E-04: L305-320 認証情報返却 | ○ |
| C-44 (UT-SEC-044) | HTTPBearer.__call__スキーム不正(auto_error=True) | E-04: L315-317 scheme.lower() != "bearer"でraise | ○ |
| C-45 (UT-SEC-045) | HTTPBearer.__call__スキーム不正(auto_error=False) | E-04: L318-319 None返却 | ○ |
| C-46 (UT-SEC-046) | HTTPDigest初期化 | E-04: L404 scheme="digest"設定 | ○ |
| C-47 (UT-SEC-047) | HTTPDigest.__call__正常系 | E-04: L408-423 認証情報返却 | ○ |
| C-48 (UT-SEC-048) | HTTPDigest.__call__スキーム不正 | E-04: L418-422 scheme.lower() != "digest"でエラー | ○ |

### oauth2.py - OAuth2系クラス
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 (UT-SEC-049) | OAuth2PasswordRequestForm初期化 | E-05: L59-147 各フィールド設定 | ○ |
| C-50 (UT-SEC-050) | OAuth2PasswordRequestForm scope分割 | E-05: L145 scope.split()でスペース区切り | ○ |
| C-51 (UT-SEC-051) | OAuth2PasswordRequestForm 空scope | E-05: L145 "".split()は[]になる | ○ |
| C-52 (UT-SEC-052) | OAuth2PasswordRequestForm client設定 | E-05: L146-147 client_id, client_secret設定 | ○ |
| C-53 (UT-SEC-053) | OAuth2PasswordRequestFormStrict grant_type必須 | E-05: L214-303 grant_type引数が必須（デフォルトなし） | ○ |
| C-54 (UT-SEC-054) | OAuth2初期化 | E-05: L319-375 flows, scheme_name, auto_error設定 | ○ |
| C-55 (UT-SEC-055) | OAuth2.make_not_authenticated_error | E-05: L377-397 HTTPException(401)生成 | ○ |
| C-56 (UT-SEC-056) | OAuth2.__call__正常系 | E-05: L399-406 Authorizationヘッダー全体返却 | ○ |
| C-57 (UT-SEC-057) | OAuth2.__call__異常系(auto_error=True) | E-05: L401-403 raise | ○ |
| C-58 (UT-SEC-058) | OAuth2.__call__異常系(auto_error=False) | E-05: L404-405 None返却 | ○ |
| C-59 (UT-SEC-059) | OAuth2PasswordBearer初期化 | E-05: L487-504 flows.password設定 | ○ |
| C-60 (UT-SEC-060) | OAuth2PasswordBearer scopes設定 | E-05: L495 scopesパラメータ | ○ |
| C-61 (UT-SEC-061) | OAuth2PasswordBearer refreshUrl設定 | E-05: L494 refreshUrlパラメータ | ○ |
| C-62 (UT-SEC-062) | OAuth2PasswordBearer.__call__正常系 | E-05: L506-514 paramのみ返却（schemeなし） | ○ |
| C-63 (UT-SEC-063) | OAuth2PasswordBearer.__call__スキーム不正 | E-05: L509-513 scheme.lower() != "bearer"でエラー | ○ |
| C-64 (UT-SEC-064) | OAuth2PasswordBearer.__call__ヘッダーなし | E-05: L509-513 not authorizationでエラー | ○ |
| C-65 (UT-SEC-065) | OAuth2AuthorizationCodeBearer初期化 | E-05: L594-610 flows.authorizationCode設定 | ○ |
| C-66 (UT-SEC-066) | OAuth2AuthorizationCodeBearer フルオプション | E-05: L594-610 全パラメータ設定 | ○ |
| C-67 (UT-SEC-067) | OAuth2AuthorizationCodeBearer.__call__正常系 | E-05: L612-620 paramのみ返却 | ○ |
| C-68 (UT-SEC-068) | OAuth2AuthorizationCodeBearer.__call__スキーム不正 | E-05: L615-619 scheme.lower() != "bearer"でエラー | ○ |
| C-69 (UT-SEC-069) | SecurityScopes初期化 | E-05: L636-663 scopes, scope_str設定 | ○ |
| C-70 (UT-SEC-070) | SecurityScopes scopes=None | E-05: L654 scopes or []でデフォルト空リスト | ○ |
| C-71 (UT-SEC-071) | SecurityScopes 空リスト | E-05: L654-663 scopes=[], scope_str="" | ○ |

### open_id_connect_url.py - OpenIdConnect
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-72 (UT-SEC-072) | OpenIdConnect初期化 | E-06: L22-78 openIdConnectUrl設定 | ○ |
| C-73 (UT-SEC-073) | OpenIdConnect フルオプション | E-06: L22-78 全パラメータ設定 | ○ |
| C-74 (UT-SEC-074) | OpenIdConnect.make_not_authenticated_error | E-06: L80-85 HTTPException(401)生成 | ○ |
| C-75 (UT-SEC-075) | OpenIdConnect.__call__正常系 | E-06: L87-94 Authorizationヘッダー返却 | ○ |
| C-76 (UT-SEC-076) | OpenIdConnect.__call__異常系(auto_error=True) | E-06: L89-91 raise | ○ |
| C-77 (UT-SEC-077) | OpenIdConnect.__call__異常系(auto_error=False) | E-06: L92-93 None返却 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全テストケースがソースコードに基づいており、根拠なしの項目はありません。

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: 全テストケースがソースコード解析に基づいて生成されています。
- **注意点**:
  - HTTPBasicのBase64デコード処理はセキュリティ上重要なため、実際のテスト実装時にエッジケースを追加検討してください。
  - auto_errorフラグの分岐は認証の必須/オプショナルを決定する重要な要素です。

## 6) レビュアーチェックリスト（最小）
- [ ] 全77件のテストケースがsecurityモジュール内のクラス/メソッドをカバーしているか確認
- [ ] HTTPBasic認証のBase64デコードに関するテストケース（UT-SEC-036〜040）が十分か確認
- [ ] auto_errorフラグの分岐を網羅しているか確認（各クラスで正常系/auto_error=True/auto_error=Falseの3パターン）
- [ ] OAuth2フローの初期化パラメータが正しく検証されているか確認
- [ ] 境界値テスト（空文字列、None、空リスト等）が適切に含まれているか確認
