---
generated_at: 2026-01-22 22:30:00
metrics:
  claims_total: 60
  claims_with_evidence: 57
  claims_without_evidence: 3
confidence_derived: 0.95
---

# 根拠レポート：受入テストケース一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：57 / 60、根拠なし：3
- 優先レビュー（高）
  1. **UAT-058（ユーザー登録からログインまでの一連フロー）**：E2Eシナリオのため具体的実装の根拠が薄い
  2. **UAT-059（商品CRUD一連操作）**：E2Eシナリオのため具体的実装の根拠が薄い
  3. **UAT-060（WebSocketチャットセッション）**：E2Eシナリオのため具体的実装の根拠が薄い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `fastapi/__init__.py` - FastAPIフレームワークのメインエクスポート
- E-02: `fastapi/applications.py` - FastAPIアプリケーションクラス定義
- E-03: `fastapi/routing.py` - ルーティング機能定義
- E-04: `fastapi/params.py` - パラメータ処理定義
- E-05: `fastapi/param_functions.py` - パラメータ関数（Path, Query, Header, Cookie, Body, Form, File, Depends, Security）
- E-06: `fastapi/datastructures.py` - UploadFileクラス定義
- E-07: `fastapi/security/__init__.py` - セキュリティモジュールエクスポート
- E-08: `fastapi/security/oauth2.py` - OAuth2認証実装
- E-09: `fastapi/security/http.py` - HTTP Basic/Bearer/Digest認証
- E-10: `fastapi/security/api_key.py` - APIキー認証
- E-11: `fastapi/openapi/docs.py` - Swagger UI, ReDoc生成関数
- E-12: `fastapi/exceptions.py` - HTTPException, WebSocketException, ValidationError定義
- E-13: `fastapi/exception_handlers.py` - 例外ハンドラ
- E-14: `fastapi/websockets.py` - WebSocket機能
- E-15: `fastapi/middleware/cors.py` - CORSミドルウェア
- E-16: `fastapi/middleware/gzip.py` - GZipミドルウェア
- E-17: `fastapi/middleware/httpsredirect.py` - HTTPSリダイレクトミドルウェア
- E-18: `fastapi/background.py` - BackgroundTasks
- E-19: `fastapi/encoders.py` - jsonable_encoder
- E-20: `fastapi/templating.py` - Jinja2Templates
- E-21: `fastapi/staticfiles.py` - StaticFiles
- E-22: `docs_src/security/tutorial005_an_py39.py` - OAuth2スコープ付き認証サンプル
- E-23: `docs_src/security/tutorial001_an_py39.py` - OAuth2基本サンプル
- E-24: `docs_src/bigger_applications/app_an_py39/main.py` - ルーター分割サンプル
- E-25: `docs_src/bigger_applications/app_an_py39/routers/users.py` - ユーザールーターサンプル
- E-26: `docs_src/bigger_applications/app_an_py39/routers/items.py` - アイテムルーターサンプル
- E-27: `docs_src/sql_databases/tutorial001_an_py310.py` - SQLデータベースCRUDサンプル
- E-28: `docs_src/request_files/tutorial001_an_py39.py` - ファイルアップロードサンプル
- E-29: `docs_src/websockets/tutorial001_py39.py` - WebSocketサンプル
- E-30: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧定義
- E-31: `docs/code-to-docs/業務要件一覧/業務要件一覧.csv` - 業務要件定義
- E-32: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: FastAPIアプリケーション正常起動 | E-02 | ○ |
| C-02 | UAT-002: Swagger UIへのアクセス | E-11, E-30, E-32 | ○ |
| C-03 | UAT-003: ReDocへのアクセス | E-11, E-30, E-32 | ○ |
| C-04 | UAT-004: OpenAPIスキーマJSONの取得 | E-02, E-30 | ○ |
| C-05 | UAT-005: GETリクエストの正常処理 | E-03, E-31 | ○ |
| C-06 | UAT-006: POSTリクエストでのデータ作成 | E-03, E-31 | ○ |
| C-07 | UAT-007: PUTリクエストでのデータ更新 | E-03, E-31 | ○ |
| C-08 | UAT-008: DELETEリクエストでのデータ削除 | E-03, E-31 | ○ |
| C-09 | UAT-009: パスパラメータの正常受付 | E-04, E-05, E-31 | ○ |
| C-10 | UAT-010: パスパラメータの型不正エラー | E-04, E-12 | ○ |
| C-11 | UAT-011: クエリパラメータの正常受付 | E-04, E-05, E-31 | ○ |
| C-12 | UAT-012: 必須クエリパラメータ欠落エラー | E-04, E-12 | ○ |
| C-13 | UAT-013: カスタムヘッダーの受付 | E-04, E-05 | ○ |
| C-14 | UAT-014: Cookieの受付 | E-04, E-05 | ○ |
| C-15 | UAT-015: JSONボディの正常受付 | E-04, E-05, E-31 | ○ |
| C-16 | UAT-016: JSONボディのバリデーションエラー | E-12, E-31 | ○ |
| C-17 | UAT-017: フォームデータの正常受付 | E-04, E-05, E-31 | ○ |
| C-18 | UAT-018: 単一ファイルアップロード | E-06, E-28 | ○ |
| C-19 | UAT-019: 複数ファイル同時アップロード | E-06, E-28 | ○ |
| C-20 | UAT-020: ログインとトークン取得 | E-08, E-22, E-31 | ○ |
| C-21 | UAT-021: 無効な認証情報でのログイン失敗 | E-08, E-22 | ○ |
| C-22 | UAT-022: トークンによる保護リソースアクセス | E-08, E-22, E-23 | ○ |
| C-23 | UAT-023: 期限切れトークンでのアクセス拒否 | E-08, E-22 | ○ |
| C-24 | UAT-024: スコープベースアクセス制御 | E-08, E-22 | ○ |
| C-25 | UAT-025: Basic認証でのログイン | E-09, E-31 | ○ |
| C-26 | UAT-026: ヘッダーによるAPIキー認証 | E-10, E-31 | ○ |
| C-27 | UAT-027: 現在のユーザー情報取得 | E-22 | ○ |
| C-28 | UAT-028: 無効化ユーザーのアクセス拒否 | E-22 | ○ |
| C-29 | UAT-029: 共通依存性の実行 | E-05, E-31 | ○ |
| C-30 | UAT-030: グローバル依存性の実行 | E-02, E-24 | ○ |
| C-31 | UAT-031: 404 Not Foundエラー | E-12, E-26 | ○ |
| C-32 | UAT-032: 422 Validation Errorの詳細 | E-12, E-13 | ○ |
| C-33 | UAT-033: 500 Internal Server Error | E-12, E-13 | ○ |
| C-34 | UAT-034: カスタムエラーレスポンス | E-13 | ○ |
| C-35 | UAT-035: WebSocket接続確立 | E-14, E-29 | ○ |
| C-36 | UAT-036: WebSocketメッセージ送受信 | E-14, E-29 | ○ |
| C-37 | UAT-037: WebSocket接続切断 | E-14, E-29 | ○ |
| C-38 | UAT-038: CORSプリフライトリクエスト | E-15, E-31 | ○ |
| C-39 | UAT-039: CORS有効ドメインからのアクセス | E-15 | ○ |
| C-40 | UAT-040: GZip圧縮レスポンス | E-16 | ○ |
| C-41 | UAT-041: HTTPからHTTPSへのリダイレクト | E-17 | ○ |
| C-42 | UAT-042: バックグラウンド処理の実行 | E-18, E-31 | ○ |
| C-43 | UAT-043: レスポンスフィルタリング | E-03, E-31 | ○ |
| C-44 | UAT-044: カスタムステータスコード | E-03 | ○ |
| C-45 | UAT-045: HTMLテンプレートレスポンス | E-20 | ○ |
| C-46 | UAT-046: 静的ファイルのダウンロード | E-21 | ○ |
| C-47 | UAT-047: モジュール別ルーターアクセス | E-03, E-24, E-25, E-26 | ○ |
| C-48 | UAT-048: プレフィックス付きルートアクセス | E-03, E-24 | ○ |
| C-49 | UAT-049: Swagger UIからのOAuth2認証 | E-11 | ○ |
| C-50 | UAT-050: Swagger UIからのAPIテスト | E-11 | ○ |
| C-51 | UAT-051: CRUDの一連操作 | E-27 | ○ |
| C-52 | UAT-052: リスト取得のページネーション | E-27 | ○ |
| C-53 | UAT-053: 起動イベント処理 | E-02, E-27, E-31 | ○ |
| C-54 | UAT-054: 終了イベント処理 | E-02, E-31 | ○ |
| C-55 | UAT-055: 標準エラーレスポンス形式確認 | E-12 | ○ |
| C-56 | UAT-056: 日付型のJSON変換 | E-19 | ○ |
| C-57 | UAT-057: UUID型のJSON変換 | E-19 | ○ |
| C-58 | UAT-058: ユーザー登録からログインまでの一連フロー | **根拠なし** | △ |
| C-59 | UAT-059: 商品CRUD一連操作 | **根拠なし** | △ |
| C-60 | UAT-060: WebSocketチャットセッション | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- UAT-058, UAT-059, UAT-060はE2Eシナリオテストとして定義しているが、FastAPIフレームワーク自体には具体的なユーザー登録機能や商品管理機能の実装が含まれていない
  - 候補：アプリケーション固有の実装ドキュメント / ユースケース定義書 / 業務フロー図

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: UAT-001〜UAT-057 - ソースコードとサンプルコードから直接根拠を確認可能
- **1（中リスク）**: UAT-058〜UAT-060 - E2Eシナリオはフレームワークではなくアプリケーション実装に依存するため、実際のアプリケーション要件に合わせて調整が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 全60テストケースが業務要件一覧（BR-001〜BR-045）をカバーしているか確認
- [ ] 高優先度テストケース（22件）が実際の受入基準と整合しているか確認
- [ ] E2Eシナリオテスト（UAT-058〜UAT-060）がアプリケーション固有の業務フローと整合しているか確認
- [ ] セキュリティ関連テストケース（UAT-020〜UAT-028）が組織のセキュリティポリシーを満たしているか確認
- [ ] WebSocket関連テストケース（UAT-035〜UAT-037）の期待結果が具体的であるか確認
- [ ] 各テストケースの前提条件が実現可能であるか確認
