# 帳票設計書 1-Swagger UI HTML

## 概要

本ドキュメントは、FastAPIフレームワークにおけるSwagger UI HTML帳票の設計仕様を定義する。Swagger UIは、OpenAPI仕様書に基づいて対話型APIドキュメントを生成するためのHTMLページである。

### 本帳票の処理概要

Swagger UI HTMLは、FastAPIアプリケーションのAPIエンドポイントを視覚的かつ対話的に操作・検証できるインターフェースを提供する帳票である。この帳票は、`/docs`エンドポイントにアクセスした際に動的に生成され、ブラウザ上でAPIの仕様確認や実際のリクエスト送信を可能にする。

**業務上の目的・背景**：API開発において、開発者やテスターがAPIの仕様を理解し、動作確認を行うための標準的なドキュメント生成機能が必要である。Swagger UIは、OpenAPI仕様に準拠したAPIドキュメントを自動生成し、手動でのドキュメント作成コストを削減するとともに、APIの仕様とドキュメントの乖離を防止する。また、フロントエンド開発者やサードパーティ開発者がAPIを理解するための入口として機能する。

**帳票の利用シーン**：開発フェーズにおけるAPI動作確認、QAチームによるAPI検証、フロントエンド開発者によるAPI仕様確認、外部開発者向けAPIドキュメント公開時に利用される。

**主要な出力内容**：
1. APIエンドポイント一覧と各エンドポイントの詳細仕様
2. リクエストパラメータ・ボディの定義とサンプル
3. レスポンススキーマと想定されるステータスコード
4. 認証・認可に関する設定情報
5. 対話的なAPI実行インターフェース

**帳票の出力タイミング**：FastAPIアプリケーション起動後、`/docs`（デフォルト）エンドポイントへのHTTPリクエスト時に動的生成される。

**帳票の利用者**：API開発者、フロントエンド開発者、QAエンジニア、テクニカルライター、外部API利用者

## 帳票種別

対話型APIドキュメント（HTMLページ）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| 1 | Swagger UI | /docs（デフォルト、変更可能） | ブラウザでURLにアクセス |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML |
| 用紙サイズ | N/A（Webページ） |
| 向き | N/A |
| ファイル名 | N/A（動的生成） |
| 出力方法 | HTTPレスポンス（ブラウザ表示） |
| 文字コード | UTF-8 |

### HTML固有設定

| 項目 | 内容 |
|-----|------|
| Content-Type | text/html; charset=utf-8 |
| JavaScript依存 | swagger-ui-bundle.js（CDN） |
| CSS依存 | swagger-ui.css（CDN） |
| Favicon | FastAPI公式アイコン |

## 帳票レイアウト

### レイアウト概要

Swagger UIは、ヘッダー部にAPIタイトル、メインコンテンツ部にAPIエンドポイント一覧を表示する構成である。

```
┌─────────────────────────────────────┐
│          ヘッダー部                  │
│   ・APIタイトル（ブラウザタブ）        │
│   ・Swagger UIロゴ                   │
├─────────────────────────────────────┤
│          コントロール部               │
│   ・API情報セクション                 │
│   ・認証ボタン（Authorize）           │
├─────────────────────────────────────┤
│          エンドポイント一覧           │
│   ・タグ別グループ                    │
│   ・各エンドポイントの展開表示         │
│   ・Try it out機能                   │
└─────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | ページタイトル | ブラウザタブに表示されるタイトル | FastAPI.title + " - Swagger UI" | テキスト |
| 2 | Favicon | ブラウザタブのアイコン | swagger_favicon_url パラメータ | 画像 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | エンドポイントURL | APIのパス | OpenAPI spec paths | テキスト | 自動 |
| 2 | HTTPメソッド | GET/POST等 | OpenAPI spec methods | バッジ | 固定 |
| 3 | サマリー | エンドポイントの説明 | OpenAPI spec summary | テキスト | 自動 |
| 4 | パラメータ | リクエストパラメータ | OpenAPI spec parameters | テーブル | 自動 |
| 5 | レスポンス | レスポンススキーマ | OpenAPI spec responses | テーブル | 自動 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | N/A | フッター部なし | - | - |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| openapi_url設定 | OpenAPI JSONのURLが設定されていること | Yes |
| docs_url設定 | Swagger UIのURLが設定されていること（Noneでない） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | タグ順 | OpenAPI tags定義順 |
| 2 | エンドポイントパス | 定義順 |

### 改ページ条件

N/A（Webページのためスクロール表示）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベースへの直接参照なし | - |

### OpenAPIスキーマからの参照

Swagger UIはOpenAPI JSONスキーマを参照して表示を行う。OpenAPI JSONは`get_openapi()`関数により、アプリケーションに登録されたルート情報から動的に生成される。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| openapi_url | root_path + self.openapi_url | N/A | ルートパスの結合 |
| oauth2_redirect_url | root_path + swagger_ui_oauth2_redirect_url | N/A | ルートパスの結合 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[/docs へのHTTPリクエスト] --> B[swagger_ui_html関数呼び出し]
    B --> C[root_path取得]
    C --> D[openapi_url計算]
    D --> E[oauth2_redirect_url計算]
    E --> F[get_swagger_ui_html呼び出し]
    F --> G[swagger_ui_parametersマージ]
    G --> H[HTML文字列生成]
    H --> I[HTMLResponse返却]
    I --> J[ブラウザ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 404 Not Found | docs_urlがNoneに設定されている場合 | ページが見つかりません | docs_urlを設定する |
| 設定エラー | titleまたはversionが未設定 | AssertionError | titleとversionを設定する |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1リクエストにつき1HTML生成 |
| 目標出力時間 | 100ms以下 |
| 同時出力数上限 | Webサーバーの同時接続数に依存 |

## セキュリティ考慮事項

- 本番環境ではdocs_urlをNoneに設定してSwagger UIを無効化することを推奨
- OAuth2認証を使用する場合、init_oauthパラメータで適切な設定が必要
- swagger_ui_oauth2_redirect_urlのCSRF対策としてstate検証を実施

## 備考

- Swagger UI のJavaScript/CSSはデフォルトでCDN（jsDelivr）から読み込まれる
- セルフホスティング環境では、swagger_js_url/swagger_css_urlをカスタマイズ可能
- swagger_ui_parametersでSwagger UIの動作をカスタマイズ可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、Swagger UI生成に使用されるデフォルトパラメータとHTMLレスポンスの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | docs.py | `fastapi/openapi/docs.py` | swagger_ui_default_parameters辞書（行8-23）でデフォルト設定を確認 |

**読解のコツ**: `Annotated`と`Doc`はPython型ヒントとドキュメンテーションのための記法である。実際の処理ロジックは関数本体にある。

#### Step 2: エントリーポイントを理解する

処理の起点となるFastAPIアプリケーションのsetup()メソッドを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | applications.py | `fastapi/applications.py` | setup()メソッド（行1079-1130）でSwagger UIルートの登録を確認 |

**主要処理フロー**:
1. **行1093-1109**: docs_urlが設定されている場合、swagger_ui_html関数をルートとして登録
2. **行1095-1107**: swagger_ui_html内部関数でroot_pathを取得しget_swagger_ui_html()を呼び出し
3. **行1111-1120**: OAuth2リダイレクトURLが設定されている場合、リダイレクトルートも登録

#### Step 3: HTML生成処理を理解する

get_swagger_ui_html()関数の詳細を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | docs.py | `fastapi/openapi/docs.py` | get_swagger_ui_html関数（行26-158）でHTML生成ロジックを確認 |

**主要処理フロー**:
- **行113-115**: デフォルトパラメータのコピーとカスタムパラメータのマージ
- **行117-133**: HTML文字列の構築開始（DOCTYPE、head、body、swagger-ui div）
- **行135-136**: swagger_ui_parametersをJSON形式でスクリプトに埋め込み
- **行138-139**: oauth2_redirect_urlの設定
- **行141-146**: SwaggerUIBundleのプリセット設定
- **行148-151**: init_oauthの設定（OAuth2初期化）
- **行153-158**: HTML文字列の完成とHTMLResponseの返却

### プログラム呼び出し階層図

```
FastAPI.__init__()
    │
    └─ setup()
           │
           ├─ swagger_ui_html() [内部関数]
           │      │
           │      └─ get_swagger_ui_html()
           │             └─ HTMLResponse
           │
           └─ swagger_ui_redirect() [内部関数]
                  │
                  └─ get_swagger_ui_oauth2_redirect_html()
                         └─ HTMLResponse
```

### データフロー図

```
[入力]                    [処理]                         [出力]

HTTPリクエスト ──────▶ swagger_ui_html() ──────────────▶ HTMLResponse
  └ /docs                   │
                            ├─ root_path取得
                            ├─ openapi_url計算
                            ├─ oauth2_redirect_url計算
                            │
                            └─ get_swagger_ui_html()
                                   │
                                   ├─ パラメータマージ
                                   ├─ HTML文字列構築
                                   └─ HTMLResponse生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| docs.py | `fastapi/openapi/docs.py` | ソース | Swagger UI HTML生成の主要ロジック |
| applications.py | `fastapi/applications.py` | ソース | FastAPIアプリケーションのセットアップとルート登録 |
| utils.py | `fastapi/openapi/utils.py` | ソース | OpenAPIスキーマ生成（Swagger UIが参照） |
| encoders.py | `fastapi/encoders.py` | ソース | JSONエンコーディング処理 |
| responses.py | `fastapi/responses.py` | ソース | レスポンスクラスの定義（HTMLResponse等） |
